const isolateBackend = require('./isolate')
const fs = require('fs')
const { spawn } = require('child_process');

function runIsolate(filename) {
    return new Promise((resolve, reject) => {
        let timeStart = Date.now()
        let { isolate, context } = isolateBackend.createIsolate();

        fs.readFile(filename, 'utf-8', (err, data) => {

            if (err)
                reject(err);
            isolate.compileScript(data).then(script => {
                script.run(context)
                    .then(result => {
                        console.log(result);
                        let timeDifference = Math.ceil((Date.now() - timeStart))
                        console.log("isolate time taken: ", timeDifference);
                        resolve(result);
                    });
            }).catch(err => { reject(err) })
        });
    });

}

function runProcess(filename) {
    return new Promise((resolve, reject) => {
        let timeStart = Date.now()
        const process = spawn('node', [filename]);
        let result = "";
        process.stdout.on('data', (data) => {
            console.log(`stdout: ${data}`);
            result += data;
            let timeDifference = Math.ceil((Date.now() - timeStart))
            console.log("process time taken: ", timeDifference);
        });

        process.stderr.on('data', (data) => {
            console.error(`stderr: ${data}`);
            reject(data);
        });

        process.on('close', (code) => {
            console.log(`child process exited with code ${code}`);
            resolve(result);
        });
    })

}


function runContainer(imageName) {
    console.log(imageName);

    return new Promise((resolve, reject) => {
        let timeStart = Date.now()
        const process = spawn('docker', ["run", "--name", imageName, imageName]);
        let result = "";
        process.stdout.on('data', (data) => {
            console.log(`stdout: ${data}`);
            let timeDifference = Math.ceil((Date.now() - timeStart))
            console.log("container run time taken: ", timeDifference);
            result += data;
        });

        process.stderr.on('data', (data) => {
            console.error(`stderr: ${data}`);
            reject(data);
        });

        process.on('close', (code) => {
            resolve(result);
        })
    })

}

module.exports.runContainer = runContainer;
module.exports.runProcess = runProcess;
module.exports.runIsolate = runIsolate;