package com.example.infiniteLoop.parkingo;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import androidx.annotation.NonNull;

import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FirebaseFirestore;

import java.util.HashMap;
import java.util.Map;

import static androidx.constraintlayout.widget.Constraints.TAG;

public class login_activity extends Activity {
    EditText username,password;
    Button login_btn;
    ProgressDialog progress;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.login_layout);
        username=findViewById(R.id.username);
        password=findViewById(R.id.password);
        login_btn=findViewById(R.id.login_btn);
        login_btn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                //Toast.makeText(login_activity.this,"button clicked",Toast.LENGTH_SHORT).show();

                String uname=username.getText().toString().trim();
                String pass=password.getText().toString().trim();
                if(uname.isEmpty() || pass.isEmpty()){
                    username.setError("Fields cannot be Empty");
                    username.requestFocus();
                }
                else{
                        sqlite_ops so=new sqlite_ops(login_activity.this);
                        //so.insert_login_details();
                    login li=new login();
                    li.setPass(uname);
                    li.setUname(pass);
                    so.fetch_login_details(li,login_activity.this);
                    progress = new ProgressDialog(login_activity.this);
                    progress.setTitle("Loading");
                    progress.setMessage("Wait while loading...");
                    progress.setCancelable(false); // disable dismiss by tapping outside of the dialog
                    progress.show();

                    /*if(so.fetch_login_details(li,login_activity.this)){
                        Toast.makeText(login_activity.this,"Login_Success",Toast.LENGTH_SHORT).show();
                        startActivity(new Intent(login_activity.this,dashboard.class));
                        finish();
                    }

                    else{
                        Toast.makeText(login_activity.this,"failed",Toast.LENGTH_SHORT).show();
                        username.setText("");
                        username.setError("Wrong Credentials");
                        password.setText("");
                        username.requestFocus();
                    }*/
                }
            }
        });

    }

    public void loginSuccess() {
        // To dismiss the dialog
        progress.dismiss();
        Toast.makeText(login_activity.this,"Login_Success",Toast.LENGTH_SHORT).show();
        startActivity(new Intent(login_activity.this,dashboard.class));
        finish();
    }

    public void loginFailure() {
        // To dismiss the dialog
        progress.dismiss();
        Toast.makeText(login_activity.this,"failed",Toast.LENGTH_SHORT).show();
        username.setText("");
        username.setError("Wrong Credentials");
        password.setText("");
        username.requestFocus();
    }

    @Override
    public void onBackPressed() {
        AlertDialog.Builder builder= new AlertDialog.Builder(this);
        builder.setTitle("Are you sure ? you want to exit.");
        builder.setPositiveButton("Exit", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                finish();
            }
        })
                .setNegativeButton("Cancel",new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {

                    }
                });
        builder.create().show();
    }
}
