package com.example.infiniteLoop.parkingo;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import java.lang.reflect.Array;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class checkout extends Activity {
    EditText tkt_no,slot_no;
    TextView name,mobile,date_tv,slot,vehicle,tkt_tv,ischeckedout;
    Button checkout;
    String slot_number,ticket_number;
    LinearLayout innerll;
    ArrayList ticketData;
    ProgressDialog progress;
    long checkInTimeLong;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.checkout_layout);
        tkt_no=findViewById(R.id.tkt);
        slot_no=findViewById(R.id.slot_no);

        name=findViewById(R.id.name);
        slot=findViewById(R.id.slot);
        mobile=findViewById(R.id.mobile);
        date_tv=findViewById(R.id.date_tv);
        vehicle=findViewById(R.id.vehicle);
        tkt_tv=findViewById(R.id.tkt_tv);
        ischeckedout=findViewById(R.id.ischeckedout);
        checkout=findViewById(R.id.checkout);
        innerll=findViewById(R.id.innerll);


        Intent i=getIntent();
        if(i.hasExtra("slot")){
            slot_no.setText(i.getExtras().get("slot").toString());

            getSlotDetails(null);


        }
    }
    //abcdefghijklmnopqrstuvwxyzchecking
    @Override
    public void onBackPressed() {
        Intent i=getIntent();
        if(i.hasExtra("slot")){
            startActivity(new Intent(this,currentParks.class));
        }
        else {
            startActivity(new Intent(this, dashboard.class));
            finish();
        }
        //super.onBackPressed();
    }

    public void confirm_checkout(){
        if(ticket_number!=null && slot_number!=null){
            // Log.e(TAG, "checkout: "+slot_number );
            if(slot_number.equals("none")){
                Toast.makeText(this,"Select Valid Ticket",Toast.LENGTH_SHORT).show();
            }
            else{
                sqlite_ops so=new sqlite_ops(this);
                so.check_out(slot_number,ticket_number,checkInTimeLong,this);
                progress = new ProgressDialog(checkout.this);
                progress.setTitle("Checking out");
                progress.setMessage("Calculating parking charge...");
                progress.setCancelable(false); // disable dismiss by tapping outside of the dialog
                progress.show();

                }
        }
    }

    public void checkoutSuccess(Long checkoutDateTime,int charges) {
        progress.dismiss();
        Intent i = new Intent(this, ticket.class);
        long datetime = Long.parseLong(checkoutDateTime.toString());
        Date date = new Date(datetime*1000);
        Format format = new SimpleDateFormat("dd/MM/yy HH:mm");
        String dateString = format.format(date);
        ticketData.add(6,dateString);
        ticketData.add(7,charges);
        i.putExtra("ticket_data", ticketData);
        i.putExtra("ticket_no",ticket_number);
        i.putExtra("checkout",true);
        startActivity(i);
        Toast.makeText(this,"Successfully,Checked Out",Toast.LENGTH_SHORT).show();
    }

    public void checkoutFailed() {
        progress.dismiss();
        Toast.makeText(this,"Error! Contact Developer",Toast.LENGTH_SHORT).show();
    }

    public void checkout(View view) {
        AlertDialog.Builder builder= new AlertDialog.Builder(this);
        builder.setTitle("Do you want to Checkout?");
        builder.setPositiveButton("Checkout", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                confirm_checkout();
            }
        })
                .setNegativeButton("Cancel",new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {

                    }
                });
        builder.create().show();
    }

    public void reprint(View view) {
        //Log.e(TAG, "reprint: "+ticket_number );
        if(ticket_number!=null){
            if(slot_number.equals("none")){
                Toast.makeText(this,"Select Valid Ticket",Toast.LENGTH_SHORT).show();
            }
            else {
                Intent i = new Intent(this, ticket.class);
                i.putExtra("ticket_data", ticketData);
                i.putExtra("ticket_no", ticket_number);
                i.putExtra("reprint",1);
                startActivity(i);
            }
        }
    }

    public void getTktDetails(View view) {
        String tkt=tkt_no.getText().toString().trim();
        if(!tkt.isEmpty()){
            long tktlong=Long.parseLong(tkt);
            sqlite_ops so=new sqlite_ops(this);
            ArrayList data=so.fetch_ticket_detail(tktlong);
            name.setText(data.get(4).toString());
            slot.setText(data.get(1).toString());
            date_tv.setText(data.get(3).toString());
            vehicle.setText(data.get(2).toString());
            mobile.setText(data.get(5).toString());
            tkt_tv.setText(data.get(0).toString());
            String checkout_status=data.get(6).toString();
            if(checkout_status.equals("1")){
                ischeckedout.setText("Checked Out!!!");
                ischeckedout.setVisibility(View.VISIBLE);
                checkout.setVisibility(View.GONE);
            }
            slot_number=data.get(1).toString();
            ticket_number=data.get(0).toString();
            innerll.setVisibility(View.VISIBLE);
        }
    }

    public void getSlotDetails(View view) {
        String slotStr=slot_no.getText().toString().trim();
        if(!slotStr.isEmpty()){

            sqlite_ops so=new sqlite_ops(this);
            so.fetch_slot_details(slotStr.toUpperCase(),this);
            progress = new ProgressDialog(checkout.this);
            progress.setTitle("Loading");
            progress.setMessage("Getting parking info...");
            progress.setCancelable(false); // disable dismiss by tapping outside of the dialog
            progress.show();
        }
    }

    public void  showTicketDetails(ArrayList data) {
        name.setText(data.get(4).toString());
        slot.setText(data.get(1).toString());
        checkInTimeLong = Long.parseLong(data.get(3).toString());
        Date date = new Date(checkInTimeLong*1000);
        Format format = new SimpleDateFormat("dd/MM/yy HH:mm");
        String dateString = format.format(date);
        data.add(3,dateString);
        date_tv.setText(dateString);
        vehicle.setText(data.get(2).toString());
        mobile.setText(data.get(5).toString());
        tkt_tv.setText(data.get(0).toString().toUpperCase().substring(0,4));

        slot_number=data.get(1).toString();
        ticket_number=data.get(0).toString();
        innerll.setVisibility(View.VISIBLE);
        ticketData = data;
        progress.dismiss();
    }
}
