package com.example.infiniteLoop.parkingo;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.InputType;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;
import androidx.cardview.widget.CardView;

import io.opencensus.internal.StringUtils;

public class wallets extends Activity {
    String top_up_text;
    TextView wdraw;
    TextView balance;
    CardView topupButton;

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_wallets);
        wdraw= findViewById(R.id.uname);
        balance=findViewById(R.id.balance_amount);
        topupButton =findViewById(R.id.topup);
        userInfo uinfo=userInfo.getInstance();

        balance.setText("\u20B9 "+uinfo.getBalance());

        wdraw.setText("Hello ".toUpperCase()+uinfo.getName().toUpperCase());
        topupButton.setOnClickListener(new View.OnClickListener(){
            @Override public  void onClick(View v) {
                top_up();
            }
        });
    }

    private void top_up() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("Enter amount to top up with");
        final EditText input = new EditText(this);
        input.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_CLASS_NUMBER);
        builder.setView(input);
        builder.setPositiveButton("ADD", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                top_up_text = input.getText().toString();
                userInfo uinfo = userInfo.getInstance();
                int newBalance = Integer.parseInt(top_up_text)+uinfo.getBalance();
                uinfo.setBalance(newBalance);
                balance.setText("\u20B9 "+uinfo.getBalance());
               
            }
        });
        builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        });

        builder.show();


    }
}
