package com.example.infiniteLoop.parkingo;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;

import androidx.annotation.Nullable;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.RadioButton;
import android.widget.RadioGroup;

import java.util.ArrayList;

/*! \class A Category_wise_availabiltiy class
    A class to return the avaialability of free slots depending on whether the user  has selected car or bike.
*/
public class category_wise_availability extends Activity {
    RadioGroup rg;
    String result;
    ListView lv;
    ArrayList slots;
    ProgressDialog progress;
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.category_wise_availability_layout);
        rg=findViewById(R.id.rg);
        lv=findViewById(R.id.lv);
    }
   /** @brief Displays the progress bar while the available slots being loaded
    @param v - View of the calling acitivity
    @retrun void
    */
    public void getAvailability(View v){
        boolean checked=((RadioButton)v).isChecked();
        if(v.getId()==R.id.car){
            if(checked){
                sqlite_ops so=new sqlite_ops(this);
                slots=so.getFreeSlots(this,"car");
                progress = new ProgressDialog(category_wise_availability.this);
                progress.setTitle("Loading");
                progress.setMessage("Wait while loading...");
                progress.setCancelable(false); // disable dismiss by tapping outside of the dialog
                progress.show();
            }

        }
        else if(v.getId()==R.id.bike){
            if(checked){
                sqlite_ops so=new sqlite_ops(this);
                slots=so.getFreeSlots(this,"bike");
                progress = new ProgressDialog(category_wise_availability.this);
                progress.setTitle("Loading");
                progress.setMessage("Wait while loading...");
                progress.setCancelable(false); // disable dismiss by tapping outside of the dialog
                progress.show();
            }
        }


    }
   /** @brief Displays the free slot to the calling activity
    @param slots - An ArrayList
    @retrun void
    */
    public void returnSlots(final ArrayList slots){
        progress.dismiss();
        if(slots.size()>0){
                    ArrayAdapter aa=new ArrayAdapter(this,R.layout.spinner_layout,slots);
                    lv.setAdapter(aa);
                }
                else{
                    ArrayAdapter aa=new ArrayAdapter(this,R.layout.spinner_layout,new String[]{"No free slots"});
                    lv.setAdapter(aa);
                }
                lv.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                    @Override
                    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                        if(slots.size()>0){
                        result=slots.get(i).toString();
                        sendResult();
                        }
                    }
                });
    }
   /** @brief Returns the free slot result to the calling activity
    @retrun void
    */
    public void sendResult(){
        Intent returnResult=getIntent();
        returnResult.putExtra("result",result);
        setResult(RESULT_OK,returnResult);
        if(returnResult.hasExtra("callingActivity")) {
            finish();
        }
    }
}
