#include <vector>
#include <bits/stdc++.h>
#include <grpcpp/grpcpp.h>
#include <string>
#include "keyvaluestore.grpc.pb.h"

using namespace std;

using grpc::Channel;
using grpc::ClientContext;
using grpc::Status;

using keyvaluestore::Key;
using keyvaluestore::KeyValue;
using keyvaluestore::KeyValueServices;
using keyvaluestore::ReqStatus;
using keyvaluestore::Value;

std::map<std::string, std::string> params;
std::string config_filename = "../config";

int requests;

void getConfig() {
  std::string line;
  std::ifstream config(config_filename);

  while (getline(config, line)) {
    char temp[line.length()];
    strcpy(temp, line.c_str());
    char *token1 = strtok(temp, "=");
    char *token2 = strtok(NULL, "-");
    params[token1] = token2;
  }
  config.close();
}

class KeyValueServicesClient {
public:
  KeyValueServicesClient(std::shared_ptr<Channel> channel)
      : stub_(KeyValueServices::NewStub(channel)) {}

  // Assembles client payload, sends it to the server, and returns its response
  std::string GET(std::string key)
  {
    // Data to be sent to server
    Key request;
    request.set_key(key);

    // Container for server response
    Value reply;

    // Context can be used to send meta data to server or modify RPC behaviour
    ClientContext context;

    // Actual Remote Procedure Call
    Status status = stub_->GET(&context, request, &reply);

    // Returns results based on RPC status
    if (status.ok())
    {
      return reply.value();
    }
    else
    {
      return "RPC Failed";
    }
  }

  int PUT(std::string key, std::string value)
  {
    // Data to be sent to server
    KeyValue request;
    request.set_key(key);
    request.set_value(value);

    // Container for server response
    ReqStatus reply;

    // Context can be used to send meta data to server or modify RPC behaviour
    ClientContext context;

    // Actual Remote Procedure Call
    Status status = stub_->PUT(&context, request, &reply);

    // Returns results based on RPC status
    if (status.ok())
    {
      if (reply.status() == 400)
        // std::cout<<"Error: "<<reply.error()<<std::endl;
        return reply.status();
    }
    else
    {
      return -1;
    }
    // std::cout<<"200"<<std::endl;
    return 0;
  }

  int DEL(std::string key)
  {
    // Data to be sent to server
    Key request;
    request.set_key(key);

    // Container for server response
    ReqStatus reply;

    // Context can be used to send meta data to server or modify RPC behaviour
    ClientContext context;

    // Actual Remote Procedure Call
    Status status = stub_->DEL(&context, request, &reply);

    // Returns results based on RPC status
    if (status.ok())
    {
      if (reply.status() == 400)
        return reply.status();
    }
    else
    {
      return -1;
    }
  }

private:
  std::unique_ptr<KeyValueServices::Stub> stub_;
};

std::string gen_random(const int len)
{
  std::string tmp_s;
  string alphanum =
      "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

  tmp_s.reserve(len);

  for (int i = 0; i < len; ++i)
    tmp_s += alphanum[rand() % alphanum.size()];

  return tmp_s;
}

int main(int argc, char *argv[])
{

  srand((unsigned)time(NULL) * getpid());

  requests = stoi(argv[1]);
  vector<string> keys(requests);

  double total = 0;

  std::string target_address("0.0.0.0:50051");

  KeyValueServicesClient client(
      grpc::CreateChannel(target_address,
                          grpc::InsecureChannelCredentials()));

  for (int i = 0; i < requests; i++)
  {
    std::string key = gen_random(30);
    keys[i] = key;
    std::string value = "Kamal Vishal Mayank kvm are the author";

    clock_t begin = clock();
    client.PUT(key, value);
    clock_t end = clock();

    total += (double(end - begin) / CLOCKS_PER_SEC * 1000);
  }

  cout << total / requests << " ";

  total = 0;
  for (string key : keys)
  {
    clock_t begin = clock();
    client.GET(key);
    clock_t end = clock();

    total += (double(end - begin) / CLOCKS_PER_SEC * 1000);
  }

  cout << total / requests << "\n";
  return 0;
}
