#include <vector>
#include <bits/stdc++.h>
#include <grpcpp/grpcpp.h>
#include <string>
#include "keyvaluestore.grpc.pb.h"

using grpc::Channel;
using grpc::ClientContext;
using grpc::Status;

using keyvaluestore::Key;
using keyvaluestore::Value;
using keyvaluestore::KeyValue;
using keyvaluestore::ReqStatus;
using keyvaluestore::KeyValueServices;
using keyvaluestore::Info;
using keyvaluestore::Null;

std::map<std::string, std::string> params;
std::string config_filename = "../config";
void getConfig() {
    std::string line;
    std::ifstream config(config_filename);

    while (getline(config, line)) {
        char temp[line.length()];
        strcpy(temp, line.c_str());
        char *token1 = strtok(temp, "=");
        char *token2 = strtok(NULL, "-");
        params[token1] = token2;
    }
    config.close();
}

class KeyValueServicesClient {
 public:
  KeyValueServicesClient(std::shared_ptr<Channel> channel)
      : stub_(KeyValueServices::NewStub(channel)) {}

  // Assembles client payload, sends it to the server, and returns its response
  std::string GET(std::string key) {
    // Data to be sent to server
    Key request;
    request.set_key(key);

    // Container for server response
    Value reply;

    // Context can be used to send meta data to server or modify RPC behaviour
    ClientContext context;

    // Actual Remote Procedure Call
    Status status = stub_->GET(&context, request, &reply);

    // Returns results based on RPC status
    if (status.ok()) {
      if(reply.value()=="Key not found")
        std::cout<<"Status : 400"<<std::endl;
      else
        std::cout<<"Status : 200"<<std::endl;
      return reply.value();
    } else {
      std::cout << status.error_code() << ": " << status.error_message()
                << std::endl;
      return "RPC Failed";
    }
  }

  int PUT(std::string key, std::string value) {
    // Data to be sent to server
    KeyValue request;
    request.set_key(key);
    request.set_value(value);

    // Container for server response
    ReqStatus reply;

    // Context can be used to send meta data to server or modify RPC behaviour
    ClientContext context;

    // Actual Remote Procedure Call
    Status status = stub_->PUT(&context, request, &reply);

    // Returns results based on RPC status
    if (status.ok()) {
      if(reply.status()==400)
        std::cout<<"Error: "<<reply.error()<<std::endl;
      return reply.status();
    } else {
      std::cout << status.error_code() << ": " << status.error_message()
                << std::endl;
      return -1;
    }
  }

  int DEL(std::string key) {
    // Data to be sent to server
    Key request;
    request.set_key(key);

    // Container for server response
    ReqStatus reply;

    // Context can be used to send meta data to server or modify RPC behaviour
    ClientContext context;

    // Actual Remote Procedure Call
    Status status = stub_->DEL(&context, request, &reply);

    // Returns results based on RPC status
    if (status.ok()) {
      if(reply.status()==400)
        std::cout<<"Error: "<<reply.error()<<std::endl;
      return reply.status();
    } else {
      std::cout << status.error_code() << ": " << status.error_message()
                << std::endl;
      return -1;
    }
  }

 private:
  std::unique_ptr<KeyValueServices::Stub> stub_;
};

void parse(std::string& str, std::string& cmd, std::string& key, std::string& value) {
  int i = 0;
  cmd = key = value = "";
  while(i < str.length() && str[i] == ' ')
    i++;
  for( ; i < str.length(); i++) {
    if(str[i] != ' ')
      cmd += str[i];
    else break;
  }
  
  while(i < str.length() && str[i] == ' ')
    i++;
  for( ; i < str.length(); i++) {
    if(str[i] != ' ')
      key += str[i];
    else break;
  }
  
  while(i < str.length() && str[i] == ' ')
    i++;
  for( ; i < str.length(); i++) {
    if(str[i] != ' ')
      value += str[i];
    else break;
  }
}

void RunClient() {
  std::string dns_address("0.0.0.0:1234");
  std::shared_ptr<Channel> channel=grpc::CreateChannel(dns_address, grpc::InsecureChannelCredentials());
  std::unique_ptr<KeyValueServices::Stub> stub=KeyValueServices::NewStub(channel);
  Null null;
  null.set_nothing(0);
  Info info;
  ClientContext context;
  Status status=stub->GETADDRESS(&context,null,&info);
  std::string target_address(info.address());
  // Instantiates the client
  KeyValueServicesClient client(
      // Channel from which RPCs are made - endpoint is the target_address
      grpc::CreateChannel(target_address,
                          // Indicate when channel is not authenticated
                          grpc::InsecureChannelCredentials()));

  // std::string response;
  // std::string key = "KAMAL";
  // std::string value = "+91 98254 00172";

  // // RPC is created and response is stored
  // client.PUT(key, value);
  // response = client.GET(key);

  // // Prints results
  // std::cout << "Value string: " << response << std::endl;
  

  std::string cmd, key, value;
  /*std::cout<<"GET: "<<client.GET("a")<<std::endl;
  std::cout<<"PUT: "<<client.PUT("a","b")<<std::endl;
  std::cout<<"DEL: "<<client.DEL("a")<<std::endl;*/

  while(1) {
    int choice;
    std::cout<<std::endl<<"1. Batch Mode"<<std::endl<<"2. Interactive Mode"<<std::endl<<"3. exit"<<std::endl;
    std::cout<<std::endl<<"Enter Your choice : ";
    std::cin>>choice;

    if(choice == 1) {
      std::string file_name;
      std::cout<<"Enter the file name : ";
      std::cin>>file_name;

      std::ifstream file(file_name);
      std::string str;

      double minTime = INT_MAX, maxTime = 0, avgTime = 0, lineCount = 0;
      clock_t begin, end;

      while (std::getline(file, str)) {
        parse(str, cmd, key, value);

        if(cmd == "GET") {
          begin = clock();
          std::string response = client.GET(key);
          end = clock();
          std::cout<<"Response from Server: "<<response<<std::endl;
        } else if(cmd == "DEL") {
          begin = clock();
          int response = client.DEL(key);
          std::cout<<"Status : "<<response<<std::endl;
          end = clock();
        } else if(cmd == "PUT") {
          begin = clock();
          int response = client.PUT(key, value);
          std::cout<<"Status : "<<response<<std::endl;
          end = clock();
        }

        lineCount++;
        minTime = std::min((double(end - begin) / CLOCKS_PER_SEC*1000), minTime);
        maxTime = std::max((double(end - begin) / CLOCKS_PER_SEC*1000), maxTime);
        avgTime += (double(end - begin) / CLOCKS_PER_SEC*1000);
      }

      if(lineCount == 0)
        minTime = avgTime = maxTime = 0;
      else
        avgTime /= lineCount;
      std::cout<<std::endl<<"Average Response In: "<<avgTime<<" ms"<<std::endl;
      std::cout<<"Minimum Response In: "<<minTime<<" ms"<<std::endl;
      std::cout<<"Maximum Response In: "<<maxTime<<" ms"<<std::endl;

    } else if(choice == 2) {  
      std::cout<<"Enter the command : ";
      std::cin>>cmd;

      if(cmd == "GET") {
        std::cout<<"Enter the key : ";   
        std::cin>>key;
        // std::cout<<cmd<<"-"<<key<<"-"<<std::endl;

        clock_t begin = clock();
        std::string response = client.GET(key);
        clock_t end = clock();
        std::cout<<"Response from Server : "<<response<<std::endl;
        std::cout<<"Response In: "<<double(end - begin) / CLOCKS_PER_SEC*1000<<" ms"<<std::endl;

      } else if(cmd == "DEL") {
        std::cout<<"Enter the key : ";   
        std::cin>>key;

        clock_t begin = clock();
        int response = client.DEL(key);
        std::cout<<"Status : "<<response<<std::endl;
        clock_t end = clock();
        std::cout<<"Response In: "<<double(end - begin) / CLOCKS_PER_SEC*1000<<" ms"<<std::endl;

      } else if(cmd == "PUT") {
        std::cout<<"Enter the key : ";   
        std::cin>>key;
        std::cout<<"Enter the value : ";   
        std::cin>>value;
        // std::cout<<cmd<<"-"<<key<<"-"<<value<<std::endl;

        clock_t begin = clock();
        int response = client.PUT(key, value);
        std::cout<<"Status : "<<response<<std::endl;
        clock_t end = clock();
        std::cout<<"Response In: "<<double(end - begin) / CLOCKS_PER_SEC*1000<<" ms"<<std::endl;
      }
    } else if(choice == 3) {
      exit(-1);
    }
    else {

    }
  }
}

int main(int argc, char* argv[]) {
  getConfig();
  RunClient();
  return 0;
}
