#include <bits/stdc++.h>
#include <pthread.h>
#include <grpcpp/grpcpp.h>
#include "keyvaluestore.grpc.pb.h"
#include "../Backend.h"

using namespace std;

using grpc::Server;
using grpc::ServerAsyncResponseWriter;
using grpc::ServerBuilder;
using grpc::ServerCompletionQueue;
using grpc::ServerContext;
using grpc::Status;
using keyvaluestore::Key;
using keyvaluestore::KeyValue;
using keyvaluestore::KeyValueServices;
using keyvaluestore::ReqStatus;
using keyvaluestore::Value;

pthread_mutex_t _masterLock;

enum RequestType {
    GET,
    PUT,
    DEL
};

map<string, string> params;
string config_filename = "../config";
string log_file = "../log";
ServerBuilder builder;
KeyValueServices::AsyncService service;
std::unique_ptr<Server> server;

pthread_t *workers;
int *worker_id;
pthread_cond_t startRpcs;
pthread_mutex_t myLock;
bool start;

memoryManagement *memManager;

void getConfig() {
    string line;
    ifstream config(config_filename);

    while (getline(config, line)) {
        char temp[line.length()];
        strcpy(temp, line.c_str());
        char *token1 = strtok(temp, "=");
        char *token2 = strtok(NULL, "-");
        params[token1] = token2;
    }
    config.close();
}

class CallData {
public:
    CallData(KeyValueServices::AsyncService *service, ServerCompletionQueue *cq, RequestType reqType) : service(service), cq(cq), getResponder(&context), putResponder(&context), delResponder(&context), status(CREATE), reqType(reqType) {
        Proceed();
    }

    void Proceed() {
        if (status == CREATE) {
            status = PROCESS;
            if (reqType == GET)
                service->RequestGET(&context, &key, &getResponder, cq, cq, this);
            else if (reqType == PUT)
                service->RequestPUT(&context, &keyvalue, &putResponder, cq, cq, this);
            else
                service->RequestDEL(&context, &key, &delResponder, cq, cq, this);
        } else if (status == PROCESS) {
            new CallData(service, cq, reqType);
            if (reqType == GET) {
                cout << "SERVER SERVES A GET REQUEST WITH PARAMETER KEY : " << key.key();
                int status = 200;
                pthread_mutex_lock(&_masterLock);
                string v = memManager->get(&status, key.key());
                pthread_mutex_unlock(&_masterLock);

                value.set_value(v);
                if (status == 200)
                    value.set_status(200);
                else {
                    value.set_status(400);
                    value.set_error(v);
                }
                cout << " RETURN VALUE : " << value.value() << endl;
                getResponder.Finish(value, Status::OK, this);
            } else if (reqType == PUT) {
                cout << "SERVER SERVES A PUT REQUEST WITH PARAMETER KEY : " << keyvalue.key() << " & VALUE : " << keyvalue.value() << endl;

                pthread_mutex_lock(&_masterLock);
                memManager->put(keyvalue.key(), keyvalue.value());
                pthread_mutex_unlock(&_masterLock);

                stat.set_status(200);
                putResponder.Finish(stat, Status::OK, this);
            } else {
                cout << "SERVER SERVES A DEL REQUEST WITH PARAMETER KEY : " << key.key() << endl;
                int status = 200;

                pthread_mutex_lock(&_masterLock);
                memManager->del(&status, key.key());
                pthread_mutex_unlock(&_masterLock);

                if (status == 200)
                    stat.set_status(200);
                else {
                    stat.set_status(400);
                    stat.set_error("KEY NOT EXIST");
                }
                delResponder.Finish(stat, Status::OK, this);
            }
            /* --------------------------------CONTENT OF CACHE ONLY KEY-------------------------------- */
            memManager->traverse();
            status = FINISH;
        } else {
            GPR_ASSERT(status == FINISH);
            delete this;
        }
    }

private:
    KeyValueServices::AsyncService *service;
    ServerCompletionQueue *cq;
    ServerContext context;
    Key key;
    Value value;
    KeyValue keyvalue;
    ReqStatus stat;
    ServerAsyncResponseWriter<Value> getResponder;
    ServerAsyncResponseWriter<ReqStatus> putResponder;
    ServerAsyncResponseWriter<ReqStatus> delResponder;
    enum CallStatus {
        CREATE,
        PROCESS,
        FINISH
    };
    CallStatus status;
    RequestType reqType;
};

void setupServer(string server_address) {
    builder.AddListeningPort(server_address, grpc::InsecureServerCredentials());
    builder.RegisterService(&service);
}

void *handleRpcs(void *thread_id) {
    unique_ptr<ServerCompletionQueue> comp_queue = builder.AddCompletionQueue();
    pthread_mutex_lock(&myLock);
    while (!start)
        pthread_cond_wait(&startRpcs, &myLock);
    pthread_mutex_unlock(&myLock);
    new CallData(&service, comp_queue.get(), GET);
    new CallData(&service, comp_queue.get(), PUT);
    new CallData(&service, comp_queue.get(), DEL);
    void *tag;
    bool ok;
    while (true) {
        GPR_ASSERT(comp_queue->Next(&tag, &ok));
        GPR_ASSERT(ok);
        // cout << "Thread id:\t" << (*(int *)thread_id) << "\n";
        static_cast<CallData *>(tag)->Proceed();
    }
    return 0;
}

void assignThreads(int num_threads) {
    workers = (pthread_t *)malloc(sizeof(pthread_t) * num_threads);
    worker_id = (int *)malloc(sizeof(int) * num_threads);
    for (int i = 0; i < num_threads; i++) {
        worker_id[i] = i;
        pthread_create(&workers[i], NULL, handleRpcs, (void *)&worker_id[i]);
    }
}

void signalHandler(int signum) {
    memManager->pushAll();
    cout << "SERVER SHUTDOWN" << endl;
    server->Shutdown();
    exit(0);
}

int main(int agrc, char **argv) {
    pthread_mutex_init(&_masterLock, NULL);
    start = false;
    getConfig();

    int num_threads = stoi(params.find("NUM_SERVER_THREADS")->second);
    int port = stoi(params.find("LISTENING_PORT")->second);
    string server_address("0.0.0.0:" + to_string(port));
    string cache_type = params.find("CACHE_REPLACEMENT_TYPE")->second;
    pthread_cond_init(&startRpcs, NULL);
    pthread_mutex_init(&myLock, NULL);

    if (cache_type.compare("LFU") == 0)
        memManager = new storageLFU(stoi(params.find("CACHE_SIZE")->second));
    else
        memManager = new storageLRU(stoi(params.find("CACHE_SIZE")->second));

    setupServer(server_address);
    assignThreads(num_threads);
    sleep(1);
    signal(SIGINT, signalHandler);

    server = builder.BuildAndStart();
    start = true;
    cout << "SERVER COMES UP SUCCESSFULLY" << endl;

    pthread_cond_broadcast(&startRpcs);
    for (int i = 0; i < num_threads; i++)
        pthread_join(workers[i], NULL);

    free(workers);
    free(worker_id);
    return 0;
}
