#include <bits/stdc++.h>
#include "LRUNode.h"
#include <dirent.h>
#include <sys/stat.h>

#define NOT_EXIST "KEY NOT EXIST"

using namespace std;

inline bool fileExists(const std::string &name)
{
    struct stat buffer;
    return (stat(name.c_str(), &buffer) == 0);
}

string getFilename(string key)
{
    string filename = ".";
    int length = key.size();
    if (length == 1)
    {
        return "_.kvm";
    }
    filename += char(length - 1);
    filename += key;
    filename.pop_back();
    filename += ".kvm";
    return filename;
}

class LRUcache
{
private:
    int capacity;
    string deleted;
    Node *head;
    Node *tail;
    std::mutex mtx;
    unordered_map<string, Node *> cache;

public:
    LRUcache()
    {
        head = new Node("HEAD", "HEAD");
        tail = new Node("TAIL", "TAIL");
        head->next = tail;
        tail->prev = head;
        deleted = "";
        deleted += char(0);
    }

    void setCap(int capacity)
    {
        this->capacity = capacity;
    }

    LRUcache(int capacity)
    {
        this->capacity = capacity;
        head = new Node("HEAD", "HEAD");
        tail = new Node("TAIL", "TAIL");
        head->next = tail;
        tail->prev = head;
        deleted = "";
        deleted += char(0);
    }

    Node *getUtil(string key)
    {
        if (cache.find(key) == cache.end())
            return NULL;
        Node *x = cache[key];
        x->prev->next = x->next;
        x->next->prev = x->prev;

        x->next = head->next;
        x->next->prev = x;

        head->next = x;
        x->prev = head;

        return x;
    }

    string get(string key, int *status)
    {
        //std::lock_guard<std::mutex> guard(mtx);
        Node *x = getUtil(key);
        if (x)
        {
            if (x->payload == deleted)
            {
                *status = 400;
                return NOT_EXIST;
            }
            return x->payload;
        }

        string fileName = getFilename(key);

        if (!fileExists(fileName))
        {
            *status = 400;
            return NOT_EXIST;
        }

        ifstream fin;
        fin.open(fileName);

        string _key, val;

        unordered_map<string, string> flush;
        do
        {
            getline(fin, _key);
            if (_key.size() == 0)
                break;
            getline(fin, val);
            if (val != deleted)
                flush[_key] = val;
            else
                flush.erase(_key);

            if (fin.eof())
                break;
        } while (fin);
        fin.close();

        unordered_map<string, string>::iterator itr;
        for (itr = flush.begin(); itr != flush.end() && cache.size() < capacity - 1; itr++)
        {
            this->put(itr->first, itr->second);
            flush[itr->first] = deleted;
        }

        if (flush.find(key) != flush.end())
        {
            this->put(key, flush[key]);
            flush[key] = deleted;
        }

        const char *c = fileName.c_str();
        remove(c);

        ofstream fout;
        fout.open(fileName);
        for (itr = flush.begin(); itr != flush.end(); itr++)
        {
            if (itr->second == deleted)
                continue;
            fout << itr->first << "\n";
            fout << itr->second << "\n";
        }
        fout.close();
        x = getUtil(key);
        if (x)
        {
            return x->payload;
        }
        *status = 400;

        return NOT_EXIST;
    }

    void del(string key, int *status)
    {
        int status2 = 200;
        string result = get(key, &status2);
        // mtx.lock();

        if (status2 == 400)
        {
            *status = 400;
            // mtx.unlock();
            return;
        }

        this->put(key, deleted);
        // mtx.unlock();
    }

    void pushAll()
    {
        unordered_map<string, Node *>::iterator itr;
        for (itr = cache.begin(); itr != cache.end(); itr++)
        {
            string fileName = getFilename(itr->first);

            ofstream fout;
            fout.open(fileName, ios::app);
            fout << itr->first << "\n";
            fout << itr->second->payload << "\n";
            fout.close();

            delete (itr->second);
        }
        cache.clear();
        head->next = tail;
        tail->prev = head;
    }

    void put(string key, string payload)
    {
        //mtx.lock();
        if (getUtil(key) != NULL)
            cache[key]->payload = payload;
        else
        {
            if (cache.size() == capacity)
            {
                Node *x = tail->prev;
                string keyToBeFlushed = x->key;
                cache.erase(keyToBeFlushed);
                cache[key] = x;

                // write to the file
                ofstream fout;
                string fileName = getFilename(keyToBeFlushed);
                fout.open(fileName, ios::app);
                fout << x->key << "\n";
                fout << x->payload << "\n";
                fout.close();

                x->key = key;
                x->payload = payload;
                x->prev->next = x->next;
                x->next->prev = x->prev;

                x->next = head->next;
                x->next->prev = x;

                head->next = x;
                x->prev = head;
            }
            else
            {
                Node *x = new Node(key, payload);
                cache[key] = x;
                x->next = head->next;
                x->next->prev = x;

                head->next = x;
                x->prev = head;
            }
        }
        //mtx.unlock();
    }

    void traverse()
    {
        Node *temp = head->next;
        while (temp->next)
        {
            cout << temp->key << "\n";
            temp = temp->next;
        }
        cout << "\n";
    }

    int hash(string s)
    {
        return (((int)s.at(0)) << 8) + ((int)s.at(1));
    }

    // key1;key2;key3;;value1;value2;value3;
    string getKeyValuePairs(int newId, int id)
    {
        unordered_map<string, string> flush;
        string keyValPairs = "";
        DIR *dirFile = opendir(".");
        if (dirFile)
        {
            struct dirent *hFile;
            while ((hFile = readdir(dirFile)) != NULL)
            {
                string fName(hFile->d_name);
                string fileName(hFile->d_name);
                int n;
                if ((n = fileName.size()) < 8)
                    continue;
                if (fileName[n - 3] == 'k' && fileName[n - 2] == 'v' && fileName[n - 1] == 'm')
                {
                    fileName.erase(n - 4);
                    fileName = fileName.substr(2);
                    if (hash(fileName) <= newId && hash(fileName) > id)
                    {
                        ifstream fin;
                        fin.open(fName);
                        string _key, val;

                        do
                        {
                            getline(fin, _key);
                            if (_key.size() == 0)
                                break;
                            getline(fin, val);
                            if (val != deleted)
                                flush[_key] = val;
                            else
                                flush.erase(_key);

                            if (fin.eof())
                                break;
                        } while (fin);

                        fin.close();
                        const char *c = fName.c_str();
                        remove(c);
                    }
                }
            }
            closedir(dirFile);
        }

        Node *temp = head->next;
        while (temp->next)
        {
            if (hash(temp->key) <= newId && hash(temp->key) > id)
            {
                flush[temp->key] = temp->payload;
            }
            temp = temp->next;
        }

        unordered_map<string, string>::iterator itr;
        for (itr = flush.begin(); itr != flush.end(); itr++)
            keyValPairs += itr->first + ";";

        keyValPairs += ";";
        for (itr = flush.begin(); itr != flush.end(); itr++)
            keyValPairs += itr->second + ";";

        return keyValPairs;
    }
};
