#include <bits/stdc++.h>
#include <dirent.h>
#include <fstream>
#include "LFUNode.h"
#define CACHE_FULL "Cache Full"
#define INSERT_SUCCESS "Insert Success"
#define CACHE_EMPTY "Cache Empty"
#define DELETE_SUCCESS "Delete Success"
#define KEY_NOT_FOUND "Key not found"
#define CAPACITY 5

using namespace std;

class LFUCache
{
private:
    int capacity;
    LFUNode **cacheHeap;
    int curr_pos;
    std::mutex mtx;
    string deleted;

    int parent(int i)
    {
        if (i % 2 == 0)
            return (i / 2) - 1;
        else
            return (i - 1) / 2;
    }

    int left_child(int i)
    {
        return (2 * i) + 1;
    }

    int right_child(int i)
    {
        return (2 * i) + 2;
    }

    int exists(string key)
    {
        for (int i = curr_pos; i >= 0; i--)
            if (key.compare(cacheHeap[i]->key) == 0)
                return i;
        return -1;
    }

    void swap(int i, int j)
    {
        cacheHeap[i]->frequency = cacheHeap[i]->frequency + cacheHeap[j]->frequency;
        cacheHeap[j]->frequency = cacheHeap[i]->frequency - cacheHeap[j]->frequency;
        cacheHeap[i]->frequency = cacheHeap[i]->frequency - cacheHeap[j]->frequency;
        string temp = cacheHeap[i]->key;
        cacheHeap[i]->key = cacheHeap[j]->key;
        cacheHeap[j]->key = temp;
        temp = cacheHeap[i]->value;
        cacheHeap[i]->value = cacheHeap[j]->value;
        cacheHeap[j]->value = temp;
    }

    void heapify_up(int i)
    {
        while (true)
        {
            if (i == 0)
                break;
            if (cacheHeap[parent(i)]->frequency <= cacheHeap[i]->frequency)
                break;
            else
                swap(i, parent(i));
            i = parent(i);
        }
    }

    void heapify_down(int i)
    {
        while (true)
        {
            if (left_child(i) > curr_pos)
                break;
            if (right_child(i) > curr_pos && cacheHeap[left_child(i)]->frequency >= cacheHeap[i]->frequency)
                break;
            if (right_child(i) <= curr_pos)
            {
                if (cacheHeap[left_child(i)]->frequency >= cacheHeap[i]->frequency && cacheHeap[right_child(i)]->frequency >= cacheHeap[i]->frequency)
                    break;
            }
            if (right_child(i) <= curr_pos)
            {
                if (cacheHeap[left_child(i)]->frequency < cacheHeap[right_child(i)]->frequency)
                    swap(i, left_child(i));
                else
                    swap(i, right_child(i));
            }
            else
                swap(i, left_child(i));
        }
    }

    string insert(string key, string value)
    {
        int i = exists(key);
        if (i != -1)
        {
            cacheHeap[i]->frequency++;
            cacheHeap[i]->value = value;
            heapify_down(i);
            return INSERT_SUCCESS;
        }
        curr_pos++;
        if (curr_pos == capacity)
        {
            curr_pos--;
            delete_min(true);
            insert(key, value);
            return INSERT_SUCCESS;
        }
        cacheHeap[curr_pos]->key = key;
        cacheHeap[curr_pos]->value = value;
        cacheHeap[curr_pos]->frequency = 1;
        heapify_up(curr_pos);
        return INSERT_SUCCESS;
    }

    string delete_min(bool keep)
    {
        if (curr_pos == -1)
            return CACHE_EMPTY;
        swap(0, curr_pos);
        curr_pos--;
        if (curr_pos >= 0)
            heapify_down(0);
        if (keep)
        {
            string filename = getFilename(cacheHeap[curr_pos + 1]->key);
            ofstream fout;
            fout.open(filename, ios::app);
            fout << cacheHeap[curr_pos + 1]->key << "\n";
            fout << cacheHeap[curr_pos + 1]->value << "\n";
            fout.close();
        }
        return DELETE_SUCCESS;
    }

    void insertAll(unordered_map<string, string> flush)
    {
        int to_empty = flush.size() - capacity + curr_pos + 1;
        for (int i = 0; i < to_empty; i++)
            delete_min(true);
        unordered_map<string, string>::iterator itr;
        for (itr = flush.begin(); itr != flush.end(); itr++)
            insert(itr->first, itr->second);
    }

    string getNodeByKey(string key)
    {
        string value;
        int i = exists(key);
        if (i == -1)
            return KEY_NOT_FOUND;
        else
        {
            cacheHeap[i]->frequency++;
            value = cacheHeap[i]->value;
            heapify_down(i);
            return value;
        }
    }

    string deleteNodeByKey(string key)
    {
        int i = exists(key);
        if (i == -1)
            return KEY_NOT_FOUND;
        else
        {
            cacheHeap[i]->frequency = 0;
            heapify_up(i);
            delete_min(false);
            string filename = getFilename(key);
            ofstream fout;
            fout.open(filename, ios::app);
            fout << key << "\n";
            fout << deleted << "\n";
            fout.close();
            return DELETE_SUCCESS;
        }
    }

    string getFilename(string key)
    {
        string filename = ".";
        int length = key.size();
        if (length == 1)
            return "_.kvm";
        filename += char(length - 1);
        filename += key;
        filename.pop_back();
        filename += ".kvm";
        return filename;
    }

    bool fileExists(string filename)
    {
        ifstream f(filename.c_str());
        return f.good();
    }

public:
    LFUCache()
    {
        curr_pos = -1;
        deleted = "";
        deleted += char(0);
    }

    void setCap(int capacity)
    {
        this->capacity = capacity;
        cacheHeap = (LFUNode **)malloc(sizeof(LFUNode *) * capacity);
        for (int i = 0; i < capacity; i++)
            cacheHeap[i] = new LFUNode(deleted, deleted);
    }

    string GET(string key, int *status)
    {
        //std::lock_guard<std::mutex> guard(mtx);
        string value = getNodeByKey(key);
        if (value.compare(KEY_NOT_FOUND) != 0)
        {
            *status = 200;
            return value;
        }
        string filename = getFilename(key);
        if (!fileExists(filename))
        {
            *status = 400;
            return KEY_NOT_FOUND;
        }
        string key1, val;
        ifstream fin;
        unordered_map<string, string> flush;
        fin.open(filename);
        do
        {
            getline(fin, key1);
            if (key1.size() == 0)
                break;
            getline(fin, val);
            if (val.compare(deleted) != 0)
                flush[key1] = val;
            else
                flush.erase(key1);
            if (fin.eof())
                break;
        } while (fin);
        fin.close();
        insertAll(flush);
        ofstream fout;
        fout.open(filename);
        fout.close();
        value = getNodeByKey(key);
        if (value.compare(KEY_NOT_FOUND) == 0)
            *status = 400;
        else
            *status = 200;
        return value;
    }

    void PUT(string key, string value)
    {
        //mtx.lock();
        insert(key, value);
        //mtx.unlock();
    }

    void DEL(string key, int *status)
    {
        int status1;
        string value = GET(key, &status1);
        if (status1 == 400)
        {
            *status = 400;
            return;
        }
        deleteNodeByKey(key);
    }

    void pushAll()
    {
        while (curr_pos >= 0)
            delete_min(true);
    }

    void reformat(string filename)
    {
        ifstream fin;
        fin.open(filename);
        unordered_map<string, string> flush;
        string key, value;
        do
        {
            getline(fin, key);
            if (key.size() == 0)
                break;
            getline(fin, value);
            if (value.compare(deleted) == 0)
                flush.erase(key);
            else
                flush[key] = value;
            if (fin.eof())
                break;
        } while (fin);
        fin.close();
        ofstream fout;
        fout.open(filename);
        unordered_map<string, string>::iterator itr;
        for (itr = flush.begin(); itr != flush.end(); itr++)
        {
            fout << itr->first << "\n";
            fout << itr->second << "\n";
        }
    }

    void traverse()
    {
        for (int i = 0; i <= curr_pos; i++)
            cout << cacheHeap[i]->key << endl;
        cout << endl;
    }

    int hash(string s)
    {
        return (((int)s.at(0)) << 8) + ((int)s.at(1));
    }
    string getKeyValuePairs(int newId, int id)
    {
        unordered_map<string, string> flush;
        string keyValPairs = "";
        DIR *dirFile = opendir(".");
        if (dirFile)
        {
            struct dirent *hFile;
            while ((hFile = readdir(dirFile)) != NULL)
            {
                string fName(hFile->d_name);
                string fileName(hFile->d_name);
                int n;
                if ((n = fileName.size()) < 8)
                    continue;
                if (fileName[n - 3] == 'k' && fileName[n - 2] == 'v' && fileName[n - 1] == 'm')
                {
                    fileName.erase(n - 4);
                    fileName = fileName.substr(2);
                    if (hash(fileName) <= newId || hash(fileName) > id)
                    {
                        ifstream fin;
                        fin.open(fName);
                        string _key, val;

                        do
                        {
                            getline(fin, _key);
                            if (_key.size() == 0)
                                break;
                            getline(fin, val);
                            if (val != deleted)
                                flush[_key] = val;
                            else
                                flush.erase(_key);

                            if (fin.eof())
                                break;
                        } while (fin);

                        fin.close();
                        const char *c = fName.c_str();
                        remove(c);
                    }
                }
            }
            closedir(dirFile);
        }

        vector<string> toBeDeleted;

        for (int i = 0; i <= curr_pos; i++)
        {
            if (hash(cacheHeap[i]->key) <= newId || hash(cacheHeap[i]->key) > id)
            {
                toBeDeleted.push_back(cacheHeap[i]->key);
                flush[cacheHeap[i]->key] = cacheHeap[i]->value;
            }
        }

        for (string key : toBeDeleted)
        {
            this->deleteNodeByKey(key);
        }

        unordered_map<string, string>::iterator itr;
        for (itr = flush.begin(); itr != flush.end(); itr++)
            keyValPairs += itr->first + ";";

        keyValPairs += ";";
        for (itr = flush.begin(); itr != flush.end(); itr++)
            keyValPairs += itr->second + ";";

        return keyValPairs;
    }
};
