#include <bits/stdc++.h>
#include <grpcpp/grpcpp.h>
#include "keyvaluestore.grpc.pb.h"

using namespace std;

using grpc::Server;
using grpc::ServerAsyncResponseWriter;
using grpc::ServerBuilder;
using grpc::ServerCompletionQueue;
using grpc::ServerContext;
using grpc::Status;
using keyvaluestore::KeyValueServices;
using keyvaluestore::Info;
using keyvaluestore::Null;

ServerBuilder builder;
KeyValueServices::AsyncService service;
std::unique_ptr<Server> server;

enum RequestType {
    GETADDRESS,
    ADDADDRESS
}

vector<string> servers;

class DNSData {
public:
    DNSData(KeyValueServices::AsyncService *service, ServerCompletionQueue *cq, RequestType reqType) : service(service), cq(cq), getAddressResponder(&context), status(CREATE), reqType(reqType) {
        Proceed();
    }

    void Proceed() {
        if (status == CREATE) {
            status = PROCESS;
            if(reqType==GETADDRESS)
                service->RequestGETADDRESS(&context, &null, &getAddressResponder, cq, cq, this);
            else
                service->RequestADDADDRESS(&context, &info, &addAddressResponder, cq, cq, this);
        }
        else if (status == PROCESS) {
            new DNSData(service, cq, reqType);
            if(reqType==GETADDRESS) {
                if(servers.size()==0)
                    info.set_address("null");
                else {
                    int x=rand()%servers.size();
                    info.set_address(servers.at(x));
                }
                getAddressResponder.Finish(info,Status::OK,this);
            }
            else {
                servers.push_back(info.address());
                null.set_nothing(1);
                addAddressResponder.Finish(null,Status::OK,this);
            }
            status = FINISH;
        }
        else {
            GPR_ASSERT(status == FINISH);
            delete this;
        }
        print_servers_list();
    }
    void print_servers_list() {
        for(int i=0;i<servers.size();i++)
            cout<<servers.at(i)<<endl;
    }

private:
    KeyValueServices::AsyncService *service;
    ServerCompletionQueue *cq;
    ServerContext context;
    Null null;
    Info info;
    ServerAsyncResponseWriter<Info> getAddressResponder;
    ServerAsyncResponseWriter<Null> addAddressResponder;
    enum CallStatus {
        CREATE,
        PROCESS,
        FINISH
    };
    CallStatus status;
    RequestType reqType;
};

int main(int argc,char **argv) {
    srand(time(0));
    string server_address("0.0.0.0:1234");
    builder.AddListeningPort(server_address, grpc::InsecureServerCredentials());
    builder.RegisterService(&service);
    unique_ptr<ServerCompletionQueue> comp_queue=builder.AddCompletionQueue();
    server = builder.BuildAndStart();
    new DNSData(&service,comp_queue.get());
    void *tag;
    bool ok;
    while(true) {
        GPR_ASSERT(comp_queue->Next(&tag,&ok));
        GPR_ASSERT(ok);
        static_cast<DNSData *>(tag)->Proceed();
    }
}