#include <bits/stdc++.h>
#include <pthread.h>
#include <fstream>
#include <grpcpp/grpcpp.h>
#include "keyvaluestore.grpc.pb.h"
#include "../Backend.h"
#define NEIGHBOURS "neighbours.txt"
#define FINGER_TABLE "fingertable.txt"
#define DNS_SERVER "0.0.0.0:1234"

using namespace std;

using grpc::Server;
using grpc::ServerAsyncResponseWriter;
using grpc::ServerBuilder;
using grpc::ServerCompletionQueue;
using grpc::ServerContext;
using grpc::Channel;
using grpc::ClientContext;
using grpc::Status;
using keyvaluestore::Key;
using keyvaluestore::KeyValue;
using keyvaluestore::KeyValueServices;
using keyvaluestore::ReqStatus;
using keyvaluestore::Value;
using keyvaluestore::Info;
using keyvaluestore::SuccessorInfo;
using keyvaluestore::KeyValues;
using keyvaluestore::Null;
using keyvaluestore::Id;
using keyvaluestore::Addresses;

pthread_mutex_t _masterLock;

enum RequestType {
    GET,
    PUT,
    DEL
};

enum ServerRequest {
    NEW,
    INFORMSUCCESSOR,
    INFORMPREDECESSOR,
    GETSUCCESSOR,
    GETPREDECESSOR,
    UPDATETABLE
};

map<string, string> params;
string config_filename = "../config";
string log_file = "../log";
ServerBuilder builder;
KeyValueServices::AsyncService service;
std::unique_ptr<Server> server;

pthread_t *workers;
int *worker_id;
pthread_cond_t startRpcs;
pthread_mutex_t myLock;

pthread_t dist_worker;
int dist_worker_id;
bool start;

memoryManagement *memManager;

void getConfig() {
    string line;
    ifstream config(config_filename);

    while (getline(config, line)) {
        char temp[line.length()];
        strcpy(temp, line.c_str());
        char *token1 = strtok(temp, "=");
        char *token2 = strtok(NULL, "-");
        params[token1] = token2;
    }
    config.close();
}

class ServerData {
public:
    ServerData(KeyValueServices::AsyncService *service, ServerCompletionQueue *cq, ServerRequest reqType) : service(service), cq(cq), newResponder(&context), informSuccessorResponder(&context),informPredecessorResponder(&context),getSuccessorResponder(&context),getPredecessorResponder(&context),updateTableResponder(&context), status(CREATE), reqType(reqType) {
        Proceed();
    }

    void Proceed() {
        if (status == CREATE) {
            status = PROCESS;
            if (reqType == NEW)
                service->RequestNEW(&context, &info, &newResponder, cq, cq, this);
            else if(reqType==INFORMSUCCESSOR)
                service->RequestINFORMSUCCESSOR(&context, &info, &informSuccessorResponder, cq, cq, this);
            else if(reqType==INFORMPREDECESSOR)
                service->RequestINFORMPREDECESSOR(&context,&info,&informPredecessorResponder,cq,cq,this);
            else if(reqType==GETSUCCESSOR)
                service->RequestGETSUCCESSOR(&context,&idvar1,&getSuccessorResponder,cq,cq,this);
            else if(reqType==GETPREDECESSOR)
                service->RequestGETPREDECESSOR(&context,&idvar1,&getPredecessorResponder,cq,cq,this);
            else
                service->RequestUPDATETABLE(&context,&addressarr,&updateTableResponder,cq,cq,this);
        }
        else if (status == PROCESS) {
            new ServerData(service, cq, reqType);
            if (reqType == NEW) {
                cout<<"New Server to join:"<<info.address()<<endl;
                //calculate id of node, return it's successor and predecessor
                string address=info.address();
                int id=stoi(address.substr(address.find(':')+1));
                int fingers[16];
                ifstream fin;
                cout<<"Getting my finger table"<<endl;
                fin.open(FINGER_TABLE);
                int nums=0;
                do {
                    string temp;
                    getline(fin,temp);
                    if(temp=="null"||temp.size()==0)
                        break;
                    fingers[nums++]=stoi(temp);
                }while(fin);
                fin.close();
                int node=-1;
                int next=-1;
                bool fl=false;
                int my_id=stoi(params.find("LISTENING_PORT")->second);
                if(nums>0&&fingers[nums-1]<id&&my_id>=id) {
                    node=fingers[nums-1];
                    next=my_id;
                }
                else if(nums>0&&my_id<id&&fingers[0]>=id) {
                    node=my_id;
                    next=fingers[0];
                }
                else {
                    for(int i=0;i<nums;i++) {
                        if(i>0&&fingers[i-1]<id&&fingers[i]>=id) {
                            node=fingers[i-1];
                            next=fingers[i];
                            break;
                        }
                        else if(i>0&&fingers[i]<fingers[i-1]) {
                            node=fingers[i-1];
                            next=fingers[i];
                            break;
                        }
                        else if(i==nums-1) {
                            fl=true;
                            node=fingers[i];
                            next=my_id;
                            break;
                        }
                    }
                }
                if(next!=-1) {
                    string target_address("0.0.0.0:"+to_string(next));
                    shared_ptr<Channel> channel=grpc::CreateChannel(target_address, grpc::InsecureChannelCredentials());
                    unique_ptr<KeyValueServices::Stub> stub;
                    stub=KeyValueServices::NewStub(channel);
                    ClientContext context;
                    Id x;
                    x.set_id(next);
                    Id y;
                    cout<<"asking the possible successor whether its predecessor is less than the new node id"<<endl;
                    int mypred,nextpred;
                    fin.open(NEIGHBOURS);
                    string temp;
                    getline(fin,temp);
                    getline(fin,temp);
                    fin.close();
                    mypred=stoi(temp.substr(temp.find(':')+1));
                    if(next!=my_id) {
                        stub->GETPREDECESSOR(&context,x,&y);
                        nextpred=y.id();
                    }
                    if(fl==false&&next!=my_id&&nextpred==node) {
                        cout<<"Yes it is. So we found the successor and the predecessor"<<endl;
                        cout<<"Successor: "<<x.id()<<endl;
                        cout<<"Predecessor: "<<nextpred<<endl;
                        successorInfo.set_succaddress("0.0.0.0:"+to_string(x.id()));
                        successorInfo.set_predaddress("0.0.0.0:"+to_string(nextpred));
                    }
                    else if(fl==false&&next==my_id&&mypred==node) {
                        cout<<"Yes it is. So we found the successor and the predecessor"<<endl;
                        cout<<"Successor: "<<x.id()<<endl;
                        cout<<"Predecessor: "<<mypred<<endl;
                        successorInfo.set_succaddress("0.0.0.0:"+to_string(x.id()));
                        successorInfo.set_predaddress("0.0.0.0:"+to_string(mypred));
                    }
                    else if(fl==false){
                        cout<<"No it is not. We will ask the possible predecessor to find the successor of new node"<<endl;
                        if(node==my_id) {
                            int mysucc;
                            fin.open(NEIGHBOURS);
                            string temp;
                            getline(fin,temp);
                            getline(fin,temp);
                            fin.close();
                            mysucc=stoi(temp.substr(temp.find(':')+1));
                            if(mysucc>=id) {
                                successorInfo.set_succaddress("0.0.0.0:"+to_string(mysucc));
                                successorInfo.set_predaddress("0.0.0.0:"+to_string(my_id));
                            }
                            else {
                                string tar_address("0.0.0.0:"+to_string(mysucc));
                                channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                stub=KeyValueServices::NewStub(channel);
                                ClientContext context1;
                                x.set_id(id);
                                stub->GETSUCCESSOR(&context1,x,&y);
                                cout<<"Yes. We got the successor"<<endl;
                                Id z;
                                string t_address("0.0.0.0:"+to_string(y.id()));
                                channel=grpc::CreateChannel(t_address, grpc::InsecureChannelCredentials());
                                stub=KeyValueServices::NewStub(channel);
                                ClientContext context2;
                                stub->GETPREDECESSOR(&context2,y,&z);
                                cout<<"Yes. We got the predecessor"<<endl;
                                cout<<"Successor: "<<y.id()<<endl;
                                cout<<"Predecessor: "<<z.id()<<endl;
                                successorInfo.set_succaddress("0.0.0.0:"+to_string(y.id()));
                                successorInfo.set_predaddress("0.0.0.0:"+to_string(z.id()));
                            }
                        }
                        else {
                            string tar_address("0.0.0.0:"+to_string(node));
                            channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                            stub=KeyValueServices::NewStub(channel);
                            ClientContext context1;
                            x.set_id(id);
                            stub->GETSUCCESSOR(&context1,x,&y);
                            cout<<"Yes. We got the successor"<<endl;
                            Id z;
                            string t_address("0.0.0.0:"+to_string(y.id()));
                            channel=grpc::CreateChannel(t_address, grpc::InsecureChannelCredentials());
                            stub=KeyValueServices::NewStub(channel);
                            ClientContext context2;
                            stub->GETPREDECESSOR(&context2,y,&z);
                            cout<<"Yes. We got the predecessor"<<endl;
                            cout<<"Successor: "<<y.id()<<endl;
                            cout<<"Predecessor: "<<z.id()<<endl;
                            successorInfo.set_succaddress("0.0.0.0:"+to_string(y.id()));
                            successorInfo.set_predaddress("0.0.0.0:"+to_string(z.id()));
                        }
                    }
                    else {
                        if(node>next) {
                            fin.open(NEIGHBOURS);
                            string xyz;
                            getline(fin,xyz);
                            getline(fin,xyz);
                            fin.close();
                            int xi=stoi(xyz.substr(xyz.find(':')+1));
                            if(xi==node) {
                                successorInfo.set_succaddress("0.0.0.0:"+to_string(next));
                                successorInfo.set_predaddress("0.0.0.0:"+to_string(node));
                            }
                            else {
                                string tar_address("0.0.0.0:"+to_string(node));
                                channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                stub=KeyValueServices::NewStub(channel);
                                ClientContext context1;
                                x.set_id(id);
                                stub->GETSUCCESSOR(&context1,x,&y);
                                cout<<"Yes. We got the successor"<<endl;
                                if(y.id()!=my_id) {
                                    Id z;
                                    string t_address("0.0.0.0:"+to_string(y.id()));
                                    channel=grpc::CreateChannel(t_address, grpc::InsecureChannelCredentials());
                                    stub=KeyValueServices::NewStub(channel);
                                    ClientContext context2;
                                    stub->GETPREDECESSOR(&context2,y,&z);
                                    cout<<"Yes. We got the predecessor"<<endl;
                                    cout<<"Successor: "<<y.id()<<endl;
                                    cout<<"Predecessor: "<<z.id()<<endl;
                                    successorInfo.set_succaddress("0.0.0.0:"+to_string(y.id()));
                                    successorInfo.set_predaddress("0.0.0.0:"+to_string(z.id()));
                                }
                                else {
                                    successorInfo.set_succaddress("0.0.0.0:"+to_string(next));
                                    successorInfo.set_predaddress("0.0.0.0:"+to_string(node));
                                }
                            }
                        }
                        else {
                            ifstream fin1;
                            fin1.open(NEIGHBOURS);
                            string t1,t2;
                            getline(fin1,t1);
                            getline(fin1,t2);
                            fin1.close();
                            int t1i=stoi(t1.substr(t1.find(':')+1));
                            if(t1==t2||t1i==node) {
                                successorInfo.set_succaddress("0.0.0.0:"+to_string(node));
                                successorInfo.set_predaddress("0.0.0.0:"+to_string(next));
                            }
                            else {
                                string tar_address("0.0.0.0:"+to_string(node));
                                channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                stub=KeyValueServices::NewStub(channel);
                                ClientContext context1;
                                x.set_id(id);
                                stub->GETSUCCESSOR(&context1,x,&y);
                                cout<<"Yes. We got the successor"<<endl;
                                if(y.id()!=my_id) {
                                    Id z;
                                    string t_address("0.0.0.0:"+to_string(y.id()));
                                    channel=grpc::CreateChannel(t_address, grpc::InsecureChannelCredentials());
                                    stub=KeyValueServices::NewStub(channel);
                                    ClientContext context2;
                                    stub->GETPREDECESSOR(&context2,y,&z);
                                    cout<<"Yes. We got the predecessor"<<endl;
                                    cout<<"Successor: "<<y.id()<<endl;
                                    cout<<"Predecessor: "<<z.id()<<endl;
                                    successorInfo.set_succaddress("0.0.0.0:"+to_string(y.id()));
                                    successorInfo.set_predaddress("0.0.0.0:"+to_string(z.id()));
                                }
                                else {
                                    successorInfo.set_succaddress("0.0.0.0:"+to_string(next));
                                    successorInfo.set_predaddress("0.0.0.0:"+to_string(node));
                                }
                            }
                        }
                    }
                }
                else {
                    cout<<"We got no node with id greater than new node"<<endl;
                    cout<<"Only one node present right now, that is me"<<endl;
                    successorInfo.set_succaddress("0.0.0.0:"+to_string(my_id));
                    successorInfo.set_predaddress("0.0.0.0:"+to_string(my_id));
                }
                cout<<"Sending the successor and predecessor back to the new server"<<endl;
                newResponder.Finish(successorInfo,Status::OK,this);
            }
            else if(reqType==INFORMSUCCESSOR){
                //return half of the keyvalue pairs to the requesting node
                string address=info.address();
                int id=stoi(address.substr(address.find(':')+1));
                string keyvalues=memManager->getKeyValuePairs(id,stoi(params["LISTENING_PORT"]));
                string keys=keyvalues.substr(0,keyvalues.find(";;")+1);
                string values=keyvalues.substr(keyvalues.find(";;")+2);
                cout<<"Okay, my new predecessor is: "<<info.address()<<endl;
                ifstream fin;
                fin.open(NEIGHBOURS);
                string successor,predecessor;
                getline(fin,successor);
                getline(fin,predecessor);
                fin.close();
                predecessor=info.address();
                ofstream fout;
                fout.open(NEIGHBOURS);
                fout<<successor<<endl;
                fout<<predecessor<<endl;
                fout.close();
                keyValues.set_keys(keys);
                keyValues.set_values(values);
                cout<<"Done making changes accordingly"<<endl;
                informSuccessorResponder.Finish(keyValues,Status::OK,this);
            }
            else if(reqType==GETSUCCESSOR) {
                cout<<"Some server asked me to find the successor of "<<idvar1.id()<<endl;
                int id=idvar1.id();
                int fingers[16];
                ifstream fin;
                cout<<"Getting the finger table"<<endl;
                fin.open(FINGER_TABLE);
                int nums=0;
                for(int i=0;i<16;i++) {
                    string temp;
                    getline(fin,temp);
                    if(temp=="null"||temp.size()==0)
                        break;
                    fingers[i]=stoi(temp);
                }
                fin.close();
                int node=-1;
                bool fl=false;
                int next=-1;
                int my_id=stoi(params.find("LISTENING_PORT")->second);
                if(nums>0&&fingers[nums-1]<id&&my_id>=id) {
                    node=fingers[nums-1];
                    next=my_id;
                }
                else if(nums>0&&my_id<id&&fingers[0]>=id) {
                    node=my_id;
                    next=fingers[0];
                }
                else {
                    for(int i=0;i<nums;i++) {
                        if(i>0&&fingers[i-1]<id&&fingers[i]>=id) {
                            node=fingers[i-1];
                            next=fingers[i];
                            break;
                        }
                        else if(i>0&&fingers[i]<fingers[i-1]&&fingers[i]>id) {
                            node=fingers[i-1];
                            next=fingers[i];
                            break;
                        }
                        else if(i==nums-1) {
                            fl=true;
                            node=fingers[i];
                            next=my_id;
                            break;
                        }
                    }
                }
                if(next!=-1) {
                    string target_address("0.0.0.0:"+to_string(next));
                    shared_ptr<Channel> channel=grpc::CreateChannel(target_address, grpc::InsecureChannelCredentials());
                    unique_ptr<KeyValueServices::Stub> stub;
                    stub=KeyValueServices::NewStub(channel);
                    ClientContext context;
                    Id x;
                    x.set_id(next);
                    Id y;
                    cout<<"asking the possible successor whether its predecessor is less than the new node id"<<endl;
                    int mypred,nextpred;
                    fin.open(NEIGHBOURS);
                    string temp;
                    getline(fin,temp);
                    getline(fin,temp);
                    fin.close();
                    mypred=stoi(temp.substr(temp.find(':')+1));
                    if(next!=my_id) {
                        stub->GETPREDECESSOR(&context,x,&y);
                        nextpred=y.id();
                    }
                    if(fl==false&&next!=my_id&&nextpred==node)
                        idvar2.set_id(x.id());
                    else if(fl==false&&next==my_id&&mypred==node)
                        idvar2.set_id(x.id());
                    else if(fl==false){
                        if(node==my_id) {
                            int mysucc;
                            fin.open(NEIGHBOURS);
                            string temp;
                            getline(fin,temp);
                            getline(fin,temp);
                            fin.close();
                            mysucc=stoi(temp.substr(temp.find(':')+1));
                            if(mysucc>=id)
                                idvar2.set_id(mysucc);
                            else {
                                string tar_address("0.0.0.0:"+to_string(mysucc));
                                channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                stub=KeyValueServices::NewStub(channel);
                                ClientContext context1;
                                x.set_id(id);
                                stub->GETSUCCESSOR(&context1,x,&y);
                                idvar2.set_id(y.id());
                            }
                        }
                        else {
                            string tar_address("0.0.0.0:"+to_string(node));
                            channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                            stub=KeyValueServices::NewStub(channel);
                            ClientContext context1;
                            x.set_id(id);
                            stub->GETSUCCESSOR(&context1,x,&y);
                            idvar2.set_id(y.id());
                        }
                    }
                    else {
                        if(node>next) {
                            fin.open(NEIGHBOURS);
                            string xyz;
                            getline(fin,xyz);
                            getline(fin,xyz);
                            fin.close();
                            int xi=stoi(xyz.substr(xyz.find(':')+1));;
                            if(xi==node) {
                                idvar2.set_id(next);
                            }
                            else {
                                string tar_address("0.0.0.0:"+to_string(node));
                                channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                stub=KeyValueServices::NewStub(channel);
                                ClientContext context1;
                                x.set_id(id);
                                stub->GETSUCCESSOR(&context1,x,&y);
                                cout<<"Yes. We got the successor"<<endl;
                                if(y.id()!=my_id) {
                                    idvar2.set_id(y.id());
                                }
                                else {
                                    idvar2.set_id(next);
                                }
                            }
                        }
                        else {
                            ifstream fin1;
                            fin1.open(NEIGHBOURS);
                            string t1,t2;
                            getline(fin1,t1);
                            getline(fin1,t2);
                            fin1.close();
                            int t1i=stoi(t1.substr(t1.find(':')+1));
                            if(t1==t2||t1i==node) {
                                cout<<"Here"<<endl;
                                idvar2.set_id(node);
                            }
                            else {
                                string tar_address("0.0.0.0:"+to_string(node));
                                channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                stub=KeyValueServices::NewStub(channel);
                                ClientContext context1;
                                x.set_id(id);
                                stub->GETSUCCESSOR(&context1,x,&y);
                                cout<<"Yes. We got the successor"<<endl;
                                if(y.id()!=my_id) {
                                    idvar2.set_id(y.id());
                                }
                                else {
                                    idvar2.set_id(next);
                                }
                            }
                        }
                    }
                }
                getSuccessorResponder.Finish(idvar2,Status::OK,this);
            }
            else if(reqType==GETPREDECESSOR) {
                cout<<"Someone asked me for my predecessor. Sending them"<<endl;
                ifstream fin;
                fin.open(NEIGHBOURS);
                string successor,predecessor;
                getline(fin,successor);
                getline(fin,predecessor);
                fin.close();
                idvar2.set_id(stoi(predecessor.substr(predecessor.find(':')+1)));
                cout<<"Sent my predecessor"<<endl;
                getPredecessorResponder.Finish(idvar2,Status::OK,this);
            }
            else if(reqType==INFORMPREDECESSOR) {
                cout<<"Okay, i got the information that my successor has changed"<<endl;
                cout<<"My new successor: "<<info.address()<<endl;
                ifstream fin;
                fin.open(NEIGHBOURS);
                string successor,predecessor;
                getline(fin,successor);
                getline(fin,predecessor);
                fin.close();
                successor=info.address();
                ofstream fout;
                fout.open(NEIGHBOURS);
                fout<<successor<<endl;
                fout<<predecessor<<endl;
                fout.close();
                null.set_nothing(0);
                cout<<"Okay, i made the necessary changes"<<endl;
                informPredecessorResponder.Finish(null,Status::OK,this);
            }
            else {
                string addresses=addressarr.addresses();
                int num=addressarr.servers();
                int ids[num];
                string addr[num];
                for(int i=0;i<num;i++) {
                    addr[i]=addresses.substr(0,addresses.find(';'));
                    ids[i]=stoi(addr[i].substr(addr[i].find(':')+1));
                    addresses=addresses.substr(addresses.find(';')+1);
                }
                ofstream fout;
                fout.open(FINGER_TABLE);
                int my_id=stoi(params.find("LISTENING_PORT")->second);
                int prev_entry=my_id;
                int i=0;
                int my_index=0;
                for(i=0;i<num;i++)
                    if(ids[i]==my_id) {
                        my_index=i;
                        break;
                    }
                int fingernodes[num-1];
                int count=0;
                for(i=my_index+1;i<num;i++)
                    fingernodes[count++]=ids[i];
                for(i=0;i<my_index;i++)
                    fingernodes[count++]=ids[i];
                int curr=0;
                for(i=0;i<16;i++) {
                    int next_entry=(my_id+(1<<i))%(1<<16);
                    if(curr!=count&&next_entry>ids[num-1]&&my_index!=0) {
                        fout<<ids[0]<<endl;
                        if(fingernodes[curr]!=ids[0]) {
                            for(int j=0;j<count;j++)
                                if(fingernodes[j]==ids[0])
                                    curr=j;
                        }
                    }
                    else {
                        while(curr<count&&next_entry>fingernodes[curr])
                            curr++;
                    }
                    if(curr<count&&fingernodes[curr]>=next_entry)
                        fout<<fingernodes[curr]<<endl;
                    if(curr==count)
                        fout<<"null"<<endl;
                }
                fout.close();
                Null n;
                n.set_nothing(0);
                updateTableResponder.Finish(n,Status::OK,this);
            }
            status = FINISH;
        }
        else {
            GPR_ASSERT(status == FINISH);
            delete this;
        }
    }

private:
    KeyValueServices::AsyncService *service;
    ServerCompletionQueue *cq;
    ServerContext context;
    Info info;
    SuccessorInfo successorInfo;
    Null null;
    KeyValues keyValues;
    Id idvar1;
    Id idvar2;
    Addresses addressarr;
    ServerAsyncResponseWriter<SuccessorInfo> newResponder;
    ServerAsyncResponseWriter<KeyValues> informSuccessorResponder;
    ServerAsyncResponseWriter<Null> informPredecessorResponder;
    ServerAsyncResponseWriter<Id> getSuccessorResponder;
    ServerAsyncResponseWriter<Id> getPredecessorResponder;
    ServerAsyncResponseWriter<Null> updateTableResponder;
    enum CallStatus {
        CREATE,
        PROCESS,
        FINISH
    };
    CallStatus status;
    ServerRequest reqType;
};

class CallData {
public:
    CallData(KeyValueServices::AsyncService *service, ServerCompletionQueue *cq, RequestType reqType) : service(service), cq(cq), getResponder(&context), putResponder(&context), delResponder(&context), status(CREATE), reqType(reqType) {
        Proceed();
    }

    void Proceed() {
        if (status == CREATE) {
            status = PROCESS;
            if (reqType == GET)
                service->RequestGET(&context, &key, &getResponder, cq, cq, this);
            else if (reqType == PUT)
                service->RequestPUT(&context, &keyvalue, &putResponder, cq, cq, this);
            else
                service->RequestDEL(&context, &key, &delResponder, cq, cq, this);
        } else if (status == PROCESS) {
            new CallData(service, cq, reqType);
            if (reqType == GET) {
                int succ;
                int key_id=hash(key.key());
                int my_id=stoi(params.find("LISTENING_PORT")->second);
                ifstream fin;
                fin.open(NEIGHBOURS);
                string pred;
                getline(fin,pred);
                getline(fin,pred);
                fin.close();
                int pred_id;
                if(pred=="-1")
                    pred_id=-1;
                else
                    pred_id=stoi(pred.substr(pred.find(':')+1));
                if(my_id<key_id&&!(pred_id<key_id&&pred_id>my_id)) {
                    //transfer request
                    int fingers[16];
                    ifstream fin;
                    cout<<"Getting my finger table"<<endl;
                    fin.open(FINGER_TABLE);
                    int nums=0;
                    do {
                        string temp;
                        getline(fin,temp);
                        if(temp=="null"||temp.size()==0)
                            break;
                        fingers[nums++]=stoi(temp);
                    }while(fin);
                    fin.close();
                    int node=-1;
                    bool fl=false;
                    int next=-1;
                    int my_id=stoi(params.find("LISTENING_PORT")->second);
                    if(nums>0&&fingers[nums-1]<key_id&&my_id>=key_id) {
                        node=fingers[nums-1];
                        next=my_id;
                    }
                    else if(nums>0&&my_id<key_id&&fingers[0]>=key_id) {
                        node=my_id;
                        next=fingers[0];
                    }
                    else {
                        for(int i=0;i<nums;i++) {
                            if(i>0&&fingers[i-1]<key_id&&fingers[i]>=key_id) {
                                node=fingers[i-1];
                                next=fingers[i];
                                break;
                            }
                            else if(i>0&&fingers[i]<fingers[i-1]&&fingers[i]>key_id) {
                                node=fingers[i-1];
                                next=fingers[i];
                                break;
                            }
                            else if(i==nums-1) {
                                fl=true;
                                node=fingers[i];
                                next=my_id;
                                break;
                            }
                        }
                    }
                    if(next!=-1) {
                        string target_address("0.0.0.0:"+to_string(next));
                        shared_ptr<Channel> channel=grpc::CreateChannel(target_address, grpc::InsecureChannelCredentials());
                        unique_ptr<KeyValueServices::Stub> stub;
                        stub=KeyValueServices::NewStub(channel);
                        ClientContext context;
                        Id x;
                        x.set_id(next);
                        Id y;
                        cout<<"asking the possible successor whether its predecessor is less than the new node id"<<endl;
                        int mypred,nextpred;
                        fin.open(NEIGHBOURS);
                        string temp;
                        getline(fin,temp);
                        getline(fin,temp);
                        fin.close();
                        mypred=stoi(temp.substr(temp.find(':')+1));
                        if(next!=my_id) {
                            stub->GETPREDECESSOR(&context,x,&y);
                            nextpred=y.id();
                        }
                        if(fl==false&&next!=my_id&&nextpred==node)
                            succ=x.id();
                        else if(fl==false&&next==my_id&&mypred==node)
                            succ=x.id();
                        else if(fl==false){
                            if(node==my_id) {
                                int mysucc;
                                fin.open(NEIGHBOURS);
                                string temp;
                                getline(fin,temp);
                                getline(fin,temp);
                                fin.close();
                                mysucc=stoi(temp.substr(temp.find(':')+1));
                                if(mysucc>=key_id)
                                    succ=mysucc;
                                else {
                                    string tar_address("0.0.0.0:"+to_string(mysucc));
                                    channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                    stub=KeyValueServices::NewStub(channel);
                                    ClientContext context1;
                                    x.set_id(key_id);
                                    stub->GETSUCCESSOR(&context1,x,&y);
                                    succ=y.id();
                                }
                            }
                            else {
                                string tar_address("0.0.0.0:"+to_string(node));
                                channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                stub=KeyValueServices::NewStub(channel);
                                ClientContext context1;
                                x.set_id(key_id);
                                stub->GETSUCCESSOR(&context1,x,&y);
                                succ=y.id();
                            }
                        }
                        else {
                            if(node>next) {
                                fin.open(NEIGHBOURS);
                                string xyz;
                                getline(fin,xyz);
                                getline(fin,xyz);
                                fin.close();
                                int xi=stoi(xyz.substr(xyz.find(':')+1));
                                if(xi==node) {
                                    succ=next;
                                }
                                else {
                                string tar_address("0.0.0.0:"+to_string(node));
                                    channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                    stub=KeyValueServices::NewStub(channel);
                                    ClientContext context1;
                                    x.set_id(key_id);
                                    stub->GETSUCCESSOR(&context1,x,&y);
                                    cout<<"Yes. We got the successor"<<endl;
                                    if(y.id()!=my_id) {
                                        succ=y.id();
                                    }
                                    else {
                                        succ=next;
                                    }
                                }
                            }
                            else {
                                ifstream fin1;
                                fin1.open(NEIGHBOURS);
                                string t1,t2;
                                getline(fin1,t1);
                                getline(fin1,t2);
                                fin1.close();
                                int t1i=stoi(t1.substr(t1.find(':')+1));
                                if(t1==t2||t1i==node) {
                                    succ=node;
                                }
                                else {
                                    string tar_address("0.0.0.0:"+to_string(node));
                                    channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                    stub=KeyValueServices::NewStub(channel);
                                    ClientContext context1;
                                    x.set_id(key_id);
                                    stub->GETSUCCESSOR(&context1,x,&y);
                                    cout<<"Yes. We got the successor"<<endl;
                                    if(y.id()!=my_id) {
                                        succ=y.id();
                                    }
                                    else {
                                        succ=next;
                                    }
                                }
                            }
                        }
                    }
                    string t_address("0.0.0.0:"+to_string(succ));
                    shared_ptr<Channel> channel=grpc::CreateChannel(t_address, grpc::InsecureChannelCredentials());
                    unique_ptr<KeyValueServices::Stub> stub=KeyValueServices::NewStub(channel);
                    ClientContext cont1;
                    stub->GET(&cont1,key,&value);
                }
                else if(my_id==key_id||(my_id<key_id&&pred_id<key_id&&pred_id>my_id)) {
                    cout << "SERVER SERVES A GET REQUEST WITH PARAMETER KEY : " << key.key();
                    int status = 200;
                    pthread_mutex_lock(&_masterLock);
                    string v = memManager->get(&status, key.key());
                    pthread_mutex_unlock(&_masterLock);

                    value.set_value(v);
                    if (status == 200)
                        value.set_status(200);
                    else {
                        value.set_status(400);
                        value.set_error(v);
                    }
                    cout << " RETURN VALUE : " << value.value() << endl;
                }
                else {
                    if(pred_id==-1||pred_id<key_id) {
                        cout << "SERVER SERVES A GET REQUEST WITH PARAMETER KEY : " << key.key();
                        int status = 200;
                        pthread_mutex_lock(&_masterLock);
                        string v = memManager->get(&status, key.key());
                        pthread_mutex_unlock(&_masterLock);

                        value.set_value(v);
                        if (status == 200)
                            value.set_status(200);
                        else {
                            value.set_status(400);
                            value.set_error(v);
                        }
                        cout << " RETURN VALUE : " << value.value() << endl;
                    }
                    else {
                        //transfer the request
                        int fingers[16];
                        ifstream fin;
                        cout<<"Getting my finger table"<<endl;
                        fin.open(FINGER_TABLE);
                        int nums=0;
                        do {
                            string temp;
                            getline(fin,temp);
                            if(temp=="null"||temp.size()==0)
                                break;
                            fingers[nums++]=stoi(temp);
                        }while(fin);
                        fin.close();
                        int node=-1;
                        bool fl=false;
                        int next=-1;
                        int my_id=stoi(params.find("LISTENING_PORT")->second);
                        if(nums>0&&fingers[nums-1]<key_id&&my_id>=key_id) {
                            node=fingers[nums-1];
                            next=my_id;
                        }
                        else if(nums>0&&my_id<key_id&&fingers[0]>=key_id) {
                            node=my_id;
                            next=fingers[0];
                        }
                        else {
                            for(int i=0;i<nums;i++) {
                                if(i>0&&fingers[i-1]<key_id&&fingers[i]>=key_id) {
                                    node=fingers[i-1];
                                    next=fingers[i];
                                    break;
                                }
                                else if(i>0&&fingers[i]<fingers[i-1]&&fingers[i]>key_id) {
                                    node=fingers[i-1];
                                    next=fingers[i];
                                    break;
                                }
                                else if(i==nums-1) {
                                    node=fingers[i];
                                    fl=true;
                                    next=my_id;
                                    break;
                                }
                            }
                        }
                        if(next!=-1) {
                            string target_address("0.0.0.0:"+to_string(next));
                            shared_ptr<Channel> channel=grpc::CreateChannel(target_address, grpc::InsecureChannelCredentials());
                            unique_ptr<KeyValueServices::Stub> stub;
                            stub=KeyValueServices::NewStub(channel);
                            ClientContext context;
                            Id x;
                            x.set_id(next);
                            Id y;
                            cout<<"asking the possible successor whether its predecessor is less than the new node id"<<endl;
                            int mypred,nextpred;
                            fin.open(NEIGHBOURS);
                            string temp;
                            getline(fin,temp);
                            getline(fin,temp);
                            fin.close();
                            mypred=stoi(temp.substr(temp.find(':')+1));
                            if(next!=my_id) {
                                stub->GETPREDECESSOR(&context,x,&y);
                                nextpred=y.id();
                            }
                            if(fl==false&&next!=my_id&&nextpred==node)
                                succ=x.id();
                            else if(fl==false&&next==my_id&&mypred==node)
                                succ=x.id();
                            else if(fl==false){
                                if(node==my_id) {
                                    int mysucc;
                                    fin.open(NEIGHBOURS);
                                    string temp;
                                    getline(fin,temp);
                                    getline(fin,temp);
                                    fin.close();
                                    mysucc=stoi(temp.substr(temp.find(':')+1));
                                    if(mysucc>=key_id)
                                        succ=mysucc;
                                    else {
                                        string tar_address("0.0.0.0:"+to_string(mysucc));
                                        channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                        stub=KeyValueServices::NewStub(channel);
                                        ClientContext context1;
                                        x.set_id(key_id);
                                        stub->GETSUCCESSOR(&context1,x,&y);
                                        succ=y.id();
                                    }
                                }
                                else {
                                    string tar_address("0.0.0.0:"+to_string(node));
                                    channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                    stub=KeyValueServices::NewStub(channel);
                                    ClientContext context1;
                                    x.set_id(key_id);
                                    stub->GETSUCCESSOR(&context1,x,&y);
                                    succ=y.id();
                                }
                            }
                            else {
                                if(node>next) {
                                    fin.open(NEIGHBOURS);
                                    string xyz;
                                    getline(fin,xyz);
                                    getline(fin,xyz);
                                    fin.close();
                                    int xi=stoi(xyz.substr(xyz.find(':')+1));
                                    if(xi==node) {
                                        succ=next;
                                    }
                                    else {
                                        string tar_address("0.0.0.0:"+to_string(node));
                                        channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                        stub=KeyValueServices::NewStub(channel);
                                        ClientContext context1;
                                        x.set_id(key_id);
                                        stub->GETSUCCESSOR(&context1,x,&y);
                                        cout<<"Yes. We got the successor"<<endl;
                                        if(y.id()!=my_id) {
                                            succ=y.id();
                                        }
                                        else {
                                            succ=next;
                                        }
                                    }
                                }
                                else {
                                    ifstream fin1;
                                    fin1.open(NEIGHBOURS);
                                    string t1,t2;
                                    getline(fin1,t1);
                                    getline(fin1,t2);
                                    fin1.close();
                                    int t1i=stoi(t1.substr(t1.find(':')+1));
                                    if(t1==t2||t1i==node) {
                                        succ=node;
                                    }
                                    else {
                                        string tar_address("0.0.0.0:"+to_string(node));
                                        channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                        stub=KeyValueServices::NewStub(channel);
                                        ClientContext context1;
                                        x.set_id(key_id);
                                        stub->GETSUCCESSOR(&context1,x,&y);
                                        cout<<"Yes. We got the successor"<<endl;
                                        if(y.id()!=my_id) {
                                            succ=y.id();
                                        }
                                        else {
                                            succ=next;
                                        }
                                    }
                                }
                            }
                        }
                        string t_address("0.0.0.0:"+to_string(succ));
                        shared_ptr<Channel> channel=grpc::CreateChannel(t_address, grpc::InsecureChannelCredentials());
                        unique_ptr<KeyValueServices::Stub> stub=KeyValueServices::NewStub(channel);
                        ClientContext cont1;
                        stub->GET(&cont1,key,&value);
                    }
                }
                getResponder.Finish(value, Status::OK, this);
            } else if (reqType == PUT) {
                int succ;
                int key_id=hash(keyvalue.key());
                int my_id=stoi(params.find("LISTENING_PORT")->second);
                ifstream fin;
                fin.open(NEIGHBOURS);
                string pred,scc;
                getline(fin,scc);
                getline(fin,pred);
                fin.close();
                int pred_id,succ_id;
                if(pred=="-1")
                    pred_id=-1;
                else
                    pred_id=stoi(pred.substr(pred.find(':')+1));
                if(scc=="-1")
                    succ_id=-1;
                else
                    succ_id=stoi(scc.substr(scc.find(':')+1));
                if(my_id<key_id&&!(pred_id<key_id&&pred_id>my_id)) {
                    //transfer request
                    int fingers[16];
                    ifstream fin;
                    cout<<"Getting my finger table"<<endl;
                    fin.open(FINGER_TABLE);
                    int nums=0;
                    do {
                        string temp;
                        getline(fin,temp);
                        if(temp=="null"||temp.size()==0)
                            break;
                        fingers[nums++]=stoi(temp);
                    }while(fin);
                    fin.close();
                    int node=-1;
                    bool fl=false;
                    int next=-1;
                    int my_id=stoi(params.find("LISTENING_PORT")->second);
                    if(nums>0&&fingers[nums-1]<key_id&&my_id>=key_id) {
                        node=fingers[nums-1];
                        next=my_id;
                    }
                    else if(nums>0&&my_id<key_id&&fingers[0]>=key_id) {
                        node=my_id;
                        next=fingers[0];
                    }
                    else {
                        for(int i=0;i<nums;i++) {
                            if(i>0&&fingers[i-1]<key_id&&fingers[i]>=key_id) {
                                node=fingers[i-1];
                                next=fingers[i];
                                break;
                            }
                            else if(i>0&&fingers[i]<fingers[i-1]&&fingers[i]>key_id) {
                                node=fingers[i-1];
                                next=fingers[i];
                                break;
                            }
                            else if(i==nums-1) {
                                node=fingers[i];
                                fl=true;
                                next=my_id;
                                break;
                            }
                        }
                    }
                    if(next!=-1) {
                        string target_address("0.0.0.0:"+to_string(next));
                        shared_ptr<Channel> channel=grpc::CreateChannel(target_address, grpc::InsecureChannelCredentials());
                        unique_ptr<KeyValueServices::Stub> stub;
                        stub=KeyValueServices::NewStub(channel);
                        ClientContext context;
                        Id x;
                        x.set_id(next);
                        Id y;
                        cout<<"asking the possible successor whether its predecessor is less than the new node id"<<endl;
                        int mypred,nextpred;
                        fin.open(NEIGHBOURS);
                        string temp;
                        getline(fin,temp);
                        getline(fin,temp);
                        fin.close();
                        mypred=stoi(temp.substr(temp.find(':')+1));
                        if(next!=my_id) {
                            stub->GETPREDECESSOR(&context,x,&y);
                            nextpred=y.id();
                        }
                        if(fl==false&&next!=my_id&&nextpred==node)
                            succ=x.id();
                        else if(fl==false&&next==my_id&&mypred==node)
                            succ=x.id();
                        else if(fl==false){
                            if(node==my_id) {
                                int mysucc;
                                fin.open(NEIGHBOURS);
                                string temp;
                                getline(fin,temp);
                                getline(fin,temp);
                                fin.close();
                                mysucc=stoi(temp.substr(temp.find(':')+1));
                                if(mysucc>=key_id)
                                    succ=mysucc;
                                else {
                                    string tar_address("0.0.0.0:"+to_string(mysucc));
                                    channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                    stub=KeyValueServices::NewStub(channel);
                                    ClientContext context1;
                                    x.set_id(key_id);
                                    stub->GETSUCCESSOR(&context1,x,&y);
                                    succ=y.id();
                                }
                            }
                            else {
                                string tar_address("0.0.0.0:"+to_string(node));
                                channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                stub=KeyValueServices::NewStub(channel);
                                ClientContext context1;
                                x.set_id(key_id);
                                stub->GETSUCCESSOR(&context1,x,&y);
                                succ=y.id();
                            }
                        }
                        else {
                            if(node>next) {
                                fin.open(NEIGHBOURS);
                                string xyz;
                                getline(fin,xyz);
                                getline(fin,xyz);
                                fin.close();
                                int xi=stoi(xyz.substr(xyz.find(':')+1));
                                if(xi==node) {
                                    succ=next;
                                }
                                else {
                                    string tar_address("0.0.0.0:"+to_string(node));
                                    channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                    stub=KeyValueServices::NewStub(channel);
                                    ClientContext context1;
                                    x.set_id(key_id);
                                    stub->GETSUCCESSOR(&context1,x,&y);
                                    cout<<"Yes. We got the successor"<<endl;
                                    if(y.id()!=my_id) {
                                        succ=y.id();
                                    }
                                    else {
                                        succ=next;
                                    }
                                }
                            }
                            else {
                                ifstream fin1;
                                fin1.open(NEIGHBOURS);
                                string t1,t2;
                                getline(fin1,t1);
                                getline(fin1,t2);
                                fin1.close();
                                int t1i=stoi(t1.substr(t1.find(':')+1));
                                if(t1==t2||t1i==node) {
                                    succ=node;
                                }
                                else {
                                    string tar_address("0.0.0.0:"+to_string(node));
                                    channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                    stub=KeyValueServices::NewStub(channel);
                                    ClientContext context1;
                                    x.set_id(key_id);
                                    stub->GETSUCCESSOR(&context1,x,&y);
                                    cout<<"Yes. We got the successor"<<endl;
                                    if(y.id()!=my_id) {
                                        succ=y.id();
                                    }
                                    else {
                                        succ=next;
                                    }
                                }
                            }
                        }
                    }
                    string t_address("0.0.0.0:"+to_string(succ));
                    shared_ptr<Channel> channel=grpc::CreateChannel(t_address, grpc::InsecureChannelCredentials());
                    unique_ptr<KeyValueServices::Stub> stub=KeyValueServices::NewStub(channel);
                    ClientContext cont1;
                    stub->PUT(&cont1,keyvalue,&stat);
                }
                else if(my_id==key_id||(my_id<key_id&&pred_id<key_id&&pred_id>my_id)) {
                    cout << "SERVER SERVES A PUT REQUEST WITH PARAMETER KEY : " << keyvalue.key() << " & VALUE : " << keyvalue.value() << endl;


                    pthread_mutex_lock(&_masterLock);
                    memManager->put(keyvalue.key(), keyvalue.value());
                    pthread_mutex_unlock(&_masterLock);

                    stat.set_status(200);
                }
                else {
                    if(pred_id==-1||(pred_id<key_id&&my_id>=key_id)||(pred_id>my_id&&my_id>=key_id)) {
                        cout << "SERVER SERVES A PUT REQUEST WITH PARAMETER KEY : " << keyvalue.key() << " & VALUE : " << keyvalue.value() << endl;


                        pthread_mutex_lock(&_masterLock);
                        memManager->put(keyvalue.key(), keyvalue.value());
                        pthread_mutex_unlock(&_masterLock);

                        stat.set_status(200);
                    }
                    else {
                        //transfer the request
                        int fingers[16];
                        ifstream fin;
                        cout<<"Getting my finger table"<<endl;
                        fin.open(FINGER_TABLE);
                        int nums=0;
                        do {
                            string temp;
                            getline(fin,temp);
                            if(temp=="null"||temp.size()==0)
                                break;
                            fingers[nums++]=stoi(temp);
                        }while(fin);
                        fin.close();
                        int node=-1;
                        bool fl=false;
                        int next=-1;
                        int my_id=stoi(params.find("LISTENING_PORT")->second);
                        if(nums>0&&fingers[nums-1]<key_id&&my_id>=key_id) {
                            node=fingers[nums-1];
                            next=my_id;
                        }
                        else if(nums>0&&my_id<key_id&&fingers[0]>=key_id) {
                            node=my_id;
                            next=fingers[0];
                        }
                        else {
                            for(int i=0;i<nums;i++) {
                                if(i>0&&fingers[i-1]<key_id&&fingers[i]>=key_id) {
                                    node=fingers[i-1];
                                    next=fingers[i];
                                    break;
                                }
                                else if(i>0&&fingers[i]<fingers[i-1]&&fingers[i]>key_id) {
                                    node=fingers[i-1];
                                    next=fingers[i];
                                    break;
                                }
                                else if(i==nums-1) {
                                    node=fingers[i];
                                    fl=true;
                                    next=my_id;
                                    break;
                                }
                            }
                        }
                        if(next!=-1) {
                            string target_address("0.0.0.0:"+to_string(next));
                            shared_ptr<Channel> channel=grpc::CreateChannel(target_address, grpc::InsecureChannelCredentials());
                            unique_ptr<KeyValueServices::Stub> stub;
                            stub=KeyValueServices::NewStub(channel);
                            ClientContext context;
                            Id x;
                            x.set_id(next);
                            Id y;
                            cout<<"asking the possible successor whether its predecessor is less than the new node id"<<endl;
                            int mypred,nextpred;
                            fin.open(NEIGHBOURS);
                            string temp;
                            getline(fin,temp);
                            getline(fin,temp);
                            fin.close();
                            mypred=stoi(temp.substr(temp.find(':')+1));
                            if(next!=my_id) {
                                stub->GETPREDECESSOR(&context,x,&y);
                                nextpred=y.id();
                            }
                            if(fl==false&&next!=my_id&&nextpred==node)
                                succ=x.id();
                            else if(fl==false&&next==my_id&&mypred==node)
                                succ=x.id();
                            else if(fl==false){
                                if(node==my_id) {
                                    int mysucc;
                                    fin.open(NEIGHBOURS);
                                    string temp;
                                    getline(fin,temp);
                                    getline(fin,temp);
                                    fin.close();
                                    mysucc=stoi(temp.substr(temp.find(':')+1));
                                    if(mysucc>=key_id)
                                        succ=mysucc;
                                    else {
                                        string tar_address("0.0.0.0:"+to_string(mysucc));
                                        channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                        stub=KeyValueServices::NewStub(channel);
                                        ClientContext context1;
                                        x.set_id(key_id);
                                        stub->GETSUCCESSOR(&context1,x,&y);
                                        succ=y.id();
                                    }
                                }
                                else {
                                    string tar_address("0.0.0.0:"+to_string(node));
                                    channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                    stub=KeyValueServices::NewStub(channel);
                                    ClientContext context1;
                                    x.set_id(key_id);
                                    stub->GETSUCCESSOR(&context1,x,&y);
                                    succ=y.id();
                                }
                            }
                            else {
                                if(node>next) {
                                    fin.open(NEIGHBOURS);
                                    string xyz;
                                    getline(fin,xyz);
                                    getline(fin,xyz);
                                    fin.close();
                                    int xi=stoi(xyz.substr(xyz.find(':')+1));
                                    if(xi==node) {
                                        succ=next;
                                    }
                                    else {
                                        string tar_address("0.0.0.0:"+to_string(node));
                                        channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                        stub=KeyValueServices::NewStub(channel);
                                        ClientContext context1;
                                        x.set_id(key_id);
                                        stub->GETSUCCESSOR(&context1,x,&y);
                                        cout<<"Yes. We got the successor"<<endl;
                                        if(y.id()!=my_id) {
                                            succ=y.id();
                                        }
                                        else {
                                            succ=next;
                                        }
                                    }
                                }
                                else {
                                    ifstream fin1;
                                    fin1.open(NEIGHBOURS);
                                    string t1,t2;
                                    getline(fin1,t1);
                                    getline(fin1,t2);
                                    fin1.close();
                                    int t1i=stoi(t1.substr(t1.find(':')+1));
                                    if(t1==t2||t1i==node) {
                                        succ=node;
                                    }
                                    else {
                                        string tar_address("0.0.0.0:"+to_string(node));
                                        channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                        stub=KeyValueServices::NewStub(channel);
                                        ClientContext context1;
                                        x.set_id(key_id);
                                        stub->GETSUCCESSOR(&context1,x,&y);
                                        cout<<"Yes. We got the successor"<<endl;
                                        if(y.id()!=my_id) {
                                            succ=y.id();
                                        }
                                        else {
                                            succ=next;
                                        }
                                    }
                                }
                            }
                        }
                        string t_address("0.0.0.0:"+to_string(succ));
                        shared_ptr<Channel> channel=grpc::CreateChannel(t_address, grpc::InsecureChannelCredentials());
                        unique_ptr<KeyValueServices::Stub> stub=KeyValueServices::NewStub(channel);
                        ClientContext cont1;
                        stub->PUT(&cont1,keyvalue,&stat);
                    }
                }
                putResponder.Finish(stat, Status::OK, this);
            } else {
                int succ;
                int key_id=hash(key.key());
                int my_id=stoi(params.find("LISTENING_PORT")->second);
                ifstream fin;
                fin.open(NEIGHBOURS);
                string pred;
                getline(fin,pred);
                getline(fin,pred);
                fin.close();
                int pred_id;
                if(pred=="-1")
                    pred_id=-1;
                else
                    pred_id=stoi(pred.substr(pred.find(':')+1));
                if(my_id<key_id&&!(pred_id<key_id&&pred_id>my_id)) {
                    //transfer request
                    int fingers[16];
                    ifstream fin;
                    cout<<"Getting my finger table"<<endl;
                    fin.open(FINGER_TABLE);
                    int nums=0;
                    do {
                        string temp;
                        getline(fin,temp);
                        if(temp=="null"||temp.size()==0)
                            break;
                        fingers[nums++]=stoi(temp);
                    }while(fin);
                    fin.close();
                    int node=-1;
                    bool fl=false;
                    int next=-1;
                    int my_id=stoi(params.find("LISTENING_PORT")->second);
                    if(nums>0&&fingers[nums-1]<key_id&&my_id>=key_id) {
                        node=fingers[nums-1];
                        next=my_id;
                    }
                    else if(nums>0&&my_id<key_id&&fingers[0]>=key_id) {
                        node=my_id;
                        next=fingers[0];
                    }
                    else {
                        for(int i=0;i<nums;i++) {
                            if(i>0&&fingers[i-1]<key_id&&fingers[i]>=key_id) {
                                node=fingers[i-1];
                                next=fingers[i];
                                break;
                            }
                            else if(i>0&&fingers[i]<fingers[i-1]&&fingers[i]>key_id) {
                                node=fingers[i-1];
                                next=fingers[i];
                                break;
                            }
                            else if(i==nums-1) {
                                node=fingers[i];
                                fl=true;
                                next=my_id;
                                break;
                            }
                        }
                    }
                    if(next!=-1) {
                        string target_address("0.0.0.0:"+to_string(next));
                        shared_ptr<Channel> channel=grpc::CreateChannel(target_address, grpc::InsecureChannelCredentials());
                        unique_ptr<KeyValueServices::Stub> stub;
                        stub=KeyValueServices::NewStub(channel);
                        ClientContext context;
                        Id x;
                        x.set_id(next);
                        Id y;
                        cout<<"asking the possible successor whether its predecessor is less than the new node id"<<endl;
                        int mypred,nextpred;
                        fin.open(NEIGHBOURS);
                        string temp;
                        getline(fin,temp);
                        getline(fin,temp);
                        fin.close();
                        mypred=stoi(temp.substr(temp.find(':')+1));
                        if(next!=my_id) {
                            stub->GETPREDECESSOR(&context,x,&y);
                            nextpred=y.id();
                        }
                        if(fl==false&&next!=my_id&&nextpred==node)
                            succ=x.id();
                        else if(fl==false&&next==my_id&&mypred==node)
                            succ=x.id();
                        else if(fl==false){
                            if(node==my_id) {
                                int mysucc;
                                fin.open(NEIGHBOURS);
                                string temp;
                                getline(fin,temp);
                                getline(fin,temp);
                                fin.close();
                                mysucc=stoi(temp.substr(temp.find(':')+1));
                                if(mysucc>=key_id)
                                    succ=mysucc;
                                else {
                                    string tar_address("0.0.0.0:"+to_string(mysucc));
                                    channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                    stub=KeyValueServices::NewStub(channel);
                                    ClientContext context1;
                                    x.set_id(key_id);
                                    stub->GETSUCCESSOR(&context1,x,&y);
                                    succ=y.id();
                                }
                            }
                            else {
                                string tar_address("0.0.0.0:"+to_string(node));
                                channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                stub=KeyValueServices::NewStub(channel);
                                ClientContext context1;
                                x.set_id(key_id);
                                stub->GETSUCCESSOR(&context1,x,&y);
                                succ=y.id();
                            }
                        }
                        else {
                            if(node>next) {
                                fin.open(NEIGHBOURS);
                                string xyz;
                                getline(fin,xyz);
                                getline(fin,xyz);
                                fin.close();
                                int xi=stoi(xyz.substr(xyz.find(':')+1));
                                if(xi==node) {
                                    succ=next;
                                }
                                else {
                                    string tar_address("0.0.0.0:"+to_string(node));
                                    channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                    stub=KeyValueServices::NewStub(channel);
                                    ClientContext context1;
                                    x.set_id(key_id);
                                    stub->GETSUCCESSOR(&context1,x,&y);
                                    cout<<"Yes. We got the successor"<<endl;
                                    if(y.id()!=my_id) {
                                        succ=y.id();
                                    }
                                    else {
                                        succ=next;
                                    }
                                }
                            }
                            else {
                                ifstream fin1;
                                fin1.open(NEIGHBOURS);
                                string t1,t2;
                                getline(fin1,t1);
                                getline(fin1,t2);
                                fin1.close();
                                int t1i=stoi(t1.substr(t1.find(':')+1));
                                if(t1==t2||t1i==node) {
                                    succ=node;
                                }
                                else {
                                    string tar_address("0.0.0.0:"+to_string(node));
                                    channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                    stub=KeyValueServices::NewStub(channel);
                                    ClientContext context1;
                                    x.set_id(key_id);
                                    stub->GETSUCCESSOR(&context1,x,&y);
                                    cout<<"Yes. We got the successor"<<endl;
                                    if(y.id()!=my_id) {
                                        succ=y.id();
                                    }
                                    else {
                                        succ=next;
                                    }
                                }
                            }
                        }
                    }
                    string t_address("0.0.0.0:"+to_string(succ));
                    shared_ptr<Channel> channel=grpc::CreateChannel(t_address, grpc::InsecureChannelCredentials());
                    unique_ptr<KeyValueServices::Stub> stub=KeyValueServices::NewStub(channel);
                    ClientContext cont1;
                    stub->DEL(&cont1,key,&stat);
                }
                else if(my_id==key_id||(my_id<key_id&&pred_id<key_id&&pred_id>my_id)) {
                    cout << "SERVER SERVES A DEL REQUEST WITH PARAMETER KEY : " << key.key() << endl;
                    int status = 200;

                    pthread_mutex_lock(&_masterLock);
                    memManager->del(&status, key.key());
                    pthread_mutex_unlock(&_masterLock);

                    if (status == 200)
                        stat.set_status(200);
                    else {
                        //as this server does not have the keyvalue pair, send request to next server using CHORD
                        stat.set_status(400);
                        stat.set_error("KEY NOT EXIST");
                    }
                }
                else {
                    if(pred_id==-1||pred_id<key_id) {
                        cout << "SERVER SERVES A DEL REQUEST WITH PARAMETER KEY : " << key.key() << endl;
                        int status = 200;

                        pthread_mutex_lock(&_masterLock);
                        memManager->del(&status, key.key());
                        pthread_mutex_unlock(&_masterLock);

                        if (status == 200)
                            stat.set_status(200);
                        else {
                            //as this server does not have the keyvalue pair, send request to next server using CHORD
                            stat.set_status(400);
                            stat.set_error("KEY NOT EXIST");
                        }
                    }
                    else {
                        int fingers[16];
                        ifstream fin;
                        cout<<"Getting my finger table"<<endl;
                        fin.open(FINGER_TABLE);
                        int nums=0;
                        do {
                            string temp;
                            getline(fin,temp);
                            if(temp=="null"||temp.size()==0)
                                break;
                            fingers[nums++]=stoi(temp);
                        }while(fin);
                        fin.close();
                        int node=-1;
                        bool fl=false;
                        int next=-1;
                        int my_id=stoi(params.find("LISTENING_PORT")->second);
                        if(nums>0&&fingers[nums-1]<key_id&&my_id>=key_id) {
                            node=fingers[nums-1];
                            next=my_id;
                        }
                        else if(nums>0&&my_id<key_id&&fingers[0]>=key_id) {
                            node=my_id;
                            next=fingers[0];
                        }
                        else {
                            for(int i=0;i<nums;i++) {
                                if(i>0&&fingers[i-1]<key_id&&fingers[i]>=key_id) {
                                    node=fingers[i-1];
                                    next=fingers[i];
                                    break;
                                }
                                else if(i>0&&fingers[i]<fingers[i-1]&&fingers[i]>key_id) {
                                    node=fingers[i-1];
                                    next=fingers[i];
                                    break;
                                }
                                else if(i==nums-1) {
                                    node=fingers[i];
                                    fl=true;
                                    next=my_id;
                                    break;
                                }
                            }
                        }
                        if(next!=-1) {
                            string target_address("0.0.0.0:"+to_string(next));
                            shared_ptr<Channel> channel=grpc::CreateChannel(target_address, grpc::InsecureChannelCredentials());
                            unique_ptr<KeyValueServices::Stub> stub;
                            stub=KeyValueServices::NewStub(channel);
                            ClientContext context;
                            Id x;
                            x.set_id(next);
                            Id y;
                            cout<<"asking the possible successor whether its predecessor is less than the new node id"<<endl;
                            int mypred,nextpred;
                            fin.open(NEIGHBOURS);
                            string temp;
                            getline(fin,temp);
                            getline(fin,temp);
                            fin.close();
                            mypred=stoi(temp.substr(temp.find(':')+1));
                            if(next!=my_id) {
                                stub->GETPREDECESSOR(&context,x,&y);
                                nextpred=y.id();
                            }
                            if(fl==false&&next!=my_id&&nextpred==node)
                                succ=x.id();
                            else if(fl==false&&next==my_id&&mypred==node)
                                succ=x.id();
                            else if(fl==false){
                                if(node==my_id) {
                                    int mysucc;
                                    fin.open(NEIGHBOURS);
                                    string temp;
                                    getline(fin,temp);
                                    getline(fin,temp);
                                    fin.close();
                                    mysucc=stoi(temp.substr(temp.find(':')+1));
                                    if(mysucc>=key_id)
                                        succ=mysucc;
                                    else {
                                        string tar_address("0.0.0.0:"+to_string(mysucc));
                                        channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                        stub=KeyValueServices::NewStub(channel);
                                        ClientContext context1;
                                        x.set_id(key_id);
                                        stub->GETSUCCESSOR(&context1,x,&y);
                                        succ=y.id();
                                    }
                                }
                                else {
                                    string tar_address("0.0.0.0:"+to_string(node));
                                    channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                    stub=KeyValueServices::NewStub(channel);
                                    ClientContext context1;
                                    x.set_id(key_id);
                                    stub->GETSUCCESSOR(&context1,x,&y);
                                    succ=y.id();
                                }
                            }
                            else {
                                if(node>next) {
                                    fin.open(NEIGHBOURS);
                                    string xyz;
                                    getline(fin,xyz);
                                    getline(fin,xyz);
                                    fin.close();
                                    int xi=stoi(xyz.substr(xyz.find(':')+1));
                                    if(xi==node) {
                                        succ=next;
                                    }
                                    else {
                                        string tar_address("0.0.0.0:"+to_string(node));
                                        channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                        stub=KeyValueServices::NewStub(channel);
                                        ClientContext context1;
                                        x.set_id(key_id);
                                        stub->GETSUCCESSOR(&context1,x,&y);
                                        cout<<"Yes. We got the successor"<<endl;
                                        if(y.id()!=my_id) {
                                            succ=y.id();
                                        }
                                        else {
                                            succ=next;
                                        }
                                    }
                                }
                                else {
                                    ifstream fin1;
                                    fin1.open(NEIGHBOURS);
                                    string t1,t2;
                                    getline(fin1,t1);
                                    getline(fin1,t2);
                                    fin1.close();
                                    int t1i=stoi(t1.substr(t1.find(':')+1));
                                    if(t1==t2||t1i==node) {
                                        succ=node;
                                    }
                                    else {
                                        string tar_address("0.0.0.0:"+to_string(node));
                                        channel=grpc::CreateChannel(tar_address, grpc::InsecureChannelCredentials());
                                        stub=KeyValueServices::NewStub(channel);
                                        ClientContext context1;
                                        x.set_id(key_id);
                                        stub->GETSUCCESSOR(&context1,x,&y);
                                        cout<<"Yes. We got the successor"<<endl;
                                        if(y.id()!=my_id) {
                                            succ=y.id();
                                        }
                                        else {
                                            succ=next;
                                        }
                                    }
                                }
                            }
                        }
                        string t_address("0.0.0.0:"+to_string(succ));
                        shared_ptr<Channel> channel=grpc::CreateChannel(t_address, grpc::InsecureChannelCredentials());
                        unique_ptr<KeyValueServices::Stub> stub=KeyValueServices::NewStub(channel);
                        ClientContext cont1;
                        stub->DEL(&cont1,key,&stat);
                    }
                }
                delResponder.Finish(stat, Status::OK, this);
            }
            /* --------------------------------CONTENT OF CACHE ONLY KEY-------------------------------- */
            memManager->traverse();
            status = FINISH;
        } else {
            GPR_ASSERT(status == FINISH);
            delete this;
        }
    }
    int hash(string s) {
        return (((int)s.at(0))<<8)+((int)s.at(1));
    }

private:
    KeyValueServices::AsyncService *service;
    ServerCompletionQueue *cq;
    ServerContext context;
    Key key;
    Value value;
    KeyValue keyvalue;
    ReqStatus stat;
    ServerAsyncResponseWriter<Value> getResponder;
    ServerAsyncResponseWriter<ReqStatus> putResponder;
    ServerAsyncResponseWriter<ReqStatus> delResponder;
    enum CallStatus {
        CREATE,
        PROCESS,
        FINISH
    };
    CallStatus status;
    RequestType reqType;
};

void setupServer(string server_address) {
    builder.AddListeningPort(server_address, grpc::InsecureServerCredentials());
    builder.RegisterService(&service);
}

void *handleServerRequests(void *thread_id) {
    unique_ptr<ServerCompletionQueue> comp_queue=builder.AddCompletionQueue();
    pthread_mutex_lock(&myLock);
    while(!start)
        pthread_cond_wait(&startRpcs,&myLock);
    pthread_mutex_unlock(&myLock);
    new ServerData(&service,comp_queue.get(),NEW);
    new ServerData(&service,comp_queue.get(),INFORMSUCCESSOR);
    new ServerData(&service,comp_queue.get(),INFORMPREDECESSOR);
    new ServerData(&service,comp_queue.get(),GETSUCCESSOR);
    new ServerData(&service,comp_queue.get(),GETPREDECESSOR);
    new ServerData(&service,comp_queue.get(),UPDATETABLE);
    void *tag;
    bool ok;
    while(true) {
        GPR_ASSERT(comp_queue->Next(&tag,&ok));
        GPR_ASSERT(ok);
        static_cast<ServerData *>(tag)->Proceed();
    }
    return 0;
}

void *handleRpcs(void *thread_id) {
    unique_ptr<ServerCompletionQueue> comp_queue = builder.AddCompletionQueue();
    pthread_mutex_lock(&myLock);
    while (!start)
        pthread_cond_wait(&startRpcs, &myLock);
    pthread_mutex_unlock(&myLock);
    new CallData(&service, comp_queue.get(), GET);
    new CallData(&service, comp_queue.get(), PUT);
    new CallData(&service, comp_queue.get(), DEL);
    void *tag;
    bool ok;
    while (true) {
        GPR_ASSERT(comp_queue->Next(&tag, &ok));
        GPR_ASSERT(ok);
        // cout << "Thread id:\t" << (*(int *)thread_id) << "\n";
        static_cast<CallData *>(tag)->Proceed();
    }
    return 0;
}

void assignThreads(int num_threads) {
    dist_worker_id=-1;
    pthread_create(&dist_worker,NULL,handleServerRequests,(void *)&dist_worker_id);
    workers = (pthread_t *)malloc(sizeof(pthread_t) * num_threads);
    worker_id = (int *)malloc(sizeof(int) * num_threads);
    for (int i = 0; i < num_threads; i++) {
        worker_id[i] = i;
        pthread_create(&workers[i], NULL, handleRpcs, (void *)&worker_id[i]);
    }
}

void signalHandler(int signum) {
    memManager->pushAll();
    cout << "SERVER SHUTDOWN" << endl;
    server->Shutdown();
    exit(0);
}

void updateAllFingerTables() {
    string target_address(DNS_SERVER);
    shared_ptr<Channel> channel=grpc::CreateChannel(target_address, grpc::InsecureChannelCredentials());
    unique_ptr<KeyValueServices::Stub> stub;
    stub=KeyValueServices::NewStub(channel);
    Null null1;
    null1.set_nothing(0);
    Null null2;
    ClientContext context;
    Addresses addr;
    stub->GETSERVERS(&context,null1,&addr);
    string addresses=addr.addresses();
    int num=addr.servers();
    string ad[num];
    int ids[num];
    for(int i=0;i<num;i++) {
        ad[i]=addresses.substr(0,addresses.find(';'));
        ids[i]=stoi(ad[i].substr(ad[i].find(':')+1));
        addresses=addresses.substr(addresses.find(';')+1);
    }
    ofstream fout;
    fout.open(FINGER_TABLE);
    int my_id=stoi(params.find("LISTENING_PORT")->second);
    int prev_entry=my_id;
    int i=0;
    int my_index=0;
    for(i=0;i<num;i++)
        if(ids[i]==my_id) {
            my_index=i;
            break;
        }
    int fingernodes[num-1];
    int count=0;
    for(i=my_index+1;i<num;i++)
        fingernodes[count++]=ids[i];
    for(i=0;i<my_index;i++)
        fingernodes[count++]=ids[i];
    int curr=0;
    for(i=0;i<16;i++) {
        int next_entry=(my_id+(1<<i))%(1<<16);
        if(curr!=count&&next_entry>ids[num-1]&&my_index!=0) {
            fout<<ids[0]<<endl;
            if(fingernodes[curr]!=ids[0]) {
                for(int j=0;j<count;j++)
                    if(fingernodes[j]==ids[0])
                        curr=j;
            }
        }
        else {
            while(curr<count&&next_entry>fingernodes[curr])
                curr++;
        }
        if(curr<count&&fingernodes[curr]>next_entry)
            fout<<fingernodes[curr]<<endl;
        if(curr==count)
            fout<<"null"<<endl;
    }
    fout.close();
    ClientContext context2;
    stub->UPDATEFINGERTABLES(&context2,null1,&null2);
}

void register_server_DNS(string my_address) {
    cout<<"Registering to DNS"<<endl;
    string target_address(DNS_SERVER);
    shared_ptr<Channel> channel=grpc::CreateChannel(target_address, grpc::InsecureChannelCredentials());
    unique_ptr<KeyValueServices::Stub> stub;
    stub=KeyValueServices::NewStub(channel);
    Null null;
    null.set_nothing(0);
    Info info;
    ClientContext context;
    Status status=stub->GETADDRESS(&context,null,&info);
    cout<<"Address received:"<<info.address()<<endl;
    string old_server;
    if(status.ok()) {
        old_server=info.address();
        info.set_address(my_address);
        ClientContext new_context;
        cout<<"Adding address to DNS"<<endl;
        stub->ADDADDRESS(&new_context,info,&null);
        cout<<"Address added to DNS"<<endl;
        ofstream fout;
        cout<<"Generating initial finger table"<<endl;
        fout.open(FINGER_TABLE);
        for(int i=0;i<16;i++)
            fout<<"null"<<endl;
        fout.close();
        cout<<"Initial finger table generated"<<endl;
        if(old_server=="null") {
            cout<<"Initializing initial neighbours"<<endl;
            fout.open(NEIGHBOURS);
            fout<<"-1"<<endl;
            fout<<"-1"<<endl;
            fout.close();
            cout<<"Initialized initial neighbours"<<endl;
            return;
        }
        channel=grpc::CreateChannel(old_server,grpc::InsecureChannelCredentials());
        stub=KeyValueServices::NewStub(channel);
        info.set_address(my_address);
        SuccessorInfo successorInfo;
        ClientContext context1;
        cout<<"Sending request to server: "<<old_server<<endl;
        status=stub->NEW(&context1,info,&successorInfo);
        cout<<"Request sent. Successor and predecessor info received"<<endl;
        if(status.ok()) {
            string successor=successorInfo.succaddress();
            string predecessor=successorInfo.predaddress();
            ofstream fout;
            cout<<"Storing neighbours info"<<endl;
            fout.open(NEIGHBOURS);
            fout<<successor<<endl;
            fout<<predecessor<<endl;
            fout.close();
            cout<<"Successor: "<<successor<<endl;
            cout<<"Predecessor: "<<predecessor<<endl;
            cout<<"Stored neighbours info"<<endl;
            channel=grpc::CreateChannel(successor,grpc::InsecureChannelCredentials());
            stub=KeyValueServices::NewStub(channel);
            info.set_address(my_address);
            KeyValues keyValues;
            ClientContext context2;
            cout<<"Informing successor about my presence"<<endl;
            status=stub->INFORMSUCCESSOR(&context2,info,&keyValues);
            string keys=keyValues.keys();
            string values=keyValues.values();
            while(true) {
                string key=keys.substr(0,keys.find(';'));
                string value=values.substr(0,values.find(';'));
                if(key.size()==0)
                    break;
                if(keys.find(';')+1==keys.size())
                    break;
                keys=keys.substr(keys.find(';')+1);
                values=values.substr(values.find(';')+1);
                memManager->put(key,value);
            }
            cout<<"Informed succesor"<<endl;
            channel=grpc::CreateChannel(predecessor,grpc::InsecureChannelCredentials());
            stub=KeyValueServices::NewStub(channel);
            info.set_address(my_address);
            ClientContext context3;
            cout<<"Informing predecessor about my presence"<<endl;
            status=stub->INFORMPREDECESSOR(&context3,info,&null);
            cout<<"Informed predecessor"<<endl;
            updateAllFingerTables();
        }
    }
}

int main(int agrc, char **argv) {
    pthread_mutex_init(&_masterLock, NULL);
    start = false;
    getConfig();

    int num_threads = stoi(params.find("NUM_SERVER_THREADS")->second);
    int port = stoi(params.find("LISTENING_PORT")->second);
    string server_address("0.0.0.0:" + to_string(port));
    string cache_type = params.find("CACHE_REPLACEMENT_TYPE")->second;
    pthread_cond_init(&startRpcs, NULL);
    pthread_mutex_init(&myLock, NULL);

    if (cache_type.compare("LFU") == 0)
        memManager = new storageLFU(stoi(params.find("CACHE_SIZE")->second));
    else
        memManager = new storageLRU(stoi(params.find("CACHE_SIZE")->second));

    register_server_DNS(server_address);

    setupServer(server_address);
    assignThreads(num_threads);
    sleep(2);
    signal(SIGINT, signalHandler);

    server = builder.BuildAndStart();
    start = true;
    cout << "SERVER COMES UP SUCCESSFULLY" << endl;

    pthread_cond_broadcast(&startRpcs);
    for (int i = 0; i < num_threads; i++)
        pthread_join(workers[i], NULL);

    free(workers);
    free(worker_id);
    return 0;
}
