#include <bits/stdc++.h>
#include <grpcpp/grpcpp.h>
#include<fstream>
#include "keyvaluestore.grpc.pb.h"
#define SERVERS "serverlist.txt"

using namespace std;

using grpc::Server;
using grpc::ServerAsyncResponseWriter;
using grpc::ServerBuilder;
using grpc::ServerCompletionQueue;
using grpc::ServerContext;
using grpc::Status;
using grpc::Channel;
using grpc::ClientContext;
using keyvaluestore::KeyValueServices;
using keyvaluestore::Info;
using keyvaluestore::Null;
using keyvaluestore::Addresses;

ServerBuilder builder;
KeyValueServices::AsyncService service;
std::unique_ptr<Server> server;

enum RequestType {
    GETADDRESS,
    ADDADDRESS,
    UPDATEFINGERTABLES,
    GETSERVERS
};

class DNSData {
public:
    DNSData(KeyValueServices::AsyncService *service, ServerCompletionQueue *cq, RequestType reqType) : service(service), cq(cq), getAddressResponder(&context), addAddressResponder(&context),updateFingerTablesResponder(&context),getServersResponder(&context), status(CREATE), reqType(reqType) {
        Proceed();
    }

    void Proceed() {
        if (status == CREATE) {
            status = PROCESS;
            if(reqType==GETADDRESS)
                service->RequestGETADDRESS(&context, &null, &getAddressResponder, cq, cq, this);
            else if(reqType==ADDADDRESS)
                service->RequestADDADDRESS(&context, &info, &addAddressResponder, cq, cq, this);
            else if(reqType==UPDATEFINGERTABLES)
                service->RequestUPDATEFINGERTABLES(&context,&null,&updateFingerTablesResponder,cq,cq,this);
            else
                service->RequestGETSERVERS(&context,&null,&getServersResponder,cq,cq,this);
        }
        else if (status == PROCESS) {
            new DNSData(service, cq, reqType);
            if(reqType==GETADDRESS) {
                ifstream fin;
                int size=0;
                map<int,string> servers;
                fin.open(SERVERS);
                do {
                    string temp;
                    getline(fin,temp);
                    if(temp.size()==0)
                        break;
                    servers[size++]=temp;
                }while(fin);
                fin.close();
                if(size==0)
                    info.set_address("null");
                else {
                    int x=rand()%size;
                    info.set_address(servers.find(x)->second);
                }
                getAddressResponder.Finish(info,Status::OK,this);
            }
            else if(reqType==ADDADDRESS){
                ifstream fin;
                fin.open(SERVERS);
                int size=0;
                map<int,string> svs;
                do {
                    string temp;
                    getline(fin,temp);
                    if(temp.size()==0)
                        break;
                    svs[size++]=temp;
                } while(fin);
                fin.close();
                string addresses[size+1];
                int count=0;
                string addtoadd=info.address();
                int porttoadd=stoi(addtoadd.substr(addtoadd.find(':')+1));
                bool flag=false;
                for(int i=0;i<size;i++) {
                    int curr_port=stoi(svs[i].substr(svs[i].find(':')+1));
                    if(porttoadd<curr_port&&flag==false) {
                        addresses[count++]=addtoadd;
                        flag=true;
                    }
                    addresses[count++]=svs[i];
                }
                if(flag==false)
                    addresses[count++]=addtoadd;
                ofstream fout;
                fout.open(SERVERS);
                for(int i=0;i<count;i++)
                    fout<<addresses[i]<<endl;
                fout.close();
                null.set_nothing(0);
                cout<<info.address()<<endl;
                addAddressResponder.Finish(null,Status::OK,this);
            }
            else if(reqType==UPDATEFINGERTABLES){
                ifstream fin;
                int index=0;
                map<int,string> servers;
                fin.open(SERVERS);
                do {
                    string temp;
                    getline(fin,temp);
                    if(temp.size()==0)
                        break;
                    servers[index++]=temp;
                }while(fin);
                fin.close();
                string addressarr="";
                for(int i=0;i<index;i++)
                    addressarr+=servers[i]+";";
                for(int i=0;i<index;i++) {
                    string target_address(servers[i]);
                    shared_ptr<Channel> channel=grpc::CreateChannel(target_address, grpc::InsecureChannelCredentials());
                    unique_ptr<KeyValueServices::Stub> stub;
                    stub=KeyValueServices::NewStub(channel);
                    Null null;
                    ClientContext cont;
                    Addresses addr;
                    addr.set_addresses(addressarr);
                    addr.set_servers(index);
                    stub->UPDATETABLE(&cont,addr,&null);
                }
                updateFingerTablesResponder.Finish(null,Status::OK,this);
            }
            else {
                ifstream fin;
                int index=0;
                map<int,string> servers;
                fin.open(SERVERS);
                do {
                    string temp;
                    getline(fin,temp);
                    if(temp.size()==0)
                        break;
                    servers[index++]=temp;
                }while(fin);
                fin.close();
                string addressarr="";
                for(int i=0;i<index;i++)
                    addressarr+=servers[i]+";";
                addr1.set_addresses(addressarr);
                addr1.set_servers(index);
                getServersResponder.Finish(addr1,Status::OK,this);
            }
            status = FINISH;
        }
        else {
            GPR_ASSERT(status == FINISH);
            delete this;
        }
    }

private:
    KeyValueServices::AsyncService *service;
    ServerCompletionQueue *cq;
    ServerContext context;
    Null null;
    Info info;
    Addresses addr1;
    ServerAsyncResponseWriter<Info> getAddressResponder;
    ServerAsyncResponseWriter<Null> addAddressResponder;
    ServerAsyncResponseWriter<Null> updateFingerTablesResponder;
    ServerAsyncResponseWriter<Addresses> getServersResponder;
    enum CallStatus {
        CREATE,
        PROCESS,
        FINISH
    };
    CallStatus status;
    RequestType reqType;
};

void signalHandler(int signum) {
    remove(SERVERS);
    exit(0);
}

int main(int argc,char **argv) {
    signal(SIGINT, signalHandler);
    srand(time(0));
    string server_address("0.0.0.0:1234");
    builder.AddListeningPort(server_address, grpc::InsecureServerCredentials());
    builder.RegisterService(&service);
    unique_ptr<ServerCompletionQueue> comp_queue=builder.AddCompletionQueue();
    server = builder.BuildAndStart();
    cout<<"DNS SERVER COMES UP SUCCESSFULLY"<<endl;
    new DNSData(&service,comp_queue.get(),GETADDRESS);
    new DNSData(&service,comp_queue.get(),ADDADDRESS);
    new DNSData(&service,comp_queue.get(),UPDATEFINGERTABLES);
    new DNSData(&service,comp_queue.get(),GETSERVERS);
    void *tag;
    bool ok;
    while(true) {
        GPR_ASSERT(comp_queue->Next(&tag,&ok));
        GPR_ASSERT(ok);
        static_cast<DNSData *>(tag)->Proceed();
    }
}