using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Text;
using System.Windows.Forms;
//using System.Windows.Controls;
//using RichTextBox;


namespace RichTextEditor
{


    public partial class frmMain : Form
    {

        // constructor
        public frmMain()
        {
            InitializeComponent();
            currentFile = "";
            this.Text = "Editor: New Document";

        }

        private void spelling_DeletedWord(object sender, NetSpell.SpellChecker.SpellingEventArgs e)
        {
            int start = this.rtbDoc.SelectionStart;
            int length = this.rtbDoc.SelectionLength;

            this.rtbDoc.Select(e.TextIndex, e.Word.Length);
            this.rtbDoc.SelectedText = "";

            if (start > this.rtbDoc.Text.Length)
                start = this.rtbDoc.Text.Length;

            if ((start + length) > this.rtbDoc.Text.Length)
                length = 0;

            this.rtbDoc.Select(start, length);
        }

        private void spelling_ReplacedWord(object sender, NetSpell.SpellChecker.ReplaceWordEventArgs e)
        {
            int start = this.rtbDoc.SelectionStart;
            int length = this.rtbDoc.SelectionLength;

            this.rtbDoc.Select(e.TextIndex, e.Word.Length);
            this.rtbDoc.SelectedText = e.ReplacementWord;

            if (start > this.rtbDoc.Text.Length)
                start = this.rtbDoc.Text.Length;

            if ((start + length) > this.rtbDoc.Text.Length)
                length = 0;

            this.rtbDoc.Select(start, length);
        }

        private void spelling_EndOfText(object sender, System.EventArgs e)
        {
            Console.WriteLine("EndOfText");
        }



        #region "Declaration"

        private string currentFile;
        private int checkPrint;

        #endregion



        #region "Menu Methods"


        private void NewToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                if (rtbDoc.Modified == true)
                {
                    System.Windows.Forms.DialogResult answer;
                    answer = MessageBox.Show("Save current document before creating new document?", "Unsaved Document", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                    if (answer == System.Windows.Forms.DialogResult.No)
                    {

                        currentFile = "";
                        this.Text = "Editor: New Document";
                        rtbDoc.Modified = false;
                        rtbDoc.Clear();
                        return;
                    }
                    else
                    {
                        SaveToolStripMenuItem_Click(this, new EventArgs());
                        rtbDoc.Modified = false;
                        rtbDoc.Clear();
                        currentFile = "";
                        this.Text = "Editor: New Document";
                        return;
                    }
                }
                else
                {
                    currentFile = "";
                    this.Text = "Editor: New Document";
                    rtbDoc.Modified = false;
                    rtbDoc.Clear();
                    return;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }




        private void OpenToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                if (rtbDoc.Modified == true)
                {
                    System.Windows.Forms.DialogResult answer;
                    answer = MessageBox.Show("Save current file before opening another document?", "Unsaved Document", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                    if (answer == System.Windows.Forms.DialogResult.No)
                    {
                        rtbDoc.Modified = false;
                        OpenFile();
                    }
                    else
                    {
                        SaveToolStripMenuItem_Click(this, new EventArgs());
                        OpenFile();
                    }
                }
                else
                {
                    OpenFile();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }

        private void OpenFile()
        {
            try
            {
                OpenFileDialog1.Title = "RTE - Open File";
                OpenFileDialog1.DefaultExt = "rtf";
                OpenFileDialog1.Filter = "Rich Text Files|*.rtf|Text Files|*.txt|HTML Files|*.htm|All Files|*.*";
                OpenFileDialog1.FilterIndex = 1;
                OpenFileDialog1.FileName = string.Empty;

                if (OpenFileDialog1.ShowDialog() == DialogResult.OK)
                {

                    if (OpenFileDialog1.FileName == "")
                    {
                        return;
                    }

                    string strExt;
                    strExt = System.IO.Path.GetExtension(OpenFileDialog1.FileName);
                    strExt = strExt.ToUpper();

                    if (strExt == ".RTF")
                    {
                        rtbDoc.LoadFile(OpenFileDialog1.FileName, RichTextBoxStreamType.RichText);
                    }
                    else
                    {
                        System.IO.StreamReader txtReader;
                        txtReader = new System.IO.StreamReader(OpenFileDialog1.FileName);
                        rtbDoc.Text = txtReader.ReadToEnd();
                        txtReader.Close();
                        txtReader = null;
                        rtbDoc.SelectionStart = 0;
                        rtbDoc.SelectionLength = 0;
                    }

                    currentFile = OpenFileDialog1.FileName;
                    rtbDoc.Modified = false;
                    this.Text = "Editor: " + currentFile.ToString();
                }
                else
                {
                    MessageBox.Show("Open File request cancelled by user.", "Cancelled");
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }


 /*       private void SaveToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                if (currentFile == string.Empty)
                {
                    SaveAsToolStripMenuItem_Click(this, e);
                    return;
                }

                try
                {
                    string strExt;
                    strExt = System.IO.Path.GetExtension(currentFile);
                    strExt = strExt.ToUpper();
                    if (strExt == ".RTF")
                    {
                        rtbDoc.SaveFile(currentFile);
                    }
                    else
                    {
                        System.IO.StreamWriter txtWriter;
                        txtWriter = new System.IO.StreamWriter(currentFile);
                        txtWriter.Write(rtbDoc.Text);
                        txtWriter.Close();
                        txtWriter = null;
                        rtbDoc.SelectionStart = 0;
                        rtbDoc.SelectionLength = 0;
                    }

                    this.Text = "Editor: " + currentFile.ToString();
                    rtbDoc.Modified = false;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message.ToString(), "File Save Error");
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }


        }
*/

        private void SaveAsToolStripMenuItem_Click(object sender, System.EventArgs e)
        {

            try
            {
                SaveFileDialog1.Title = "RTE - Save File";
                SaveFileDialog1.DefaultExt = "rtf";
                SaveFileDialog1.Filter = "Rich Text Files|*.rtf|Text Files|*.txt|HTML Files|*.htm|All Files|*.*";
                SaveFileDialog1.FilterIndex = 1;

                if (SaveFileDialog1.ShowDialog() == DialogResult.OK)
                {

                    if (SaveFileDialog1.FileName == "")
                    {
                        return;
                    }

                    string strExt;
                    strExt = System.IO.Path.GetExtension(SaveFileDialog1.FileName);
                    strExt = strExt.ToUpper();

                    if (strExt == ".RTF")
                    {
                        rtbDoc.SaveFile(SaveFileDialog1.FileName, RichTextBoxStreamType.RichText);
                    }
                    else
                    {
                        System.IO.StreamWriter txtWriter;
                        txtWriter = new System.IO.StreamWriter(SaveFileDialog1.FileName);
                        txtWriter.Write(rtbDoc.Text);
                        txtWriter.Close();
                        txtWriter = null;
                        rtbDoc.SelectionStart = 0;
                        rtbDoc.SelectionLength = 0;
                    }
                    currentFile = SaveFileDialog1.FileName;


                    string connectionString = @"Server=localhost;Database=master;Trusted_Connection=True;";
                    SqlConnection sqlCon = new SqlConnection(connectionString);
                    sqlCon.Open();

                    currentFile = SaveFileDialog1.FileName;
                    string filen = Path.GetFileName(currentFile);
                    int siz = SaveFileDialog1.FileName.Length;
                    string strPath = SaveFileDialog1.FileName;
                    string commandString = "insert into WPTable(fname,path,size,date) values (@fname ,@path, @size ,@date)";

                    SqlCommand sqlCmd = new SqlCommand(commandString, sqlCon);
                    sqlCmd.Parameters.AddWithValue("@fname", filen);
                    sqlCmd.Parameters.AddWithValue("@path", strPath);
                    sqlCmd.Parameters.AddWithValue("@size", siz);
                    sqlCmd.Parameters.AddWithValue("@date", DateTime.Now);
                    sqlCmd.ExecuteNonQuery();
                    sqlCon.Close();

                    currentFile = SaveFileDialog1.FileName;
                    rtbDoc.Modified = false;
                    this.Text = "Editor: " + currentFile.ToString();
                    MessageBox.Show(currentFile.ToString() + " saved.", "File Save");
                }
                else
                {
                    MessageBox.Show("Save File request cancelled by user.", "Cancelled");
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }




        private void SaveToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                if (currentFile == string.Empty)
                {
                    SaveAsToolStripMenuItem_Click(this, e);
                    return;
                }

                try
                {
                    string strExt;
                    strExt = System.IO.Path.GetExtension(currentFile);
                    strExt = strExt.ToUpper();
                    if (strExt == ".RTF")
                    {
                        rtbDoc.SaveFile(currentFile);
                    }
                    else
                    {
                        System.IO.StreamWriter txtWriter;
                        txtWriter = new System.IO.StreamWriter(currentFile);
                        txtWriter.Write(rtbDoc.Text);
                        txtWriter.Close();
                        txtWriter = null;
                        rtbDoc.SelectionStart = 0;
                        rtbDoc.SelectionLength = 0;
                    }

                    currentFile = SaveFileDialog1.FileName;


                    string connectionString = @"Server=localhost;Database=master;Trusted_Connection=True;";
                    SqlConnection sqlCon = new SqlConnection(connectionString);
                    sqlCon.Open();

                    currentFile = SaveFileDialog1.FileName;
                    string filen = Path.GetFileName(currentFile);
                    int siz = SaveFileDialog1.FileName.Length;
                    string strPath = SaveFileDialog1.FileName;
                    string commandString = "insert into WPTable(fname,path,size,date) values (@fname ,@path, @size ,@date)";

                    SqlCommand sqlCmd = new SqlCommand(commandString, sqlCon);
                    sqlCmd.Parameters.AddWithValue("@fname", filen);
                    sqlCmd.Parameters.AddWithValue("@path", strPath);
                    sqlCmd.Parameters.AddWithValue("@size", siz);
                    sqlCmd.Parameters.AddWithValue("@date", DateTime.Now);
                    sqlCmd.ExecuteNonQuery();
                    sqlCon.Close(); 

                    this.Text = "Editor: " + currentFile.ToString();
                    rtbDoc.Modified = false;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message.ToString(), "File Save Error");
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }


        }


/*        private void SaveAsToolStripMenuItem_Click(object sender, System.EventArgs e)
        {

            try
            {
                SaveFileDialog1.Title = "RTE - Save File";
                SaveFileDialog1.DefaultExt = "rtf";
                SaveFileDialog1.Filter = "Rich Text Files|*.rtf";
                SaveFileDialog1.FilterIndex = 1;
                if (SaveFileDialog1.ShowDialog() == DialogResult.OK)
                {

                    if (SaveFileDialog1.FileName == "")
                    {
                        return;
                    }
                    
                    rtbDoc.SaveFile(SaveFileDialog1.FileName, RichTextBoxStreamType.RichText);

                    currentFile = SaveFileDialog1.FileName;


                    string connectionString = @"Server=localhost;Database=master;Trusted_Connection=True;";
                    SqlConnection sqlCon = new SqlConnection(connectionString);
                    sqlCon.Open();

                    currentFile = SaveFileDialog1.FileName;
                    string filen = Path.GetFileName(currentFile);
                    int siz = SaveFileDialog1.FileName.Length;
                    string strPath = SaveFileDialog1.FileName;
                    string commandString = "insert into WPTable(fname,path,size,date) values (@fname ,@path, @size ,@date)";

                    SqlCommand sqlCmd = new SqlCommand(commandString, sqlCon);
                    sqlCmd.Parameters.AddWithValue("@fname", filen);
                    sqlCmd.Parameters.AddWithValue("@path", strPath);
                    sqlCmd.Parameters.AddWithValue("@size", siz);
                    sqlCmd.Parameters.AddWithValue("date", DateTime.Now);
                    sqlCmd.ExecuteNonQuery();
                    sqlCon.Close();

                    rtbDoc.Modified = false;
                    this.Text = "Editor: " + currentFile.ToString();
                    MessageBox.Show(currentFile.ToString() + " saved.", "File Save");
                }
                else
                {
                    MessageBox.Show("Save File request cancelled by user.", "Cancelled");
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }

            */


        private void ExitToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                if (rtbDoc.Modified == true)
                {
                    System.Windows.Forms.DialogResult answer;
                    answer = MessageBox.Show("Save this document before closing?", "Unsaved Document", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                    if (answer == System.Windows.Forms.DialogResult.Yes)
                    {
                        return;
                    }
                    else
                    {
                        rtbDoc.Modified = false;
                        Application.Exit();
                    }
                }
                else
                {
                    rtbDoc.Modified = false;
                    Application.Exit();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }




        private void SelectAllToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                rtbDoc.SelectAll();
            }
            catch (Exception)
            {
                MessageBox.Show("Unable to select all document content.", "RTE - Select", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }




        private void CopyToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                rtbDoc.Copy();
            }
            catch (Exception)
            {
                MessageBox.Show("Unable to copy document content.", "RTE - Copy", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }




        private void CutToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                rtbDoc.Cut();
            }
            catch
            {
                MessageBox.Show("Unable to cut document content.", "RTE - Cut", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }




        private void PasteToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                rtbDoc.Paste();
            }
            catch
            {
                MessageBox.Show("Unable to copy clipboard content to document.", "RTE - Paste", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void SelectFontToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                if (!(rtbDoc.SelectionFont == null))
                {
                    FontDialog1.Font = rtbDoc.SelectionFont;
                }
                else
                {
                    FontDialog1.Font = null;
                }
                FontDialog1.ShowApply = true;
                DialogResult result = FontDialog1.ShowDialog();
                if (result == System.Windows.Forms.DialogResult.OK)
                {
                    rtbDoc.SelectionFont = FontDialog1.Font;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }

        private void FontColorToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                ColorDialog1.Color = rtbDoc.ForeColor;
                if (ColorDialog1.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                {
                    rtbDoc.SelectionColor = ColorDialog1.Color;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }

        private void BoldToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                if (!(rtbDoc.SelectionFont == null))
                {
                    System.Drawing.Font currentFont = rtbDoc.SelectionFont;
                    System.Drawing.FontStyle newFontStyle;

                    newFontStyle = rtbDoc.SelectionFont.Style ^ FontStyle.Bold;

                    rtbDoc.SelectionFont = new Font(currentFont.FontFamily, currentFont.Size, newFontStyle);

                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }

        private void ItalicToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                if (!(rtbDoc.SelectionFont == null))
                {
                    System.Drawing.Font currentFont = rtbDoc.SelectionFont;
                    System.Drawing.FontStyle newFontStyle;

                    newFontStyle = rtbDoc.SelectionFont.Style ^ FontStyle.Italic;

                    rtbDoc.SelectionFont = new Font(currentFont.FontFamily, currentFont.Size, newFontStyle);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }

        private void UnderlineToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                if (!(rtbDoc.SelectionFont == null))
                {
                    System.Drawing.Font currentFont = rtbDoc.SelectionFont;
                    System.Drawing.FontStyle newFontStyle;

                    newFontStyle = rtbDoc.SelectionFont.Style ^ FontStyle.Underline;

                    rtbDoc.SelectionFont = new Font(currentFont.FontFamily, currentFont.Size, newFontStyle);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }





        private void NormalToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                if (!(rtbDoc.SelectionFont == null))
                {
                    System.Drawing.Font currentFont = rtbDoc.SelectionFont;
                    System.Drawing.FontStyle newFontStyle;
                    newFontStyle = FontStyle.Regular;
                    rtbDoc.SelectionFont = new Font(currentFont.FontFamily, currentFont.Size, newFontStyle);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }




        private void PageColorToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                ColorDialog1.Color = rtbDoc.BackColor;
                if (ColorDialog1.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                {
                    rtbDoc.BackColor = ColorDialog1.Color;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }




        private void mnuUndo_Click(object sender, System.EventArgs e)
        {
            try
            {
                if (rtbDoc.CanUndo)
                {
                    rtbDoc.Undo();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }




        private void mnuRedo_Click(object sender, System.EventArgs e)
        {
            try
            {
                if (rtbDoc.CanRedo)
                {
                    rtbDoc.Redo();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }

        private void LeftToolStripMenuItem_Click_1(object sender, System.EventArgs e)
        {
            try
            {
                rtbDoc.SelectionAlignment = HorizontalAlignment.Left;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }

        private void CenterToolStripMenuItem_Click_1(object sender, System.EventArgs e)
        {
            try
            {
                rtbDoc.SelectionAlignment = HorizontalAlignment.Center;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }

        private void RightToolStripMenuItem_Click_1(object sender, System.EventArgs e)
        {
            try
            {
                rtbDoc.SelectionAlignment = HorizontalAlignment.Right;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }

        private void AddBulletsToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                rtbDoc.BulletIndent = 10;
                rtbDoc.SelectionBullet = true;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }

        private void RemoveBulletsToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                rtbDoc.SelectionBullet = false;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }




        private void mnuIndent0_Click(object sender, System.EventArgs e)
        {
            try
            {
                rtbDoc.SelectionIndent = 0;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }




        private void mnuIndent5_Click(object sender, System.EventArgs e)
        {
            try
            {
                rtbDoc.SelectionIndent = 5;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }




        private void mnuIndent10_Click(object sender, System.EventArgs e)
        {
            try
            {
                rtbDoc.SelectionIndent = 10;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }




        private void mnuIndent15_Click(object sender, System.EventArgs e)
        {
            try
            {
                rtbDoc.SelectionIndent = 15;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }




        private void mnuIndent20_Click(object sender, System.EventArgs e)
        {
            try
            {
                rtbDoc.SelectionIndent = 20;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }

        }




        private void FindToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                frmFind f = new frmFind(this);
                f.Show();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }




        private void FindAndReplaceToolStripMenuItem_Click(object sender, System.EventArgs e)
        {
            try
            {
                frmReplace f = new frmReplace(this);
                f.Show();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }




        /*      private void PreviewToolStripMenuItem_Click(object sender, System.EventArgs e)
              {
                  try
                  {
                      PrintPreviewDialog1.Document = PrintDocument1;
                      PrintPreviewDialog1.ShowDialog();
                  }
                  catch (Exception ex)
                  {
                      MessageBox.Show(ex.Message.ToString(), "Error");
                  }
              }




          /*    private void PrintToolStripMenuItem_Click(object sender, System.EventArgs e)
              {
                  try
                  {
                      PrintDialog1.Document = PrintDocument1;
                      if (PrintDialog1.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                      {
                          PrintDocument1.Print();
                      }
                  }
                  catch (Exception ex)
                  {
                      MessageBox.Show(ex.Message.ToString(), "Error");
                  }
              }




              private void mnuPageSetup_Click(object sender, System.EventArgs e)
              {
                  try
                  {
                      PageSetupDialog1.Document = PrintDocument1;
                      PageSetupDialog1.ShowDialog();
                  }
                  catch (Exception ex)
                  {
                      MessageBox.Show(ex.Message.ToString(), "Error");
                  }
              }

          */


        private void InsertImageToolStripMenuItem_Click(object sender, System.EventArgs e)
        {

        }


        private void rtbDoc_SelectionChanged(object sender, EventArgs e)
        {
            tbrBold.Checked = rtbDoc.SelectionFont.Bold;
            tbrItalic.Checked = rtbDoc.SelectionFont.Italic;
            tbrUnderline.Checked = rtbDoc.SelectionFont.Underline;
        }




        #endregion




        #region Toolbar Methods


        private void tbrSave_Click(object sender, System.EventArgs e)
        {
            SaveToolStripMenuItem_Click(this, e);
        }


        private void tbrOpen_Click(object sender, System.EventArgs e)
        {
            OpenToolStripMenuItem_Click(this, e);
        }


        private void tbrNew_Click(object sender, System.EventArgs e)
        {
            NewToolStripMenuItem_Click(this, e);
        }


        private void tbrBold_Click(object sender, System.EventArgs e)
        {
            BoldToolStripMenuItem_Click(this, e);
        }


        private void tbrItalic_Click(object sender, System.EventArgs e)
        {
            ItalicToolStripMenuItem_Click(this, e);
        }


        private void tbrUnderline_Click(object sender, System.EventArgs e)
        {
            UnderlineToolStripMenuItem_Click(this, e);
        }


        private void tbrFont_Click(object sender, System.EventArgs e)
        {
            SelectFontToolStripMenuItem_Click(this, e);
        }


        private void tbrLeft_Click(object sender, System.EventArgs e)
        {
            rtbDoc.SelectionAlignment = HorizontalAlignment.Left;
        }


        private void tbrCenter_Click(object sender, System.EventArgs e)
        {
            rtbDoc.SelectionAlignment = HorizontalAlignment.Center;
        }


        private void tbrRight_Click(object sender, System.EventArgs e)
        {
            rtbDoc.SelectionAlignment = HorizontalAlignment.Right;
        }


        private void tbrFind_Click(object sender, System.EventArgs e)
        {
            frmFind f = new frmFind(this);
            f.Show();
        }


        private void tspColor_Click(object sender, EventArgs e)
        {
            FontColorToolStripMenuItem_Click(this, new EventArgs());
        }




        #endregion





        /*

        private void PrintDocument1_BeginPrint(object sender, System.Drawing.Printing.PrintEventArgs e)
        {

            checkPrint = 0;

        }

        

        private void PrintDocument1_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {

            checkPrint = rtbDoc.Print(checkPrint, rtbDoc.TextLength, e);

            if (checkPrint < rtbDoc.TextLength)
            {
                e.HasMorePages = true;
            }
            else
            {
                e.HasMorePages = false;
            }

        }



               

#endregion
    */



        #region Form Closing Handler


        private void frmMain_FormClosing(object sender, FormClosingEventArgs e)
        {
            try
            {
                if (rtbDoc.Modified == true)
                {
                    System.Windows.Forms.DialogResult answer;
                    answer = MessageBox.Show("Save current document before exiting?", "Unsaved Document", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                    if (answer == System.Windows.Forms.DialogResult.No)
                    {
                        rtbDoc.Modified = false;
                        rtbDoc.Clear();
                        return;
                    }
                    else
                    {
                        SaveToolStripMenuItem_Click(this, new EventArgs());
                    }
                }
                else
                {
                    rtbDoc.Clear();
                }
                currentFile = "";
                this.Text = "Editor: New Document";
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }





        #endregion

        private void openFileDialog2_FileOk(object sender, CancelEventArgs e)
        {

        }

        private void OpenFileDialog1_FileOk(object sender, CancelEventArgs e)
        {

        }

        private void superscriptToolStripMenuItem_Click(object sender, EventArgs e)
        {
           // if (rtbDoc.SelectionCharOffset <= 0)
          //  {
                rtbDoc.SelectionCharOffset = 5;
          //  }
          //  else
          //  {
           //     rtbDoc.SelectionCharOffset = 0;
           // }
        }

        private void subScriptToolStripMenuItem_Click(object sender, EventArgs e)
        {
          //  if (rtbDoc.SelectionCharOffset >= 0)
          //  {
                rtbDoc.SelectionCharOffset = -5;
          //  }
          //  else
          //  {
           //     rtbDoc.SelectionCharOffset = 0;
          //  }
        }

        private void LowerCaseToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (rtbDoc.SelectedText != null)
            {
                rtbDoc.SelectedText = rtbDoc.SelectedText.ToLower();
            }
        }

        private void UpperCaseToolStripMenuItem_Click_1(object sender, EventArgs e)
        {
            try
            {
                rtbDoc.SelectedText = rtbDoc.SelectedText.ToUpper();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }


        }


        public string ToggleCase(string input)
        {
            string result = string.Empty;
            char[] inputArray = input.ToCharArray();
            foreach (char c in inputArray)
            {
                if (char.IsLower(c))
                    result += Char.ToUpper(c);
                else
                    result += Char.ToLower(c);
            }
            return result;
        }


        private void strikethroughToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                if (!(rtbDoc.SelectionFont == null))
                {
                    System.Drawing.Font currentFont = rtbDoc.SelectionFont;
                    System.Drawing.FontStyle newFontStyle;

                    newFontStyle = rtbDoc.SelectionFont.Style ^ FontStyle.Strikeout;

                    rtbDoc.SelectionFont = new Font(currentFont.FontFamily, currentFont.Size, newFontStyle);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }

        private void toggleCaseToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (rtbDoc.SelectedText != null)
            {
                rtbDoc.SelectedText = ToggleCase(rtbDoc.SelectedText);
            }
        }

        private void wordCountToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogResult answer = MessageBox.Show("The number of words present in current document is:\n" + rtbDoc.Text.Split(null).Length, "Word Count", MessageBoxButtons.OK);
           // rtbDoc.SelectionBackColor = Color.Yellow;
            /* if (SaveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                return;
            }*/
        }

        private void tableToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                // string str = null;
                frmTable t = new frmTable(this);
                t.ShowDialog();
                //MessageBox.Show(str, "Error");
                string d = rtbDoc.Rtf.Remove(rtbDoc.Rtf.Length - 3);
                // MessageBox.Show(d, "Error");
                rtbDoc.Rtf = d + t.ReturnValue1 + @"}";
                MessageBox.Show(rtbDoc.Rtf, "Debug");
                // rtbDoc.Rtf = t.ReturnValue1;
                // rtbDoc.Rtf = "{\\rtf1\\ansi\\deff0\\trowd\\cellx1000\\cellx2000\\cellx3000\\intbl cell 1\\cell\\intbl cell 2\\cell\\intbl cell 3\\cell\\row\\trowd\\cellx1000\\cellx2000\\cellx3000\\intbl cell 1\\cell\\intbl cell 2\\cell\\intbl cell 3\\cell\\row}";
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error");
            }
        }

        private void imageToolStripMenuItem_Click(object sender, EventArgs e)
        {

            OpenFileDialog1.Title = "RTE - Insert Image File";
            OpenFileDialog1.DefaultExt = "rtf";
            OpenFileDialog1.Filter = "Bitmap Files|*.bmp|JPEG Files|*.jpg|GIF Files|*.gif";
            OpenFileDialog1.FilterIndex = 1;
            OpenFileDialog1.ShowDialog();

            if (OpenFileDialog1.FileName == "")
            {
                return;
            }

            try
            {
                string strImagePath = OpenFileDialog1.FileName;
                System.Drawing.Image img;
                img = System.Drawing.Image.FromFile(strImagePath);
                Clipboard.SetDataObject(img);
                DataFormats.Format df;
                df = DataFormats.GetFormat(DataFormats.Bitmap);
                if (this.rtbDoc.CanPaste(df))
                {
                    this.rtbDoc.Paste(df);
                }
            }
            catch
            {
                MessageBox.Show("Unable to insert image format selected.", "RTE - Paste", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void logsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            frmLog l = new frmLog();
            l.ShowDialog();
            /*
            string query = "SELECT * FROM WPTable";

            SqlConnection sqlConn = new SqlConnection(@"Server=localhost;Database=master;Trusted_Connection=True;");
            sqlConn.Open();
            SqlCommand cmd = new SqlCommand(query, sqlConn);
            SqlDataAdapter da = new SqlDataAdapter(cmd);
            DataTable dt = new DataTable();
            da.Fill(dt);
            sqlConn.Close();
            dataGridView1.DataSource = dt.DefaultView;*/
        }

        private void dataGridView1_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {

        }

       /* private void rtbDoc_SelectionChanged(object sender,EventArgs e)
        {

        }
        */
        private void rtbDoc_TextChanged(object sender, EventArgs e)
        {
            
                AddLineNumbers();
            
        }
        public int getWidth()
        {
            int w = 25;
            // get total lines of richTextBox1    
            int line = rtbDoc.Lines.Length;

            if (line <= 99)
            {
                w = 20 + (int)rtbDoc.Font.Size;
            }
            else if (line <= 999)
            {
                w = 30 + (int)rtbDoc.Font.Size;
            }
            else
            {
                w = 50 + (int)rtbDoc.Font.Size;
            }

            return w;
        }
        public void AddLineNumbers()
        {
            // create & set Point pt to (0,0)    
            Point pt = new Point(0, 0);
            // get First Index & First Line from richTextBox1    
            int First_Index = rtbDoc.GetCharIndexFromPosition(pt);
            int First_Line = rtbDoc.GetLineFromCharIndex(First_Index);
            // set X & Y coordinates of Point pt to ClientRectangle Width & Height respectively    
            pt.X = ClientRectangle.Width;
            pt.Y = ClientRectangle.Height;

            int Last_Index = rtbDoc.GetCharIndexFromPosition(pt);
            int Last_Line = rtbDoc.GetLineFromCharIndex(Last_Index);
            
            LineNumberTextBox.SelectionAlignment = HorizontalAlignment.Center;
            // set LineNumberTextBox text to null & width to getWidth() function value    
            LineNumberTextBox.Text = "";
            LineNumberTextBox.Width = getWidth();
            // now add each line number to LineNumberTextBox upto last line    
            for (int i = First_Line; i <= Last_Line ; i++)
            {
                LineNumberTextBox.Text += i + 1 + "\n";
            }
        }

        private void yellowToolStripMenuItem_Click(object sender, EventArgs e)
        {
            rtbDoc.SelectionBackColor = Color.Yellow;
        }

        private void orangeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            rtbDoc.SelectionBackColor = Color.Orange;
        }

        private void blueToolStripMenuItem_Click(object sender, EventArgs e)
        {
            rtbDoc.SelectionBackColor = Color.LightBlue;
        }

        private void greenToolStripMenuItem_Click(object sender, EventArgs e)
        {
            rtbDoc.SelectionBackColor = Color.LightGreen;
        }

        private void pinkToolStripMenuItem_Click(object sender, EventArgs e)
        {
            rtbDoc.SelectionBackColor = Color.LightPink;
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            this.spelling.Text = this.rtbDoc.Text;
            this.spelling.SpellCheck();
        }

        private void highlightToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }

        private void ParagraphToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }

        private void mnuAlign_Click(object sender, EventArgs e)
        {

        }
    }
}