// Program to implement display file.

#include<graphics.h>
#include<conio.h>
#include<stdio.h>
#include<math.h>

#define NULL 0

#define FALSE 0
#define TRUE 1

#define START_POSITION 0

// link list for display file
typedef struct dp{
    int opcode;
    int x;
    int y;
    struct dp * next;
}dp;

// function declaration
int menu();
int inputMenu();
int deleteMenu();
dp* createNode();
int shiftingOfPointY(int );
int round(float);
void clear();

FILE * openFile(char *);
void closeFile(FILE *);

void readFromFile(dp *,FILE *);
void writeInFile(dp *,FILE *);

void inputDisplayCmd(dp *,int,int,int);
void deleteFromDisplayCmd(dp *);

void drawOnScreen(dp *,dp*);
void print(dp *,int);

// gobal variables
dp *head = NULL;
FILE *fptr = NULL;

dp* openeditor()
{               dp* temp;
	/*fptr = open("save.txt","w");
		if(feof(fptr)) // no data in file
		{
	      	    printf("\n The File doesnot exists or File is Empty");
		    //closeFile(fptr);
	    	    break;
		}*/
		if(head == NULL)
		    head = createNode();
	/*	readFromFile(head,fptr);
	    	printf("Reading from file successful.");
		closeFile(fptr);
		drawOnScreen(head,NULL);*/
		if(head!=NULL) {
		temp=head;
		while(temp->next!=NULL)
			temp=temp->next;
		return temp;
		}
		return NULL;

}

void removeall()  //implement eraseall
{
	head=NULL;
}

void closeeditor()
{
		if(head == NULL){
	       //	    printf("There is nothing to write to the file");
		  //  break;
		}
		fptr = openFile("w");
		writeInFile(head,fptr);
		closeFile(fptr);

}

dp* saveeditor(dp* head,int opcode,int color,int x,int y)
{
	    if(head == NULL)
		head = createNode();
		inputDisplayCmd(head,opcode,x,y);
	    return head->next;
}
    /*
void main(){
    int gd=DETECT;
    int gm=0;
    initgraph(&gd,&gm,"..\\bgi");

    while(1){
	clear();
	switch(menu()){
	    case 1:
	    {
	    // read from file
	       //	clear();
	    //   printf("\n");
		fptr = openFile("r");
		if(feof(fptr)) // no data in file
		{
	    //	    printf("\n The File doesnot exists or File is Empty");
		    //closeFile(fptr);
		    break;
		}
		if(head == NULL)
		    head = createNode();
		//readFromFile(head,fptr);
	    //	printf("Reading from file successful.");
		//closeFile(fptr);
		break;
	    }

	    case 2:
	    {
	    // Write to file
	       //	clear();
	    //   printf("\n");
		if(head == NULL){
	      //	    printf("There is nothing to write to the file");
		    break;
		}
		fptr = openFile("w");
		writeInFile(head,fptr);
		closeFile(fptr);
	  //	printf("Writing on the file successful.");
		break;
	   }

	   case 3:
	   {
	   // make a display command list
	    dp * temp;
	    clear();
	    if(head == NULL){
		head = createNode();
		inputDisplayCmd(head);
	    }else{
		print(head,START_POSITION);
		temp = head;
		while(temp->next != NULL)
		    temp = temp->next;
		inputDisplayCmd(temp);
	    }
	    break;
	}

	case 4:
	{
	   // delete from display command list
		   clear();
		   if(head == NULL)
		   {
	    //	    printf("\n There is no list from delete");
			break;
			}
			deleteFromDisplayCmd(head);
		    break;
			}

   case 5:
	  {
	       // draw on screen
		   clear();
		   if(head == NULL)
		   {
	      //	    printf("\n There is no list to Draw");
			break;
			}
	       drawOnScreen(head,NULL);
		   break;
		   }
   case 6:
	  {
	   // display the command
		   clear();
		   if(head == NULL)
		   {
	       //	    printf("No data to display");
		    break;
			}

	//	   printf("\n The display file commands are : \n");
		   print(head,START_POSITION);
		   break;
		   }
   case 0:
	  {	flushall();
		exit(0);
		   }
   default :
		cleardevice();
	  //	printf("\n You have given wrong command");
   }// end of switch

  getch();
  } // end of while
 }
     */
// main menu
int menu()
{
 int value;

 /*
 printf("\n1. Read from File");
 printf("\n2. Write to File");
 printf("\n3. Add new command");
 printf("\n4. Delete command");
 printf("\n5. Draw On screen");
 printf("\n6. Show display file");
 printf("\n0. Exit");    */
 scanf("%d",&value);
 return value;
 }

// create new node(object)
dp* createNode()
{
 return (dp*)malloc(sizeof(dp));
 }

// open given file
FILE * openFile(char* mode)
{
 FILE *fptr;

 fptr = fopen("..\\save.txt",mode);

 return fptr;
 }

// close file
void closeFile(FILE *fptr)
{
 fclose(fptr);
 }

// writting data to the file in normalize form
void writeInFile(dp *record,FILE *fptr)
{
 float x,y;
 if(record->next != NULL)
 {  //   printf("F");
   // convert to normalize form
   x=((float)record->x)/((float)getmaxx());
   y=((float)record->y)/((float)getmaxy());

  fprintf(fptr,"%d %f %f ",record->opcode,x,y);
//  printf("%f %f \n",x,y);
  writeInFile(record->next,fptr);
  }
  return;
 }

// reading data from the file and converting it to screen co-ordinate form
void readFromFile(dp * record,FILE *fptr)
{
 int opcode;
 float x,y;
 while(1) {
 fscanf(fptr,"%d",&opcode);
 fscanf(fptr,"%f",&x);
 fscanf(fptr,"%f",&y);
  //  printf("%f %f ",x,y);
 if(!feof(fptr))
 {           //printf("H");
  record->opcode = opcode;
  record->x = round(x*getmaxx()); // convert to screen form
  record->y = round(y*getmaxy());
  record->next = createNode();
  }
 else
 {
  record->next = NULL;
  return ;
  }

 record=record->next; }
 }

// round value to nearest integer
int round(float value)
{
 int val;

 if(value - (int)value <= 0.5)
   val = floor(value);
 else
   val = ceil(value);

 return val;
 }

// function for inputing display file command
void inputDisplayCmd(dp *record,int opcode,int x,int y)
{
// int opcode,chk;
// int x,y;
	  /*
 chk = inputMenu();

 if(chk == -1)
 {
  record->opcode = -1;
  record->x =-1;
  record->y = -1;
  record->next = NULL;
  return;
  }

 printf("\n Enter values : ");
 opcode=chk;
 scanf("%d",&x);
 scanf("%d",&y);
		   */
 record->opcode = opcode;
 record->x = x;
 record->y = y;
 record->next = createNode();

 //inputDisplayCmd(record->next);
 }

int inputMenu()
{
 int chk;
 printf("\n Enter your Choice");
 printf("\n0. Moveto");
 printf("\n1. Lineto");
 printf("\n2. Moverel");
 printf("\n3. Linerel");
 printf("\n-1. Return to Main Menu");
 scanf("%d",&chk);
 return chk;
 }

// function for deleting display file command
void deleteFromDisplayCmd(dp *record)
{
 int chk,count;
 dp* prev=NULL;
while(1) {
 if(head==NULL)
  {
   printf("\n Nothing to delete");
   return;
  }
 chk = deleteMenu();

 if(chk == -1)
  return;
  prev=NULL;
  record=head;

 for(count = 1;count <chk ;count++)
 {
  if(record->next == NULL)
  {
   printf("\n Nothing to delete");
   return;
   }
   prev=record;
  record = record->next;
  }
 if(record==head)
{
	if(head->next!=NULL)
		head=head->next;
	else
		head=NULL;
}
 else
	prev->next=record->next;

  }
 }

int deleteMenu()
{
 int chk;
 printf("\n Enter your Choice");
 printf("\n The display file is : \n");
 print(head,START_POSITION);
 printf("\n Enter the position of the Object to delete or -1 to exit: ");
 scanf("%d",&chk);
 return chk;
 }

void print(dp * record,int count)
{
 if(record->next!= NULL)
 {
  printf(" %d -> %d (%d,%d)\n",++count,record->opcode,record->x,record->y);
  print(record->next,count);
  }
 return;
 }

void drawOnScreen(dp *record,dp* prev)
{ while(1) {
 if(record->next == NULL)
  return;
 switch(record->opcode)
 {
  case 0:
	 {
		  moveto(record->x,record->y);
		  break;
		  }
  case 1:
	 {
		  lineto(record->x,record->y);
		  break;
		  }
  case 2:
	 {
		  moveto(prev->x+record->x,(prev->y+record->y));
		  break;
		  }
  case 3:
	 {
		  lineto(prev->x+record->x,(prev->y+record->y));
		  break;
		  }

  default:
		  { }
  }
  prev=record;
 record=record->next; }
 }

int shiftingOfPointY(int y)
{
 return getmaxy() - y;
}

void clear()
{
 clrscr();
 cleardevice();
 }
