#!/usr/bin/python3
import csv
file = open('movie-ratings.csv')
readerObj = csv.reader(file)
data = list(readerObj)
userFile = open('user_preference.csv')
userObj = csv.reader(userFile)
temp = list(userObj)
def map( str ):
	if str=="The Godfather":
		return 1
	elif str=="Pulp Fiction":
		return 2
	elif str=="Gone With the Wind":
		return 3
	elif str=="12 Angry Men":
		return 4
	elif str=="Lawrence of Arabia":
		return 5
	elif str=="Raging Bull":
		return 6
	elif str=="The Clockwork Orange":
		return 7
	elif str=="Cinema Paradiso":
		return 8
	elif str=="Wild Strawberries":
		return 9
	elif str=="Amadeus":
		return 10
	else:
		return -1
userRatings = ["MyUser", -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
for i in range(10):
	if map(temp[0][i]) != -1:
		userRatings[map(temp[0][i])] = temp[1][i]
data.append(userRatings)
file.close()
userFile.close()
#data is complete at this point

# Pearson Correlation Basic Implementation Using for Loop

pearson = []
rows = len(data)
users = data[rows-1]
cols = len(users)
for x in range(1,rows-1): # does not include (rows-1)
	lis = data[x]
	sumprod = 0
	sumx = 0
	sumy = 0
	sumx2 = 0
	sumy2 = 0
	n = 0
	for y in range(1,cols):
		if(float(lis[y]) != -1 and float(users[y]) != -1):
			sumprod += float(lis[y])*float(users[y])
			sumx += float(lis[y])
			sumy += float(users[y])
			sumx2 += float(lis[y]) ** 2
			sumy2 += float(users[y]) ** 2
			n += 1
	
	if(n > 0):
		nume = n*sumprod - sumx*sumy
		deno = (n*sumx2 - sumx**2) * (n*sumy2 - sumy**2)
		deno = deno ** 0.5
		if(deno > 0):
			summ = nume / deno
		else:
			summ = 1
		data[x].append(summ)
	else:
		data[x].append(0)
# explicit choice to take summ = 1 for the corner case ... However, we were told no such "Pathological Cases" would be given
# print(data)

# Humanity's Answer : Suggesting Movies
review = []
for i in range(1,cols):
	if(float(users[i]) == -1):
		movie_name = data[0][i]
		movie_rate = 0
		sumcorrcoeff = 0
		for g in range(1,rows-1):
			if(float(data[g][i]) >= 0):
				movie_rate += float(data[g][i])*float(data[g][cols])
				sumcorrcoeff += abs(float(data[g][cols]))
		if(sumcorrcoeff > 0):
			movie_rate = movie_rate / sumcorrcoeff
		else: # 0/0 format
			movie_rate = 0
		review.append((movie_rate,movie_name))

review.sort(reverse=True)
number = len(review)
number = min(3,number)
print("The top movie recommendations for this particular user are :")
for x in range(number):
	print(review[x][1])

# Tried this, but didn't work, TypeError: map() takes 1 positional argument but 2 were given 
# movie_rate = sum(map(lambda g: func(float(data[g][i]))*float(data[g][cols]), range(1,rows-1)))