# Generated by Django 2.2 on 2020-11-17 04:30

import datetime
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import multiselectfield.db.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('django_drf_filepond', '0009_temporaryuploadchunked_offset_utime'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='PositionsModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100, verbose_name='Project Title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('contact_details', models.CharField(blank=True, max_length=200, null=True, verbose_name='Contact Details')),
                ('total_positions', models.IntegerField(verbose_name='Total Positions')),
                ('initial_total_positions', models.IntegerField(blank=True, null=True, verbose_name='Initial Total Positions')),
                ('faculty', models.ForeignKey(default=None, on_delete=django.db.models.deletion.DO_NOTHING, related_name='position_user', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='RoundDetailsModel',
            fields=[
                ('roundNo', models.IntegerField(default=1, primary_key=True, serialize=False, verbose_name='Round Number')),
                ('startDate', models.DateField(default=datetime.datetime.now, verbose_name='Round Start Date')),
                ('endDate', models.DateField(default=datetime.datetime(2020, 11, 27, 4, 30, 32, 426919), verbose_name='Round End Date')),
                ('allocated', models.IntegerField(blank=True, null=True, verbose_name='Count of Alloted students')),
                ('unallocated', models.IntegerField(blank=True, null=True, verbose_name='Count of Unalloted students')),
            ],
        ),
        migrations.CreateModel(
            name='StudentDetailModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('qualities', models.CharField(blank=True, max_length=200, null=True, verbose_name='Description')),
                ('alloted_project', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='alloted_student', to='guideAllocationPortal.PositionsModel')),
                ('student', models.ForeignKey(default=None, on_delete=django.db.models.deletion.DO_NOTHING, related_name='student_user', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='StudentResumeModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='django_drf_filepond.StoredUpload')),
                ('student', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='resume', to='guideAllocationPortal.StudentDetailModel')),
            ],
        ),
        migrations.CreateModel(
            name='StudentProjectsModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100, verbose_name='Project Title')),
                ('languages', multiselectfield.db.fields.MultiSelectField(choices=[('Python', 'Python'), ('Java', 'Java'), ('C', 'C'), ('C++', 'C++'), ('HTML', 'HTML'), ('CSS', 'CSS'), ('Javascript', 'Javascript'), ('Scala', 'Scala'), ('Go', 'Go'), ('Ruby', 'Ruby'), ('Matlab', 'Matlab'), ('Angular', 'Angular'), ('Django', 'Django'), ('Other', 'Other')], max_length=79, verbose_name='Programming Languages')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('link', models.URLField(blank=True, null=True, verbose_name='Github Link')),
                ('student', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='projects', to='guideAllocationPortal.StudentDetailModel')),
            ],
        ),
        migrations.CreateModel(
            name='StudentPrioritiesArchive',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('roundNo', models.IntegerField(default=1, verbose_name='Round Number')),
                ('current_priority', models.IntegerField(default=-1, verbose_name='Priority Value')),
                ('date', models.DateField(default=datetime.datetime.now, verbose_name='Application Date')),
                ('project', models.ForeignKey(db_column='project_id', on_delete=django.db.models.deletion.CASCADE, related_name='archived_student_priorities', to='guideAllocationPortal.PositionsModel')),
                ('student', models.ForeignKey(db_column='student_id', on_delete=django.db.models.deletion.CASCADE, related_name='archived_priorities', to='guideAllocationPortal.StudentDetailModel')),
            ],
        ),
        migrations.CreateModel(
            name='StudentPriorities',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('current_priority', models.IntegerField(default=-1, verbose_name='Priority Value')),
                ('date', models.DateField(default=datetime.datetime.now, verbose_name='Application Date')),
                ('project', models.ForeignKey(db_column='project_id', on_delete=django.db.models.deletion.CASCADE, related_name='student_priorities', to='guideAllocationPortal.PositionsModel')),
                ('student', models.ForeignKey(db_column='student_id', on_delete=django.db.models.deletion.CASCADE, related_name='priorities', to='guideAllocationPortal.StudentDetailModel')),
            ],
        ),
        migrations.CreateModel(
            name='StudentEducationModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('exam', models.CharField(choices=[('BE/BTech', 'BE/BTech'), ('10+2', '10+2'), ('SSLC', 'SSLC'), ('MTech', 'MTech'), ('PhD', 'PhD')], default='BE/BTech', max_length=10, verbose_name='Examination')),
                ('board', models.CharField(max_length=100, verbose_name='Examination Board')),
                ('cgpa', models.FloatField(validators=[django.core.validators.MinValueValidator(0.0), django.core.validators.MaxValueValidator(100.0)], verbose_name='CGPA/Percentage')),
                ('year', models.DateField(verbose_name='Year of completion')),
                ('student', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='education', to='guideAllocationPortal.StudentDetailModel')),
            ],
        ),
        migrations.CreateModel(
            name='RequisitesModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('Subject', models.CharField(choices=[('CS601', 'CS601'), ('CS725', 'CS725'), ('CS699', 'CS699'), ('CS626', 'CS626'), ('CS747', 'CS747')], default='CS699', max_length=6, verbose_name='Subject Name')),
                ('cgpa', models.FloatField(validators=[django.core.validators.MinValueValidator(0.0), django.core.validators.MaxValueValidator(10.0)], verbose_name='CGPA')),
                ('position', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='requisites', to='guideAllocationPortal.PositionsModel')),
            ],
        ),
        migrations.CreateModel(
            name='ProjectPrioritiesArchive',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('roundNo', models.IntegerField(default=1, verbose_name='Round Number')),
                ('current_priority', models.IntegerField(default=-1, verbose_name='Priority Value')),
                ('date', models.DateField(default=datetime.datetime.now, verbose_name='Application Date')),
                ('project', models.ForeignKey(db_column='project_id', on_delete=django.db.models.deletion.CASCADE, related_name='archived_priorities', to='guideAllocationPortal.PositionsModel')),
                ('student', models.ForeignKey(db_column='student_id', on_delete=django.db.models.deletion.CASCADE, related_name='archived_project_priorities', to='guideAllocationPortal.StudentDetailModel')),
            ],
        ),
        migrations.CreateModel(
            name='ProjectPriorities',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('current_priority', models.IntegerField(default=-1, verbose_name='Priority Value')),
                ('date', models.DateField(default=datetime.datetime.now, verbose_name='Application Date')),
                ('project', models.ForeignKey(db_column='project_id', on_delete=django.db.models.deletion.CASCADE, related_name='priorities', to='guideAllocationPortal.PositionsModel')),
                ('student', models.ForeignKey(db_column='student_id', on_delete=django.db.models.deletion.CASCADE, related_name='project_priorities', to='guideAllocationPortal.StudentDetailModel')),
            ],
        ),
        migrations.CreateModel(
            name='GeneratedMappingsModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('roundNo', models.IntegerField(default=1, verbose_name='Round Number')),
                ('faculty', models.ForeignKey(db_column='faculty_id', on_delete=django.db.models.deletion.DO_NOTHING, to=settings.AUTH_USER_MODEL)),
                ('project', models.ForeignKey(db_column='project_id', on_delete=django.db.models.deletion.DO_NOTHING, related_name='student_mappings', to='guideAllocationPortal.PositionsModel')),
                ('student', models.ForeignKey(db_column='student_id', on_delete=django.db.models.deletion.DO_NOTHING, related_name='student_allotment', to='guideAllocationPortal.StudentDetailModel')),
            ],
        ),
    ]
