from django.forms.models import inlineformset_factory
from django.forms import ModelForm, TextInput, NumberInput, Select, Textarea, DateInput
from .models import PositionsModel, RequisitesModel, StudentDetailModel, StudentProjectsModel, StudentEducationModel, RoundDetailsModel


# Form to get the project details from faculty
class PositionsModelForm(ModelForm):
	class Meta:
		model = PositionsModel
		exclude = ('faculty','initial_total_positions',)
		widgets = {
			'title': TextInput(attrs={'placeholder':'Project Title'}),
			'total_positions':NumberInput(attrs={'placeholder':'Total Positions'}),
			'contact_details': TextInput(attrs={'placeholder':'How to contact me?'})
		}

# Form to get the requisites list from faculty
class RequisitesModelForm(ModelForm):
	class Meta:
		model = RequisitesModel
		exclude = ()
		widgets = {
			'Subject':Select(attrs={'class':"ui fluid search dropdown"}),
			'cgpa':NumberInput(attrs={'placeholder':'CGPA','step':0.001})
		}

# Formset to attach requisites form to main project form
RequisitesFormset = inlineformset_factory(PositionsModel,RequisitesModel,form=RequisitesModelForm,
											extra=1,can_delete=False)

# Form to get student Details
class StudentDetailModelForm(ModelForm):
	class Meta:
		model = StudentDetailModel
		exclude = ('student',)

# Form to get student project Details
class StudentProjectsModelForm(ModelForm):
	class Meta:
		model = StudentProjectsModel
		exclude = ()
		widgets = {
		'title':TextInput(attrs={'placeholder':'Project Title'}),
		'description': Textarea(attrs={'rows': 3}),
		'link':TextInput(attrs={'placeholder':'Github Link'})
		}

# Form to get student education Details
class StudentEducationModelForm(ModelForm):
	class Meta:
		model = StudentEducationModel
		exclude = ()
		widgets = {
		'year': DateInput(attrs={'placeholder':'yyyy-mm-dd'}),
		'exam': Select(attrs={'class':'ui selection dropdown'})
		}

# Formset to attach projects form to main student detail form
StudentProjectFormset = inlineformset_factory(StudentDetailModel,StudentProjectsModel,form=StudentProjectsModelForm,
											extra=1,can_delete=False)

# Formset to attach education form to main student detail form
StudentEducationFormset = inlineformset_factory(StudentDetailModel,StudentEducationModel,form=StudentEducationModelForm,
											extra=1,can_delete=False)


# Form to get round details from facAd
class RoundDetailsModelForm(ModelForm):
	class Meta:
		model = RoundDetailsModel
		exclude = ()
		widgets = {
			'roundNo': NumberInput(attrs={'type':'hidden'}),
			'startDate': DateInput(attrs={'placeholder':'yyyy-mm-dd'}),
			'endDate': DateInput(attrs={'placeholder':'yyyy-mm-dd'})
		}

