from pylatex import Document, Section, Subsection, Tabular,MiniPage,LargeText,FlushLeft,LineBreak, \
	FlushRight,LongTabu,MultiColumn,MultiRow, LongTabularx, Figure,Center
from pylatex.package import Package
from pylatex.utils import bold, NoEscape

# Function to convert stored data to Latex pdf
def mappedResult(result,guide,studentApplied,fileLocation):
	'''
	Input:
	result: mappings generated for every project
	guide: List of guides and the projects proposed by them
	studentApplied: Count of students partaking in the allocation
	filelocation: path to store the latex file
	'''
	geometric_options = {
		"margin":"0.4in"
	}
	doc = Document(geometry_options=geometric_options)
	center = Center()
	center.append(LargeText(bold("Summary")))
	doc.append(center)

	with doc.create(LongTabu('|c c|',row_height="2.0",col_space="1in")) as table:
		totalAlloted = 0
		num_offers = 0
		for keys, values in result.items():
			alloted = sum([len(i) for i in values.values() ])
			totalAlloted += alloted
			num_offers += guide[keys]['requirement']
		table.add_hline()
		table.add_row(bold("No. of Students applied"),studentApplied)
		table.add_row(bold("No. of Slots Offered"),num_offers)
		table.add_row(bold("No. of Students alloted"),totalAlloted)
		table.add_hline()

	with doc.create(LongTabu("|c c c|",row_height="2.0",col_space="0.35in")) as guideTable:
		header_row = ["Guide Name", "Requirements", "Alloted"]
		guideTable.add_hline()
		guideTable.add_row(header_row,mapper=[bold])
		guideTable.add_hline()
		guideTable.add_hline()
		for keys,values in result.items():
			alloted = sum([len(i) for i in values.values() ])
			guideTableRow = [guide[keys]['name'], guide[keys]['requirement'], bold(alloted)]
			guideTable.add_row(guideTableRow)
			guideTable.add_hline()
	center = Center()
	center.append(LargeText(bold("Student-Guide Mapping Result for MTP")))
	doc.append(center)
	with doc.create(LongTabu("|c|c|c|c|",booktabs=True,row_height="2.0",col_space="0.2in")) as dataTable:
		header_row = ["GuideName","Topic_offered","AllotedStudentId","AllotedStudentName"]
		dataTable.add_hline()
		dataTable.add_row(header_row,mapper=[bold])
		dataTable.add_hline()
		dataTable.add_hline()
		dataTable.end_table_header()
		for keys,value in result.items():
			idSpan = sum([len(i) for i in value.values() ])
			# idRow = MultiRow(idSpan,data=keys)
			nameRow = MultiRow(idSpan,data=guide[keys]['name'])
			j = 0
			for key,val in value.items():
				topicSpan = len(val)
				topicRow = MultiRow(topicSpan,data=key)
				i = 0
				for k,v in val.items():
					if(i==0 and j==0):
						dataTable.add_row(nameRow,topicRow,k,v)
						dataTable.add_hline(3,4)
						i += 1
						j += 1
					elif(i==0 and j>0):
						dataTable.add_row('',topicRow,k,v)
						dataTable.add_hline(3,4)
						i += 1
						j += 1
					else:
						dataTable.add_row('','',k,v)
						dataTable.add_hline(3,4)
						i += 1
						j += 1
				dataTable.add_hline(2,4)
			dataTable.add_hline(1,4)
		
	# doc.append(NoEscape(r'\end{adjustbox}'))
	doc.generate_pdf(fileLocation,clean_tex=False)

if __name__ == '__main__':
	result = {"GuideId1":{
		"TopicId1":{
			"1122":'piyush',
			"2233":'sharma'
		},
		"TopicId2":{
			"234":'darshan',
			"432":'deepak',
			"4567":'prabhu'
		}},
	"GuideId2":{
		"TopicId1":{
			"1122":'sandeep'
		}},
	"GuideId3":{
		"TopicId1":{
			"1123":'Parihar'
		},
		"TopicId2":{
			"234":'Rajeev',
			"432":'Vaidyanathan',
			"4568":"Natarajan"
		},
		"TopicId3":{
			"1":'abc',
			"2":'bcd',
			"3":'cde',
			"4":'def'
		}},
	"GuideId4":{
	
	}
}

	guide = {
		"GuideId1":{
			"name":"Ajit Rajwade",
			"requirement":5
		},
		"GuideId2":{
			"name":"Preethi Jyothi",
			"requirement":2
		},
		"GuideId3":{
			"name":"Vinay Robeiro",
			"requirement":10
		},
		"GuideId4":{
			"name":"Suyash P. Awate",
			"requirement":10
		}
	}

	mappedResult(result,guide,27,"static/allocationResults")
