from django import template
from ..choices import color_choices
import random
from datetime import datetime, timezone

register = template.Library()


# Function to get particular element from a list
@register.filter
def index(indexable, i):
	'''
	Input:
	indexable: Array type date
	i: index

	Output:
	element at index i in indexable
	'''
	return indexable[i]


# Function to get color for priority tables to guide
@register.simple_tag
def get_table_color(index):
	'''
	Input:
	index: Index of the table'

	Output:
	Random color choice
	'''
	index = index % len(color_choices)
	return color_choices[index]

# Function to get random color
@register.simple_tag
def get_random_color(index):
	'''
	Input:
	index: Index 

	Output:
	Random color choice
	'''
	return random.choice(color_choices)