from django.contrib import admin

from .models import *

# class UnivAppInLine(admin.TabularInline):
# 	model=UnivApp
# 	extra=0

# class UnivChoiceInLine(admin.TabularInline):
# 	model=UnivChoice
# 	extra=0

class ChoiceInline(admin.TabularInline):
	model = Application  #https://stackoverflow.com/questions/5947843/django-how-does-manytomanyfield-with-through-appear-in-admin
	extra = 2 

class AllotedChoiceToAppInLine(admin.TabularInline):
	model=Allocationcl
	extra=0

class ApplicantAdmin(admin.ModelAdmin):
	fields = ['name', 'rank','institute']
	inlines = [ChoiceInline, AllotedChoiceToAppInLine]

# class ChoiceAdmin(admin.ModelAdmin):
# 	fields=['choice_name', 'capacity']
# 	inlines=[UnivChoiceInLine]

admin.site.register(Institute)
admin.site.register(Choice)
admin.site.register(Applicant, ApplicantAdmin)
