## File containing allocator function
from allocation.models import *

## Allocator Function
# @brief Function to allocate choices to applicants based on their preferences
# @param univ Name of the institute
# @return list of applicants which also store their newly allocated choices
def allocator(univ):
	insti=Institute.objects.filter(name=univ)[0]
	insti.is_allocated=True #< Sets that the institute has allocated atleast once
	insti.save() #< save changes to institute model instance
	a=Applicant.objects.filter(institute__name=univ).order_by('rank') #< variable \c a \ stores the list of applicants in order of their ranks
	for x in a: #< loop over all applicants
		choices=x.ordered_choices() #< variable \c choices \ stores choices in order of priority of the applicant
		i=0 
		flag=True
		while x.is_float and flag and i<len(choices): #< loop over all preferences till allocated
			if choices[i].capacity>choices[i].seats_filled :
				given_choice=x.alloted_choice.all() #< \c given_choice\ stores already alloted choice
				if given_choice:
					g=given_choice[0]
					g.seats_filled=g.seats_filled-1
					x.alloted_choice.clear()
					x.save()
					g.save()
				clalloc=Allocationcl(choice=choices[i],applicant=x) #< link Choice to Applicant using Application model
				clalloc.save()
				choices[i].seats_filled=choices[i].seats_filled+1
				choices[i].save()
				flag=False
			i=i+1
	return a