from django.http import HttpResponse
from django.contrib.auth import authenticate
from django.contrib.auth.decorators import login_required
from django.contrib.auth.models import User
from allocation.models import * 
#from allocation.forms import AppForm
from django.forms import modelformset_factory, formset_factory, modelform_factory, ModelForm
from django.views import generic
from django.views.generic.edit import *
from django.shortcuts import render, redirect, get_object_or_404
from django.conf import settings
from django.core.files.storage import FileSystemStorage
from django.contrib.auth import authenticate, login
from django import forms
import csv
from django.urls import reverse_lazy
from allocation.forms import *
from alloc import *

# @login_required(login_url='/admin/login')
# def index(request): #for /allocation
#   applicant=Applicant.objects.filter(name=request.user.username)[0]
#   # form = PreferenceForm(
#   #   initial={'name': applicant.name , 'rank': applicant.rank}
#   #   )
#   form = ArticleForm(instance=applicant)
#   return render(request, 'allocation/index.html', {'applicant': applicant, 'form': form})

# def register_page(request):
# 	if request.method == 'POST':
# 		form = InstiForm(request.POST)
# 		if form.is_valid():
# 			user = User.objects.create_user(username=form.cleaned_data['name'],password=form.cleaned_data['password1'],email=form.cleaned_data['email'])
# 			return HttpResponseRedirect('/')
# 	form = InstiForm()
# 	variables = RequestContext(request, {'form': form})
# 	return render_to_response('registration/register.html',variables)

def signup(request):
    if request.method == 'POST':
        form = InstiForm(request.POST)
        if form.is_valid():
            user = form.save()
            user.is_staff=True
            user.save()
            new_insti=Institute(name=user.username)
            new_insti.save()
            return HttpResponseRedirect('/allocation/admin')
    else:
        form = InstiForm()
    return render(request, 'registration/register.html', {'form': form})

def button_action(request):
    # value = request.POST["prikey"]
    # value = int(value.split('/')[-3])
    # name = Institute.objects.get(pk=value).name
    # allocator(name)
    # return HttpResponse("success")
    institute=request.user.username
    allocator(institute)
    return HttpResponse("success")

def home(request):
    documents = Document.objects.all()
    return render(request, 'core/home.html', { 'documents': documents })
    return HttpResponse("On home")

def choice_make(request):
    if request.method == "POST":
        csvfile = request.FILES['myfile']
        file_data = csvfile.read().decode("utf-8")
        lines = file_data.split("\n")
        user_name = request.user.username
        institute = get_object_or_404(Institute, name=user_name)
        for line in lines:
            line =  line.split(',')
            # tmp = Choice.objects.create(choice_name=line[0],capacity=line[1])
            tmp = institute.choices.create(choice_name=line[0],capacity=line[1])
            tmp.save()
        return HttpResponse("successful")
    return HttpResponse("Error")


def applicant_make(request):
    if request.method == "POST":
        csvfile = request.FILES['myfile']
        file_data = csvfile.read().decode("utf-8")
        user_name = request.user.username
        institute = get_object_or_404(Institute, name=user_name)
        lines = file_data.split("\n")
        for line in lines:
            line = line.split(',')
            # tmp = Applicant.objects.create(name = line[0],rank=line[1])
            tmp = institute.applicants.create(name = line[0],rank = line[1])
            tmp.save()
            user = User.objects.create_user(username=line[2],email=line[3],password=line[4])
            user.is_staff = True
            user.save()
        return HttpResponse("successful")
    return HttpResponse("Error")


#AppFormset = modelformset_factory(Application,fields=("choice", "priority" ), extra=5)

# @login_required(login_url='/admin/login')
# def index(request): #for /allocation
# 	applicant=get_object_or_404(Applicant, name=request.user.username)
# 	# form1 = modelform_factory(Applicant, fields=("name", "rank" ))
# 	formset = AppFormset(queryset=Application.objects.filter(applicant=applicant),)
# 	return render(request, 'allocation/index.html', {'applicant': applicant,  'formset': formset,})


# AppFormset = formset_factory(AppForm, extra=5)
# @login_required(login_url='/admin/login')
# def index(request): #for /allocation
#     applicant=get_object_or_404(Applicant,name=request.user.username)
#     # form1 = modelform_factory(Applicant, fields=("name", "rank" ))
#     formset = AppFormset()
#     return render(request, 'allocation/index.html', {'applicant': applicant,  'formset': formset,})


# def submit(request):
#     if request.method == 'POST':
#         formset = AppFormset(request.POST)
#         instances = formset.save()
#         return HttpResponse("successful")

def make_application_form(applicant1):
    class ApplicationForm(forms.ModelForm):
        choice = forms.ModelChoiceField(queryset=Choice.objects.filter(institute=applicant1.institute))
        applicant = forms.ModelChoiceField(widget=forms.HiddenInput(), initial=applicant1, queryset=Applicant.objects.all() )
        class Meta:
            model = Application
            fields = ['applicant','choice', 'priority']
    return ApplicationForm

@login_required(login_url='/admin/login')
def index(request):
    applicant=get_object_or_404(Applicant,name=request.user.username)
    ApplicationForm = make_application_form(applicant)
    ApplicationFormSet = modelformset_factory(Application, form=ApplicationForm, extra=5)

    if request.method == "POST":
        formset = ApplicationFormSet(request.POST, queryset=Application.objects.filter(applicant=applicant))
        if formset.is_valid():
            #Application.objects.filter(applicant=applicant).delete()
            formset.save()
            return render(request, 'allocation/index.html', {'applicant': applicant,  'formset': formset, 'success':True,})
        else:
            form_errors = formset.errors
            return render(request, 'allocation/index.html', {'applicant': applicant,  'formset': formset,'form_errors': form_errors})
    else:
        formset = ApplicationFormSet(queryset=Application.objects.filter(applicant=applicant),)
        return render(request, 'allocation/index.html', {'applicant': applicant,  'formset': formset,})

@login_required(login_url='/admin/login')
def admin1(request):
	institute=get_object_or_404(Institute,name=request.user.username)
	return render(request, 'allocation/admin1.html',{'institute': institute})


class ChoiceListView(generic.ListView):
	model = Choice
	def get_context_data(self, **kwargs):
		institute=get_object_or_404(Institute,name=self.request.user.username)
		context = super(ChoiceListView, self).get_context_data(**kwargs)
		context['institute'] = institute
		return context
	def get_queryset(self):
		institute=get_object_or_404(Institute,name=self.request.user.username)
		return Choice.objects.filter(institute__name=institute.name)

class ApplicantListView(generic.ListView):
	model = Applicant
	def get_context_data(self, **kwargs):
		institute=get_object_or_404(Institute,name=self.request.user.username)
		context = super(ApplicantListView, self).get_context_data(**kwargs)
		context['institute'] = institute
		return context
	def get_queryset(self):
		institute=get_object_or_404(Institute,name=self.request.user.username)
		return Applicant.objects.filter(institute__name=institute.name)

class ChoiceDetailView(generic.DetailView):
	model = Choice
	def get_context_data(self, **kwargs):
		institute=get_object_or_404(Institute,name=self.request.user.username)
		context = super(ChoiceDetailView, self).get_context_data(**kwargs)
		context['institute'] = institute
		return context

class ApplicantDetailView(generic.DetailView):
	model = Applicant
	def get_context_data(self, **kwargs):
		institute=get_object_or_404(Institute,name=self.request.user.username)
		context = super(ApplicantDetailView, self).get_context_data(**kwargs)
		context['institute'] = institute
		return context


class ChoiceCreateView(CreateView):
    model = Choice
    fields = ['choice_name', 'capacity', 'institute']

class ChoiceUpdate(UpdateView):
    model = Choice
    fields = ['choice_name','capacity']
    template_name_suffix = '_update'
    success_url = reverse_lazy('allocation:choice_list')

class ChoiceDelete(DeleteView):
    model = Choice
    success_url = reverse_lazy('allocation:choice_list')

class ApplicantUpdate(UpdateView):
    model = Applicant
    fields = ['name','rank']
    template_name_suffix = '_update'
    success_url = reverse_lazy('allocation:applicant_list')

class ApplicantDelete(DeleteView):
    model = Applicant
    success_url = reverse_lazy('allocation:applicant_list')



