# -*- coding: utf-8 -*-
# Generated by Django 1.11.5 on 2017-10-25 14:07
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Allocationcl',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'verbose_name_plural': 'Allocated Choice',
                'ordering': ['applicant__rank'],
                'verbose_name': 'Allocated Choice',
            },
        ),
        migrations.CreateModel(
            name='Applicant',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('rank', models.IntegerField(validators=[django.core.validators.MinValueValidator(1)])),
            ],
        ),
        migrations.CreateModel(
            name='Application',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('priority', models.IntegerField(validators=[django.core.validators.MinValueValidator(1)])),
                ('applicant', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='allocation.Applicant')),
            ],
            options={
                'ordering': ['priority'],
            },
        ),
        migrations.CreateModel(
            name='Choice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('choice_name', models.CharField(max_length=200)),
                ('capacity', models.IntegerField()),
                ('seats_left', models.IntegerField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='Institute',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
            ],
            options={
                'verbose_name_plural': 'Institutes',
                'verbose_name': 'Institute',
            },
        ),
        migrations.AddField(
            model_name='choice',
            name='institute',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='choices', to='allocation.Institute'),
        ),
        migrations.AddField(
            model_name='application',
            name='choice',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='allocation.Choice'),
        ),
        migrations.AddField(
            model_name='applicant',
            name='alloted_choice',
            field=models.ManyToManyField(related_name='alloted_applicant', through='allocation.Allocationcl', to='allocation.Choice'),
        ),
        migrations.AddField(
            model_name='applicant',
            name='choices',
            field=models.ManyToManyField(related_name='applicants', through='allocation.Application', to='allocation.Choice'),
        ),
        migrations.AddField(
            model_name='applicant',
            name='institute',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='applicants', to='allocation.Institute'),
        ),
        migrations.AddField(
            model_name='allocationcl',
            name='applicant',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='allocation.Applicant'),
        ),
        migrations.AddField(
            model_name='allocationcl',
            name='choice',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='allocation.Choice'),
        ),
    ]
