from django.db import models

class Choice(models.Model):
	choice_name = models.CharField(max_length=200)
	capacity = models.IntegerField()
	def __str__(self):
		return self.choice_name

class Applicant(models.Model):
	choices = models.ManyToManyField(Choice, through='Application')
	name = models.CharField(max_length=200)
	rank = models.IntegerField()
	def __str__(self):
		return self.name
	def ordered_choices(self):   #https://stackoverflow.com/questions/934779/django-order-a-model-by-a-many-to-many-field
		"Return a properly ordered set of choices"
		return self.choices.all().order_by('application__priority')

class Application(models.Model):
	choice = models.ForeignKey(Choice, on_delete=models.CASCADE)
	applicant = models.ForeignKey(Applicant, on_delete=models.CASCADE)
	priority = models.IntegerField()
	class Meta:
		# if you have an inline configured in the admin, this will 
		# make the roles order properly 
		ordering = ['priority'] 