from django.contrib import admin

from .models import Applicant,Choice,Application

admin.site.register(Choice)

class ChoiceInline(admin.TabularInline):
	model = Application  #https://stackoverflow.com/questions/5947843/django-how-does-manytomanyfield-with-through-appear-in-admin
	extra = 2 

class ApplicantAdmin(admin.ModelAdmin):
	fields = ['name', 'rank']
	inlines = [ChoiceInline]

admin.site.register(Applicant, ApplicantAdmin)
