from django.http import HttpResponse
from django.contrib.auth import authenticate
from django.contrib.auth.decorators import login_required
from django.contrib.auth.models import User
from allocation.models import * 
from django.forms import modelformset_factory, formset_factory, modelform_factory, ModelForm
from django.views import generic
from django.views.generic.edit import *
from django.shortcuts import render, redirect, get_object_or_404
from django.conf import settings
from django.core.files.storage import FileSystemStorage
from django.contrib.auth import authenticate, login
from django import forms
import csv
from django.urls import reverse_lazy
from django.utils import lru_cache
from django.utils._os import upath
from django.utils.encoding import force_text
from django.utils.functional import lazy
from django.utils.html import format_html
from django.utils.module_loading import import_string
from django.utils.six import string_types, text_type
from django.utils.translation import ugettext as _, ungettext
from django.contrib.auth import *
from allocation.forms import *
from alloc import *
from difflib import SequenceMatcher

from django.core.mail import send_mail
from django.core.mail import EmailMessage

from django.core.exceptions import (
    FieldDoesNotExist, ImproperlyConfigured, ValidationError,
)


# @login_required(login_url='/admin/login')
# def index(request): #for /allocation
#   applicant=Applicant.objects.filter(name=request.user.username)[0]
#   # form = PreferenceForm(
#   #   initial={'name': applicant.name , 'rank': applicant.rank}
#   #   )
#   form = ArticleForm(instance=applicant)
#   return render(request, 'allocation/index.html', {'applicant': applicant, 'form': form})
		
# def send_mail(request):
# 	# send_mail('Subject here', 'Here is the message.', settings.EMAIL_HOST_USER,['to@example.com'], fail_silently=False)
# 	email = EmailMessage(
#     'subject_message',
#     'content_message',
#     'sender smtp gmail' +'<codemafia123@gmail.com>',
#     ['codemafia123@gmail.com'],)
# 	email.send()
# 	return HttpResponse("success")
def signup(request):
    if request.method == 'POST':
        form = InstiForm(request.POST)
        if form.is_valid():
            user = form.save()
            user.is_staff=True
            user.save()
            new_insti=Institute(name=user.username)
            new_insti.save()
            return HttpResponseRedirect('/allocation/admin')
    else:
        form = InstiForm()
    return render(request, 'registration/register.html', {'form': form})

def button_action(request):
    institute=request.user.username
    allocator(institute)
    return HttpResponseRedirect("/allocation/admin")

def choice_make(request):
    if request.method == "POST":
        csvfile = request.FILES['myfile']
        file_data = csvfile.read().decode("utf-8")
        lines = file_data.split("\n")
        user_name = request.user.username
        institute = get_object_or_404(Institute, name=user_name)
        repeated = []
        for line in lines:
            line = line.split(',')
            number = len(line)
            if number != 2:
            	return HttpResponse("Incorrect data format in uploaded .csv file.")
            existing_no = institute.choices.filter(choice_name=line[0])
            if existing_no.count() != 0:
            	repeated.append(line[0])
            	# return HttpResponse(".csv file choice: '"+ line[0] + "' already exists")
        if len(repeated) != 0:
        	str = ""
        	for rep in repeated:
        		str += rep + "," 
        	return HttpResponse(".csv file has choices: '"+ str + "' that already exists")
        for line in lines:
            line =  line.split(',')
            tmp = institute.choices.create(choice_name=line[0],capacity=line[1])
            tmp.save()
        return HttpResponseRedirect("/allocation/admin/choices")
    return HttpResponse("Error")


@lru_cache.lru_cache(maxsize=None)
def get_default_password_validators():
    return get_password_validators(settings.AUTH_PASSWORD_VALIDATORS)

def get_password_validators(validator_config):
    validators = []
    for validator in validator_config:
        try:
            klass = import_string(validator['NAME'])
        except ImportError:
            msg = "The module in NAME could not be imported: %s. Check your AUTH_PASSWORD_VALIDATORS setting."
            raise ImproperlyConfigured(msg % validator['NAME'])
        validators.append(klass(**validator.get('OPTIONS', {})))

    return validators


def applicant_make(request):
    if request.method == "POST":
        csvfile = request.FILES['myfile']
        file_data = csvfile.read().decode("utf-8")
        user_name = request.user.username
        institute = get_object_or_404(Institute, name=user_name)
        lines = file_data.split("\n")
        rep_users = []
        rep_applicant = []
        errors = []
        for line in lines:
        	line = line.split(',')
        	number = len(line)
        	if number != 4:
        		return HttpResponse("Incorrect data format in uploaded .csv file")
        	existing_no_app = institute.applicants.filter(name = line[0])
        	existing_no_user = User.objects.filter(username=line[0])
        	if existing_no_app.count() != 0:
        		rep_applicant.append(line[0])
        		# return HttpResponse(".csv files has applicants that already exists")
        	if existing_no_user.count() != 0:
        		rep_users.append(line[0])
        		# return HttpResponse("user with same username already exists")

       		password_validators = get_default_password_validators()
       		for validator in password_validators:
       			try:
        			validator.validate(line[3])
        		except ValidationError as error:
        			errors.append(line[0])
        if len(rep_applicant) != 0:
        	str = ""
        	for appl in rep_applicant:
        		str += appl + "," 
        	return HttpResponse(".csv file has applicants: '"+ str + "' that already exists") 

        if len(rep_users)  != 0:
        	str = ""
        	for appl in rep_users:
        		str += appl + "," 
        	return HttpResponse(".csv file has user with usernames : '"+ str + "' that already exists") 

        if len(errors)  != 0:
        	str = ""
        	for appl in errors:
        		str +=  appl + "," 
        	return HttpResponse(".csv file usernames : '"+ str + "' have incorrect format of password") 

        	# return HttpResponse("Invalid password given in .csv file")	
        	# if validate_password(line[4]) != None:
        	# 	return HttpResponse("Invalid password given in .csv file")
        for line in lines:
            line = line.split(',')
            tmp = institute.applicants.create(name = line[0],rank = line[1])
            tmp.save()
            user = User.objects.create_user(username=line[0],email=line[2],password=line[3])
            user.is_staff = True
            user.save()
        return HttpResponseRedirect("/allocation/admin/applicants")
    return HttpResponse("Error")

def make_application_form(applicant1):
    class ApplicationForm(forms.ModelForm):
        choice = forms.ModelChoiceField(queryset=Choice.objects.filter(institute=applicant1.institute))
        applicant = forms.ModelChoiceField(widget=forms.HiddenInput(), initial=applicant1, queryset=Applicant.objects.all() )
        class Meta:
            model = Application
            fields = ['applicant','choice', 'priority']
    return ApplicationForm

@login_required(login_url='/admin/login')
def index(request):
    applicant=get_object_or_404(Applicant,name=request.user.username)
    ApplicationForm = make_application_form(applicant)
    ApplicationFormSet = modelformset_factory(Application, form=ApplicationForm, extra=5)
    if request.method == "POST":
        formset = ApplicationFormSet(request.POST, queryset=Application.objects.filter(applicant=applicant))
        if formset.is_valid():
            formset.save()
            return render(request, 'allocation/index.html', {'applicant': applicant,  'formset': formset, 'success':True,})
        else:
            form_errors = formset.errors
            return render(request, 'allocation/index.html', {'applicant': applicant,  'formset': formset,'form_errors': form_errors})
    else:
        formset = ApplicationFormSet(queryset=Application.objects.filter(applicant=applicant),)
        return render(request, 'allocation/index.html', {'applicant': applicant,  'formset': formset,})

@login_required(login_url='/admin/login')
def admin1(request):
	institute=get_object_or_404(Institute,name=request.user.username)
	return render(request, 'allocation/admin1.html',{'institute': institute})

class ChoiceListView(generic.ListView):
	model = Choice
	def get_context_data(self, **kwargs):
		institute=get_object_or_404(Institute,name=self.request.user.username)
		context = super(ChoiceListView, self).get_context_data(**kwargs)
		context['institute'] = institute
		return context
	def get_queryset(self):
		institute=get_object_or_404(Institute,name=self.request.user.username)
		return Choice.objects.filter(institute__name=institute.name)

class ApplicantListView(generic.ListView):
	model = Applicant
	def get_context_data(self, **kwargs):
		institute=get_object_or_404(Institute,name=self.request.user.username)
		context = super(ApplicantListView, self).get_context_data(**kwargs)
		context['institute'] = institute
		return context
	def get_queryset(self):
		institute=get_object_or_404(Institute,name=self.request.user.username)
		return Applicant.objects.filter(institute__name=institute.name)

class ChoiceDetailView(generic.DetailView):
	model = Choice
	def get_context_data(self, **kwargs):
		institute=get_object_or_404(Institute,name=self.request.user.username)
		context = super(ChoiceDetailView, self).get_context_data(**kwargs)
		context['institute'] = institute
		return context

class ApplicantDetailView(generic.DetailView):
	model = Applicant
	def get_context_data(self, **kwargs):
		institute=get_object_or_404(Institute,name=self.request.user.username)
		context = super(ApplicantDetailView, self).get_context_data(**kwargs)
		context['institute'] = institute
		return context


class ChoiceCreateView(CreateView):
    model = Choice
    fields = ['choice_name', 'capacity', 'institute']

class ChoiceUpdate(UpdateView):
    model = Choice
    fields = ['choice_name','capacity']
    template_name_suffix = '_update'
    success_url = reverse_lazy('allocation:choice_list')

class ChoiceDelete(DeleteView):
    model = Choice
    success_url = reverse_lazy('allocation:choice_list')

class ApplicantUpdate(UpdateView):
    model = Applicant
    fields = ['name','rank']
    template_name_suffix = '_update'
    success_url = reverse_lazy('allocation:applicant_list')

class ApplicantDelete(DeleteView):
    model = Applicant
    success_url = reverse_lazy('allocation:applicant_list')

def freeze(request):
    if request.method == "POST":
        applicant=Applicant.objects.get(pk=request.POST["applicant"])
        applicant.is_float=False
        applicant.save()
        return HttpResponseRedirect('/allocation')
    else:
        return HttpResponseRedirect('/allocation')

def drop(request):
    if request.method == "POST":
        applicant=Applicant.objects.get(pk=request.POST["applicant"])
        applicant.is_float=False
        given_choice=applicant.alloted_choice.all()
        if given_choice:
            g=given_choice[0]
            g.seats_filled=g.seats_filled-1
            applicant.alloted_choice.clear()
            g.save()
        applicant.save()
        return HttpResponseRedirect('/allocation')
    else:
        return HttpResponseRedirect('/allocation')

def float(request):
    return HttpResponseRedirect('/allocation')