from django.contrib import admin

from .models import *

# class UnivAppInLine(admin.TabularInline):
# 	model=UnivApp
# 	extra=0

# class UnivChoiceInLine(admin.TabularInline):
# 	model=UnivChoice
# 	extra=0

class ChoiceInline(admin.TabularInline):
	model = Application  #https://stackoverflow.com/questions/5947843/django-how-does-manytomanyfield-with-through-appear-in-admin
	extra = 2 

class AllotedChoiceToAppInLine(admin.TabularInline):
	model=Allocationcl
	extra=0

class ApplicantAdmin(admin.ModelAdmin):
	fields = ['name', 'rank','institute', 'is_float']
	list_display=['name','institute']
	inlines = [ChoiceInline, AllotedChoiceToAppInLine]

class InstituteAdmin(admin.ModelAdmin):
	fields=['name', 'is_allocated']
	list_display=['name','is_allocated']

class ChoiceAdmin(admin.ModelAdmin):
	fields=['choice_name', 'capacity','institute', 'seats_filled']
	list_display=['choice_name','institute', 'capacity', 'seats_filled' ]
	# inlines=[UnivChoiceInLine]

admin.site.register(Institute, InstituteAdmin)
admin.site.register(Choice, ChoiceAdmin)
admin.site.register(Applicant, ApplicantAdmin)