import numpy as np
import matplotlib.pyplot as plt
import os

cwd = os.getcwd()
filetoread = open(cwd + "/csv_file", 'r')
lines = filetoread.readlines()
xcords = []
ycords = []
zcords = []
for line in lines:
    coords = line[:-1].split(",")
    xcords.append(float(coords[0]))
    ycords.append(float(coords[1]))
    zcords.append(float(coords[2]))

fig = plt.figure(figsize=(12, 12))
ax = plt.axes(projection='3d')
ax.grid(False)
ax.xaxis.set_pane_color((1.0, 1.0, 1.0, 0.0))
ax.yaxis.set_pane_color((1.0, 1.0, 1.0, 0.0))
ax.zaxis.set_pane_color((1.0, 1.0, 1.0, 0.0))

xarr = np.array(xcords)
yarr = np.array(ycords)
zarr = np.array(zcords)

scatter = ax.scatter3D(xarr, yarr, zarr, c=(xarr + yarr + zarr), cmap=plt.get_cmap("coolwarm"))

ax.set_xlabel('X axis', fontweight='bold')
ax.set_ylabel('Y axis', fontweight='bold')
ax.set_zlabel('Z axis', fontweight='bold')

fig.colorbar(scatter, ax=ax, shrink=0.5)

plt.savefig("q3plot.jpg", bbox_inches='tight')
