/*
 * mm-naive.c - The fastest, least memory-efficient malloc package.
 *
 * In this naive approach, a block is allocated by simply incrementing
 * the brk pointer.  A block is pure payload. There are no headers or
 * footers.  Blocks are never coalesced or reused. Realloc is
 * implemented directly using mm_malloc and mm_free.
 *
 * NOTE TO STUDENTS: Replace this header comment with your own header
 * comment that gives a high level description of your solution.
 */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>
#include <string.h>
#include<stddef.h>
#include<stdint.h>
#include "mm.h"
#include "memlib.h"

/*********************************************************
 * NOTE TO STUDENTS: Before you do anything else, please
 * provide your team information in the following struct.
 ********************************************************/
team_t team = {
    /* Team name */
    "team name",
    /* First member's full name */
    "member 1",
    /* First member's email address */
    "member_1@cse.iitb.ac.in",
    /* Second member's full name (leave blank if none) */
    "member 2",
    /* Second member's email address (leave blank if none) */
    "member_2@cse.iitb.ac.in"
};

typedef struct tree_node_
{
struct tree_node_ *left_node;

struct tree_node_ *right_node;

struct tree_node_ *parent_node;
}tree_node_t;

typedef enum
{
    MM_FALSE,
    MM_TRUE
} vm_bool_t;

typedef struct block_meta_data_
{
    vm_bool_t is_free;
    uint32_t block_size;
    struct block_meta_data_ *prev_block;
    struct block_meta_data_ *next_block;
    tree_node_t tree_node;
} block_meta_data_t;

typedef struct printer{
	int rollno;
	char *name;
	struct printer *next;
}printer;

typedef struct block_end_meta_data_
{
uint32_t block_size;

} block_end_meta_data_t;

 int c=0;

 int m=0;

#define NEXT_META_BLOCK_BY_SIZE(block_meta_data_ptr) \
        (block_meta_data_t *)((char *)(block_meta_data_ptr)+ALIGN(sizeof(block_meta_data_t))  \
        + block_meta_data_ptr->block_size \
        +ALIGN(sizeof(block_end_meta_data_t)))

#define mm_bind_blocks_for_allocation(allocated_meta_block,free_meta_block) \
    free_meta_block->prev_block=allocated_meta_block; \
    free_meta_block->next_block=allocated_meta_block->next_block; \
    allocated_meta_block->next_block=free_meta_block;   \
    if(free_meta_block->next_block) \
    free_meta_block->next_block->prev_block=free_meta_block

#define meta_data_block_addr(free_node_addr) \
    (block_meta_data_t *) ((char *)(free_node_addr)-offsetof(block_meta_data_t,tree_node))

#define end_meta_data_addr(meta_data_addr) \
    (block_end_meta_data_t *)((char *)(meta_data_addr)+ALIGN(sizeof(block_meta_data_t)) \
    +meta_data_addr->block_size)

#define start_meta_data_addr(end_meta_data_addr) \
    (block_meta_data_t *)((char *)(end_meta_data_addr) \
    -end_meta_data_addr->block_size \
    -ALIGN(sizeof(block_meta_data_t)))

#define META_DATA_OVERHEAD  \
    (uint32_t)(ALIGN(sizeof(block_end_meta_data_t))+ALIGN(sizeof(block_meta_data_t)))

#define TOTAL_COMBINE_SIZE_OF_BLOCKS(base)  \
    base->block_size \
    +ALIGN(sizeof(block_end_meta_data_t)) \
    +ALIGN(sizeof(block_meta_data_t))


#define TOTAL_COMBINED_SIZE_OF_BLOCKS(base) \
    base->next_block->block_size \
    +base->prev_block->block_size \
    +2*ALIGN(sizeof(block_end_meta_data_t)) \
    +2*ALIGN(sizeof(block_meta_data_t))


/* single word (4) or double word (8) alignment */
#define ALIGNMENT 8

/* rounds up to the nearest multiple of ALIGNMENT */
#define ALIGN(size) (((size) + (ALIGNMENT-1)) & ~0x7)


#define SIZE_T_SIZE (ALIGN(sizeof(size_t)))

/*
 * mm_init - initialize the malloc package.
 */

 tree_node_t init_free_node(void)
{
    tree_node_t treenode;
    treenode.left_node=NULL;
    treenode.right_node=NULL;
    treenode.parent_node=NULL;
    return treenode;
}

void remove_block_from_tree(tree_node_t **root,tree_node_t *del_node);

void *init_mem_sbrk_break = NULL;

tree_node_t **root=NULL;





void LL_rotate(tree_node_t *parent,tree_node_t *node)
{

    // printf("Came to LL\n");
    tree_node_t *p_parent=parent->parent_node;

    tree_node_t *temp=parent->left_node;

    tree_node_t *temp_right=temp->right_node;

    if(p_parent==NULL)
    {
        *root=temp;
        temp->parent_node=NULL;
    }

    else
    {

        block_meta_data_t *p_parent_meta_data=meta_data_block_addr(p_parent);

        block_meta_data_t *temp_meta_data=meta_data_block_addr(temp);

        temp->parent_node=p_parent;

        if(p_parent->left_node==parent)
        {
            p_parent->left_node=temp;
        }
        else if(p_parent->right_node==parent)
        {
            p_parent->right_node=temp;
        }

    }

    temp->right_node=parent;

    parent->parent_node=temp;

    parent->left_node=temp_right;

    if(temp_right!=NULL)
    {
        temp_right->parent_node=parent;
    }
}


void LR_Rotate(tree_node_t *parent,tree_node_t *node)
{
    // printf("Came to LR\n");
    tree_node_t *p_parent=parent->parent_node;

    tree_node_t *temp=parent->left_node;

    block_meta_data_t *meta_data=meta_data_block_addr(temp);

    tree_node_t *node_left=node->left_node;

    tree_node_t *node_right=node->right_node;


    if(p_parent==NULL)
    {
        *root=node;
        node->parent_node=NULL;
    }

    else
    {

        block_meta_data_t *p_parent_meta_data=meta_data_block_addr(p_parent);
        block_meta_data_t *node_meta_data=meta_data_block_addr(node);
        node->parent_node=p_parent;
        if(p_parent->left_node==parent)
        {
            p_parent->left_node=node;
        }
        else if(p_parent->right_node==parent)
        {
            p_parent->right_node=node;
        }
    }

    node->right_node=parent;
    parent->parent_node=node;
    node->left_node=temp;
    temp->parent_node=node;
    parent->left_node=node_right;
    if(node_right!=NULL)
    {
        node_right->parent_node=parent;
    }
    temp->right_node=node_left;

    if(node_left!=NULL)
    {
        node_left->parent_node=temp;
    }

}


void RR_Rotate(tree_node_t *parent,tree_node_t *node)
{
    //  printf("Came to RR1\n");
    tree_node_t *p_parent=parent->parent_node;
    tree_node_t *temp=parent->right_node;
    tree_node_t *temp_left=temp->left_node;



    if(p_parent==NULL)
    {
        *root=temp;
        temp->parent_node=NULL;
    }
    else
    {
        temp->parent_node=p_parent;

        block_meta_data_t *p_parent_meta_data=meta_data_block_addr(p_parent);

        block_meta_data_t *temp_meta_data=meta_data_block_addr(temp);

        if(p_parent->left_node==parent)
        {
            p_parent->left_node=temp;
        }
        else if(p_parent->right_node==parent)
        {
            p_parent->right_node=temp;
        }
    }


    temp->left_node=parent;

    parent->parent_node=temp;

    parent->right_node=temp_left;

    if(temp_left!=NULL)
    {
        temp_left->parent_node=parent;
    }

}


void RL_Rotate(tree_node_t *parent,tree_node_t *node)
{
    // printf("Came to RL\n");
    tree_node_t *p_parent=parent->parent_node;
    tree_node_t *temp=parent->right_node;
    //tree_node_t *temp_right=temp->right_node;
    tree_node_t *node_left=node->left_node;
    tree_node_t *node_right=node->right_node;

    if(p_parent==NULL)
    {
        *root=node;
        node->parent_node=NULL;
    }

    else
    {
    node->parent_node=p_parent;
    block_meta_data_t *p_parent_meta_data=meta_data_block_addr(p_parent);

    block_meta_data_t *node_meta_data=meta_data_block_addr(node);

    if(p_parent->left_node==parent)
    {
        p_parent->left_node=node;
    }
    else if(p_parent->right_node==parent)
    {
        p_parent->right_node=node;
    }

    }

    node->left_node=parent;
    parent->parent_node=node;
    node->right_node=temp;
    temp->parent_node=node;
    parent->right_node=node_right;
    if(node_right!=NULL)
    {
        node_right->parent_node=parent;
    }
    temp->left_node=node_left;
    if(node_left!=NULL)
    {
        node_left->parent_node=temp;
    }
}

int getHeight(tree_node_t *node)
{
    if(node==NULL)
    {
        return 0;
    }
    int left_height=getHeight(node->left_node);



    int right_height=getHeight(node->right_node);


    return 1+(left_height>=right_height?left_height:right_height);
}

int get_balance(tree_node_t *node)
{
    if(node!=NULL)
    {

        int left_height=getHeight(node->left_node);

        if(c==54)
        {
            // printf("Left height=%d\n",left_height);
        }

        int right_height=getHeight(node->right_node);

         if(c==54)
        {
            // printf("Right height=%d\n",right_height);
        }


        return (left_height-right_height);
    }

    return 0;

}


void printLevelOrder(tree_node_t* head)
{
     if(c==122)
    {
        // printf("Came to level order\n");
    }

    int h = getHeight(head);

     if(c==122)
    {
        // printf("Came to level order\n");
    }

    int i;
    for (i=1; i<=h; i++)
    {
        // printGivenLevel(head, i);
        // printf("\n");
    }
}

void remove_cycles(tree_node_t *head)
{
      int h = getHeight(head);
    int i;
    for (i=1; i<=h; i++)
    {
        remove_cycles_by_level(head,i);
    }
}


void remove_cycles_1(tree_node_t *head)
{

    if(head==NULL)
    {
        return;
    }

    if(head->left_node==head)
    {
        head->left_node=NULL;
    }

    if(head->right_node==head)
    {
        head->right_node=NULL;
    }

    remove_cycles_1(head->left_node);

    remove_cycles_1(head->right_node);

}

int find_node_in_tree(tree_node_t *head,tree_node_t *node)
{

    if(head==node)
    {
      return 1;
    }
    else
    {
        int b1=0;
        int b2=0;
        if(head->left_node!=NULL)
        {
            b1=find_node_in_tree(head->left_node,node);
        }

        if(head->right_node!=NULL)
        {
            b2=find_node_in_tree(head->right_node,node);
        }

        return (b1||b2);
    }

}

void remove_cycles_by_level(tree_node_t* head,int level)
{

if (head == NULL)
    {
        return;
    }

    if(level==1)
    {
        //block_meta_data_t *meta_data=meta_data_block_addr(head);
        //block_meta_data_t *parent_meta_data=meta_data_block_addr(parent);

        if(head->left_node==head)
        {
            head->left_node=NULL;
        }

        if(head->right_node==head)
        {
            head->right_node=NULL;
        }
    }

    else if(level>1)
    {
     remove_cycles_by_level(head->left_node,level-1);

     remove_cycles_by_level(head->right_node,level-1);

    }


}

void set_mappings(tree_node_t *head)
{
     int h = getHeight(head);
    int i;
    for (i=1; i<=h; i++)
    {
        set_parent_child_mappings(head, head->parent_node,i);
    }

}

void set_parent_child_mappings(tree_node_t* head,tree_node_t *parent,int level)
{

    if (head == NULL)
    {
        return;
    }

    if(level==1)
    {
        block_meta_data_t *meta_data=meta_data_block_addr(head);
        block_meta_data_t *parent_meta_data=meta_data_block_addr(parent);
        head->parent_node=parent;
    }

    else if(level>1)
    {
     set_parent_child_mappings(head->left_node,head,level-1);

     set_parent_child_mappings(head->right_node,head,level-1);

    }
}

void printGivenLevel(tree_node_t* head, int level)
{
    if (head == NULL)
    {
        return;

    }
    if (level == 1)
    {
        block_meta_data_t *meta_data=meta_data_block_addr(head);
        // printf("%d ", meta_data->block_size);
        }
    else if (level > 1)
    {
        // printGivenLevel(head->left_node, level-1);
        // printGivenLevel(head->right_node, level-1);
    }
}

void inorderTraversal(tree_node_t *node)
{
    if(node!=NULL)
    {
        inorderTraversal(node->left_node);
        block_meta_data_t *meta_data_block=meta_data_block_addr(node);
        // printf("Block size=%d\n",(int)meta_data_block->block_size);
        inorderTraversal(node->right_node);

    }

}




void insert_node_in_freelist(tree_node_t **root,block_meta_data_t *new_metadata_block)
{

    // printf("Inserting block of size %d into free list\n",new_metadata_block->block_size);
    tree_node_t *tree_root=*root;

    if(tree_root==NULL)
    {
        *root=&(new_metadata_block->tree_node);
    }

    else
    {
        tree_node_t *temp=tree_root;

        while(temp)
        {
            block_meta_data_t *meta_data=meta_data_block_addr(temp);
            if(new_metadata_block->block_size<=meta_data->block_size)
            {

                if(temp->left_node==NULL)
                {

                    new_metadata_block->tree_node.parent_node=temp;
                    temp->left_node=&(new_metadata_block->tree_node);
                    temp=temp->left_node;

                    break;
                }
                else
                {
                    temp=temp->left_node;
                }
            }

            else if(new_metadata_block->block_size>meta_data->block_size)
            {

                if(temp->right_node==NULL)
                {
                    new_metadata_block->tree_node.parent_node=temp;
                    temp->right_node=&(new_metadata_block->tree_node);
                    temp=temp->right_node;
                    break;
                }
                else
                {
                    //printf("It's comming here chaitanya\n");
                    temp=temp->right_node;
                }
            }
        }

        tree_node_t *parent=temp->parent_node;





        while(parent)
        {
            int b=get_balance(parent);

              if(c==54)
            {
            // printf("Balance=%d\n",b);
            }

            if(b>=2||b<=-2)
            {
                if(b<-1)
            {
                if(parent->right_node->right_node!=NULL)
                {

                    if(parent->right_node->left_node!=NULL)
                    {
                    if(getHeight(parent->right_node->left_node)>getHeight(parent->right_node->right_node))
                    {
                    // printf("Before rotating\n");
                    // printLevelOrder(*root);
                    RL_Rotate(parent,parent->right_node->left_node);
                    // printf("After rotating\n");
                    // printLevelOrder(*root);

                    }

                    else
                    {
                    //  printf("Before rotating\n");
                    printLevelOrder(*root);
                    RR_Rotate(parent,parent->right_node->right_node);
                    // printf("After rotating\n");
                    printLevelOrder(*root);
                    }
                    }

                    else
                    {
                    // printf("Before rotating\n");
                    printLevelOrder(*root);
                    RR_Rotate(parent,parent->right_node->right_node);
                    // printf("After rotating\n");
                    printLevelOrder(*root);

                    }
                }
                else
                {
                    // printf("Before rotating\n");
                    printLevelOrder(*root);
                    RL_Rotate(parent,parent->right_node->left_node);
                    // printf("After rotating\n");
                    printLevelOrder(*root);
                }
            }

            else if(b>1)
            {
                if(parent->left_node->left_node!=NULL)
                {

                    if(parent->left_node->right_node!=NULL)
                    {

                        if(getHeight(parent->left_node->right_node)>getHeight(parent->left_node->left_node))
                        {
                            //  printf("Before rotating\n");
                            printLevelOrder(*root);
                            LR_Rotate(parent,parent->left_node->right_node);
                            // printf("After rotating\n");
                            printLevelOrder(*root);

                        }

                        else
                        {
                            //  printf("Before rotating\n");
                            printLevelOrder(*root);
                            LL_rotate(parent,parent->left_node->left_node);
                            // printf("After rotating\n");
                            printLevelOrder(*root);
                        }

                    }

                    else
                    {

                    // printf("Before rotating\n");
                    printLevelOrder(*root);
                    LL_rotate(parent,parent->left_node->left_node);
                    // printf("After rotating\n");
                    printLevelOrder(*root);
                    }

                }
                else
                {
                    // printf("Before rotating\n");
                    printLevelOrder(*root);
                    LR_Rotate(parent,parent->left_node->right_node);
                    // printf("After rotating\n");
                    printLevelOrder(*root);

                }
            }
            }

            parent=parent->parent_node;
        }
    }
}


block_meta_data_t *get_node_from_tree(tree_node_t **root,uint32_t reqsize)
{
   tree_node_t *temp=*root;

   while(temp->right_node!=NULL)
   {
        temp=temp->right_node;
   }

   block_meta_data_t *meta_data=NULL;

   meta_data=meta_data_block_addr(temp);

   return meta_data;
}

tree_node_t *get_min_node(tree_node_t *root_node)
{

    tree_node_t *temp=root_node;

    while(temp->left_node!=NULL)
    {
        temp=temp->left_node;
    }

    return temp;

}


void remove_block_from_tree(tree_node_t **root,tree_node_t *del_node)
{

    tree_node_t *parent_node=del_node->parent_node;

     block_meta_data_t *parent_meta_data=meta_data_block_addr(parent_node);

    block_meta_data_t *del_meta_data=meta_data_block_addr(del_node);


    if(del_node->left_node==NULL||del_node->right_node==NULL)
    {

        tree_node_t *temp=del_node->left_node!=NULL?del_node->left_node:del_node->right_node;

        //Deleting a leaf node
        if(temp==NULL)
        {

            if(parent_node==NULL)
            {
                printf("Parent node is null\n");
                *root=NULL;
                return;
            }
            else if(parent_node->right_node==del_node)
            {
            parent_node->right_node=NULL;
            }
            else if(parent_node->left_node==del_node)
            {
            parent_node->left_node=NULL;
            }

        }

        //Deleting node having 1 child
        else
        {


            if(del_node->left_node!=NULL)
            {
                del_node->left_node->parent_node=parent_node;
                if(parent_node==NULL)
                {
                    *root=del_node->left_node;
                    del_node->left_node=NULL;
                    del_node->right_node=NULL;
                    del_node->parent_node=NULL;
                    return;
                }
                else if(parent_node->right_node==del_node)
                {
                    parent_node->right_node=del_node->left_node;
                }

                else if(parent_node->left_node==del_node)
                {

                    parent_node->left_node=del_node->left_node;
                }
            }

            else
            {
                del_node->right_node->parent_node=parent_node;
                if(parent_node==NULL)
                {
                    *root=del_node->right_node;
                    del_node->left_node=NULL;
                    del_node->right_node=NULL;
                    del_node->parent_node=NULL;
                    return;
                }
                else if(parent_node->right_node==del_node)
                {
                    parent_node->right_node=del_node->right_node;
                }

                else if(parent_node->left_node==del_node)
                {
                    parent_node->left_node=del_node->right_node;
                }
            }
        }
            //Balancing parent node
            while(parent_node)
            {
            int b=get_balance(parent_node);

            if(b<-1)
            {
                if(parent_node->right_node->right_node!=NULL)
                {
                    if(parent_node->right_node->left_node!=NULL)
                    {
                    if(getHeight(parent_node->right_node->left_node)>getHeight(parent_node->right_node->right_node))
                    {
                    // printf("Before rotating\n");
                    printLevelOrder(*root);
                    RL_Rotate(parent_node,parent_node->right_node->left_node);
                    // printf("After rotating\n");
                    printLevelOrder(*root);

                    }

                    else
                    {
                    //  printf("Before rotating\n");
                    printLevelOrder(*root);
                    RR_Rotate(parent_node,parent_node->right_node->right_node);
                    // printf("After rotating\n");
                    printLevelOrder(*root);
                    }
                    }

                    else
                    {
                    // printf("Before rotating\n");
                    printLevelOrder(*root);
                    RR_Rotate(parent_node,parent_node->right_node->right_node);
                    // printf("After rotating\n");
                    printLevelOrder(*root);

                    }

                }

                else
                {
                    // printf("Before rotating\n");
                    printLevelOrder(*root);
                    RL_Rotate(parent_node,parent_node->right_node->left_node);
                    // printf("After rotating\n");
                    printLevelOrder(*root);
                }
            }

            if(b>1)
            {
                if(parent_node->left_node->left_node!=NULL)
                {

                    if(parent_node->left_node->right_node!=NULL)
                    {

                        if(getHeight(parent_node->left_node->right_node)>getHeight(parent_node->left_node->left_node))
                        {
                            //  printf("Before rotating\n");
                            printLevelOrder(*root);
                            LR_Rotate(parent_node,parent_node->left_node->right_node);
                            // printf("After rotating\n");
                            printLevelOrder(*root);

                        }

                        else
                        {
                            //  printf("Before rotating\n");
                            printLevelOrder(*root);
                            LL_rotate(parent_node,parent_node->left_node->left_node);
                            // printf("After rotating\n");
                            printLevelOrder(*root);
                        }

                    }

                    else
                    {

                    // printf("Before rotating\n");
                    printLevelOrder(*root);
                    LL_rotate(parent_node,parent_node->left_node->left_node);
                    // printf("After rotating\n");
                    printLevelOrder(*root);
                    }

                }
                else
                {
                    // printf("Before rotating\n");
                    printLevelOrder(*root);
                    LR_Rotate(parent_node,parent_node->left_node->right_node);
                    // printf("After rotating\n");
                    printLevelOrder(*root);

                }
            }
            parent_node=parent_node->parent_node;

            }
    }

    //Deleting node having two children
    else
    {
        m++;

        /*
        printf("Tree traversal of  delete node\n");

        if(c==122)
        {

        int k=find_node_in_tree(*root,(*root)->right_node);

        if(k==1)
        {
            printf("Del node is in the tree\n");
        }

        else
        {
            printf("Del node is not in the tree\n");
        }

        //printLevelOrder(del_node);

        printf("Delete node address=%p\n",(void *)del_node);
        block_meta_data_t *t1=meta_data_block_addr(del_node);

        printf("Delete meta data size=%d\n",(int)t1->block_size);

        printf("Delete left node address=%p\n",(void *)del_node->left_node);

        block_meta_data_t *t2=meta_data_block_addr(del_node->left_node);

        printf("Delete left node meta data size=%d\n",(int)t2->block_size);

        printf("Delete left left node address=%p\n",(void *)del_node->left_node->left_node);

        printf("Delete left right node address=%p\n",(void *)del_node->left_node->right_node);

        printf("Delete left parent node address=%p\n",(void *)del_node->left_node->parent_node);

        printf("Delete right node address=%p\n",(void *)del_node->right_node);

         printf("Delete right left node address=%p\n",(void *)del_node->right_node->left_node);

         printf("Delete right right node address=%p\n",(void *)del_node->right_node->right_node);


        exit(0);
        }
        */

       //printf("Parent node pointer=%p\n",(void *)del_node->left_node->parent_node);

       //exit(0);

        tree_node_t *min_right_node=get_min_node(del_node->right_node);

        //print

        /*
        if(min_right_node->parent_node==NULL)
        {

            if(find_node_in_tree(*root,min_right_node)==1)
            {
                printf("Node found\n");
            }

            else
            {
                printf("Node not found\n");
            }
            set_mappings(del_node);

            exit(0);
        }
        */

        //printf("Del node address=%p\n",del_node);

        //printf("min right node address=%p\n",min_right_node);
        //printf("Before removing min right node parent node=%p\n",min_right_node->parent_node);
        //tree_node_t *t1=min_right_node->parent_node;
        //printf("Before removing min right node parent node left=%p\n",t1->left_node);
        //printf("Before removing min right node parent node right=%p\n",t1->right_node);

        remove_block_from_tree(root,min_right_node);

        //printf("After removing min right node parent node=%p\n",min_right_node->parent_node);
        //printf("After removing min right node parent node left=%p\n",t1->left_node);
        //printf("After removing min right node parent node right=%p\n",t1->right_node);
        //printf("Before removing min right node parent node left=%p\n",min_right_node->parent_node->left_node);
        //printf("Before removing min right node parent node right=%p\n",min_right_node->parent_node->right_node);

        //exit(0);

        /*

        printf("Tree traversal after right node removed\n");

        printLevelOrder(*root);*/

        tree_node_t *parent_node_1=del_node->parent_node;

        min_right_node->left_node=del_node->left_node;

        if(del_node->left_node!=NULL)
        {
            del_node->left_node->parent_node=min_right_node;
        }

        min_right_node->right_node=del_node->right_node;

        if(del_node->right_node!=NULL)
        {
            del_node->right_node->parent_node=min_right_node;
        }

        min_right_node->parent_node=parent_node_1;

        if(parent_node_1==NULL)
        {
            *root=min_right_node;

        }

        else if(parent_node_1->right_node==del_node)
        {
            parent_node_1->right_node=min_right_node;
        }

        else if(parent_node_1->left_node==del_node)
        {
            parent_node_1->left_node=min_right_node;
        }


    }

    del_node->left_node=NULL;
    del_node->right_node=NULL;
    del_node->parent_node=NULL;
}

int get_internal_fragmented_size(block_meta_data_t *block1,block_meta_data_t *block2)
{

    block_meta_data_t *next_meta_block_by_size=NEXT_META_BLOCK_BY_SIZE(block1);

    return (int)((char *)block2-(char *)next_meta_block_by_size);

}

void merge_free_blocks(block_meta_data_t *first,block_meta_data_t *second)
{

    assert(first->is_free==MM_TRUE&&second->is_free==MM_TRUE);

    first->block_size+=ALIGN(sizeof(block_meta_data_t)) + second->block_size+ALIGN(sizeof(block_end_meta_data_t));

    first->next_block=second->next_block;

    if(second->next_block!=NULL)
    {
    second->next_block->prev_block=first;
    }


}

void create_new_block_and_insert_into_freelist(block_meta_data_t *meta_data_block,uint32_t final_remain)
{
    block_end_meta_data_t *end_meta_data_block = (block_end_meta_data_t *)end_meta_data_addr(meta_data_block);
    end_meta_data_block->block_size = meta_data_block->block_size;
    if(meta_data_block->is_free == MM_TRUE)
        meta_data_block->is_free = MM_FALSE;
    if(final_remain < META_DATA_OVERHEAD)
    {
        if(meta_data_block->next_block)
            meta_data_block->next_block->prev_block = meta_data_block;
        return;
    }
    block_meta_data_t *new_block = (block_meta_data_t *)NEXT_META_BLOCK_BY_SIZE(meta_data_block);
    new_block->block_size = final_remain-META_DATA_OVERHEAD;
    new_block->tree_node = init_free_node();
    new_block->is_free = MM_TRUE;
    mm_bind_blocks_for_allocation(meta_data_block, new_block);
    assert(meta_data_block->next_block->block_size == new_block->block_size);
    block_end_meta_data_t *new_end_meta_data_block = (block_end_meta_data_t *)end_meta_data_addr(new_block);
    new_end_meta_data_block->block_size = new_block->block_size;
    if(new_block->next_block && new_block->next_block->is_free == MM_TRUE)
        merge_free_blocks(new_block, new_block->next_block);
    if(new_block->prev_block && new_block->prev_block->is_free == MM_TRUE)
        merge_free_blocks(new_block, new_block->prev_block);
    insert_node_in_freelist(root,new_block);
}


void *allocate_requested_size(size_t size)
{
    size_t sys_page_size=mem_pagesize();
    int no_of_pages_req=((size+2*ALIGN(sizeof(block_end_meta_data_t))+2*ALIGN(sizeof(block_meta_data_t))+sys_page_size-1)/sys_page_size);
    size_t extra_size_req=(int)no_of_pages_req*sys_page_size;
    void *store_brk = mem_heap_hi();
    void *brk= mem_sbrk(extra_size_req);
    if(store_brk==brk && *(int *)brk == -1)
        return NULL;
    return brk;
}


int mm_init(void)
{

	//This function is called every time before each test run of the trace.
	//It should reset the entire state of your malloc or the consecutive trace runs will give wrong answer.


	/*
	 * This function should initialize and reset any data structures used to represent the starting state(empty heap)
	 *
	 * This function will be called multiple time in the driver code "mdriver.c"
	 */

     if(init_mem_sbrk_break==NULL)
    {
    mem_init();
    }
    mem_reset_brk();
    init_mem_sbrk_break=mem_sbrk(mem_pagesize());
    if(*(int *)init_mem_sbrk_break==-1)
    {
        return -1;
    }
    root=(tree_node_t **)init_mem_sbrk_break;
    block_meta_data_t *metadata=(block_meta_data_t *)((char *)root+ALIGN(sizeof(root)));
    metadata->is_free=MM_TRUE;
    metadata->block_size=mem_pagesize()-ALIGN(sizeof(block_meta_data_t))-ALIGN(sizeof(block_end_meta_data_t))-ALIGN(sizeof(root));
    metadata->tree_node=init_free_node();
    metadata->next_block=NULL;
    metadata->prev_block=NULL;
    *root=&(metadata->tree_node);
    block_end_meta_data_t *end_meta_data=end_meta_data_addr(metadata);
    end_meta_data->block_size=metadata->block_size;
    return 0;		//Returns 0 on successfull initialization.
}

//---------------------------------------------------------------------------------------------------------------
/*
 * mm_malloc - Allocate a block by incrementing the brk pointer.
 *     Always allocate a block whose size is a multiple of the alignment.
 */
void *mm_malloc(size_t size)
{
	/*
	 * This function should keep track of the allocated memory blocks.
	 * The block allocation should minimize the number of holes (chucks of unusable memory) in the heap memory.
	 * The previously freed memory blocks should be reused.
	 * If no appropriate free block is available then the increase the heap  size using 'mem_sbrk(size)'.
	 * Try to keep the heap size as small as possible.
	 */


    // printf("[IN MALLOC]\n");
	if(size <= 0){		// Invalid request size
		return NULL;
	}
	size = ((size+7)/8)*8;		//size alligned to 8 bytes

     block_meta_data_t *free_metadata_block=get_node_from_tree(root,size);

    //If No free block available then we will request new pages by calling mem_sbrk()
     if(free_metadata_block==NULL||free_metadata_block->block_size<(size+ALIGN(sizeof(block_end_meta_data_t))+ALIGN(sizeof(block_meta_data_t))))
     {

        // printf("Came here\n");

    	void *brk = allocate_requested_size(size);

    	if(brk==NULL)
    	{
    	return NULL;
    	}

       block_end_meta_data_t *prev_end_meta_data=NULL;

       prev_end_meta_data=(block_end_meta_data_t *)((char *)brk-ALIGN(sizeof(block_end_meta_data_t)));

        block_meta_data_t *prev_start_meta_data=NULL;

        prev_start_meta_data=start_meta_data_addr(prev_end_meta_data);

        block_meta_data_t *next_meta_data_block=(block_meta_data_t *)brk;

        next_meta_data_block->is_free=MM_FALSE;

        next_meta_data_block->block_size=size;

        next_meta_data_block->tree_node=init_free_node();

        next_meta_data_block->prev_block=prev_start_meta_data;

        prev_start_meta_data->next_block=next_meta_data_block;

        next_meta_data_block->next_block=NULL;

        block_end_meta_data_t *next_end_meta_data_block=end_meta_data_addr(next_meta_data_block);

        next_end_meta_data_block->block_size=next_meta_data_block->block_size;

        int new_free_block_size=(uint32_t)((char *)mem_heap_hi()-(char *)brk+1-size-(2*(uint32_t)ALIGN(sizeof(block_meta_data_t)))-(2*(uint32_t)ALIGN(sizeof(block_end_meta_data_t))));

        if(new_free_block_size>0)
        {

        block_meta_data_t *new_free_meta_block=NEXT_META_BLOCK_BY_SIZE(next_meta_data_block);

        new_free_meta_block->is_free=MM_TRUE;

        // new_free_meta_block->block_size=(uint32_t)(extra_size_req-size-(2*sizeof(block_meta_data_t))-(2*sizeof(block_end_meta_data_t)));
		new_free_meta_block->block_size= (uint32_t)((char *)mem_heap_hi()-(char *)brk+1-size-(2*(uint32_t)ALIGN(sizeof(block_meta_data_t)))-(2*(uint32_t)ALIGN(sizeof(block_end_meta_data_t))));

         new_free_meta_block->tree_node=init_free_node();

         new_free_meta_block->prev_block=NULL;

        block_end_meta_data_t *new_end_free_meta_block=end_meta_data_addr(new_free_meta_block);

        new_end_free_meta_block->block_size=new_free_meta_block->block_size;

        insert_node_in_freelist(root,new_free_meta_block);

        mm_bind_blocks_for_allocation(next_meta_data_block,new_free_meta_block);
        }

        // printf("Tree after malloc\n");

        printLevelOrder(*root);

        return (void *)((char *)next_meta_data_block+ALIGN(sizeof(block_meta_data_t)));
     }

     assert(free_metadata_block->is_free==MM_TRUE);

    //  printf("Free Data block size=%d\n",(int)free_metadata_block->block_size);

     remove_block_from_tree(root,&free_metadata_block->tree_node);



     uint32_t remaining_size=free_metadata_block->block_size-size;

     free_metadata_block->is_free=MM_FALSE;

     free_metadata_block->block_size=size;

     block_end_meta_data_t *end_meta_data=end_meta_data_addr(free_metadata_block);

     end_meta_data->block_size=size;

    //Here we will created new block by splitting previous block
     if(ALIGN(sizeof(block_meta_data_t))+ALIGN(sizeof(block_end_meta_data_t))<remaining_size){

        block_meta_data_t *next_meta_block=NULL;

        block_end_meta_data_t *next_end_meta_block=NULL;

        next_meta_block=NEXT_META_BLOCK_BY_SIZE(free_metadata_block);

        next_meta_block->is_free=MM_TRUE;

        next_meta_block->block_size=remaining_size-ALIGN(sizeof(block_meta_data_t))-ALIGN(sizeof(block_end_meta_data_t));

        next_meta_block->tree_node=init_free_node();

        next_end_meta_block=end_meta_data_addr(next_meta_block);

        next_end_meta_block->block_size=next_meta_block->block_size;

        insert_node_in_freelist(root,next_meta_block);

        mm_bind_blocks_for_allocation(free_metadata_block,next_meta_block);
     }

        // printf("Tree after malloc\n");

        printLevelOrder(*root);


    //printf("Inorder Traversal of free list=\n");
    //inorderTraversal(*root);
     return (void *)((char *)free_metadata_block+ALIGN(sizeof(block_meta_data_t)));

    //mem_sbrk() is wrapper function for the sbrk() system call.
    //Please use mem_sbrk() instead of sbrk() otherwise the evaluation results
    //may give wrong results
}


void mm_free(void *ptr)
{
	/*
	 * Searches the previously allocated node for memory block with base address ptr.
	 *
	 * It should also perform coalesceing on both ends i.e. if the consecutive memory blocks are
	 * free(not allocated) then they should be combined into a single block.
	 *
	 * It should also keep track of all the free memory blocks.
	 * If the freed block is at the end of the heap then you can also decrease the heap size
	 * using 'mem_sbrk(-size)'.

	 */

	 c++;

    // printf("[IN FREE] %d\n",c);
	 block_meta_data_t *meta_data_block=(block_meta_data_t *)((char *)ptr-ALIGN(sizeof(block_meta_data_t)));

     assert(meta_data_block->is_free==MM_FALSE);

     meta_data_block->is_free=MM_TRUE;

     block_meta_data_t *prev_meta_data_block=meta_data_block->prev_block;

     block_meta_data_t *next_meta_data_block=meta_data_block->next_block;

     block_meta_data_t *merged_meta_data_block=NULL;

     block_end_meta_data_t *merged_end_meta_data_block=NULL;


     if(next_meta_data_block!=NULL)
     {
           meta_data_block->block_size+= get_internal_fragmented_size(meta_data_block,next_meta_data_block);
     }
     //If block being free is upper most block
    else
    {
        int fragmented_size=(int)((char *)mem_heap_hi()+1-((char *)end_meta_data_addr(meta_data_block)+ALIGN(sizeof(block_end_meta_data_t))));
        meta_data_block->block_size+=fragmented_size;
    }

    merged_meta_data_block=meta_data_block;

    if(next_meta_data_block!=NULL&&next_meta_data_block->is_free==MM_TRUE)
    {
        /*
        if(c==88)
        {
            printf("Next block is free and its size is %d\n",(int)next_meta_data_block->block_size);
            printf("Meta data block size=%d\n",(int)meta_data_block->block_size);
        }
        */
        remove_block_from_tree(root,&next_meta_data_block->tree_node);

        /*
        if(c==88)
        {
            printf("Block removed from tree\n");

            printf("Tree Traversal after it got removed\n");

            printLevelOrder(*root);
        }
        */

        merge_free_blocks(meta_data_block,next_meta_data_block);

        merged_meta_data_block=meta_data_block;

    }

    if(prev_meta_data_block!=NULL&&prev_meta_data_block->is_free==MM_TRUE)
    {
        remove_block_from_tree(root,&prev_meta_data_block->tree_node);

        merge_free_blocks(prev_meta_data_block,meta_data_block);

        merged_meta_data_block=prev_meta_data_block;
    }

    merged_end_meta_data_block=(block_end_meta_data_t *)(end_meta_data_addr(merged_meta_data_block));

    merged_end_meta_data_block->block_size=merged_meta_data_block->block_size;

    insert_node_in_freelist(root,merged_meta_data_block);
}

/*
 * mm_realloc - Implemented simply in terms of mm_malloc and mm_free
 */
void *mm_realloc(void *ptr, size_t size)
{
    printf("[IN REALLOC]\n");
	size = ((size+7)/8)*8; //8-byte alignement

	if(ptr == NULL){			//memory was not previously allocated
		return mm_malloc(size);
	}

	if(size == 0){				//new size is zero
		mm_free(ptr);
		return NULL;
	}


	/*
	 * This function should also copy the content of the previous memory block into the new block.
	 * You can use 'memcpy()' for this purpose.
	 *
	 * The data structures corresponding to free memory blocks and allocated memory
	 * blocks should also be updated.
	*/

	block_meta_data_t *meta_data_block=(block_meta_data_t *)((char *)ptr-ALIGN(sizeof(block_meta_data_t)));

    if(size == meta_data_block->block_size)
        return (void *)((char *)meta_data_block+ALIGN(sizeof(block_meta_data_t)));


	 if(size < meta_data_block->block_size)
    {
        uint32_t original_size = (uint32_t)meta_data_block->block_size;
        uint32_t inter_frag = (uint32_t)get_internal_fragmented_size(meta_data_block,meta_data_block->next_block);
        meta_data_block->block_size = size;
        block_end_meta_data_t *end_meta_data_block = (block_end_meta_data_t *)end_meta_data_addr(meta_data_block);
        end_meta_data_block->block_size = meta_data_block->block_size;
        if(meta_data_block->next_block && meta_data_block->next_block->is_free==MM_TRUE)
        {
            block_meta_data_t *new_block = NEXT_META_BLOCK_BY_SIZE(meta_data_block);
            remove_block_from_tree(root, &meta_data_block->next_block->tree_node);
            new_block->block_size = meta_data_block->next_block->block_size + inter_frag + (original_size - size);
			meta_data_block->next_block = meta_data_block->next_block->next_block;
            new_block->is_free = MM_TRUE;
            new_block->tree_node= init_free_node();
            mm_bind_blocks_for_allocation(meta_data_block, new_block);

            block_end_meta_data_t *new_end_meta_data_block = (block_end_meta_data_t *)end_meta_data_addr(new_block);
            new_end_meta_data_block->block_size = new_block->block_size;
            insert_node_in_freelist(root,new_block);

            return (void *)((char *)meta_data_block+ALIGN(sizeof(block_meta_data_t)));

        }
        else
        {
            uint32_t inter_frag =0;
            int fragmented_size=(int)((char *)mem_heap_hi()+1-((char *)end_meta_data_addr(meta_data_block)+ALIGN(sizeof(block_end_meta_data_t))));
            if(!meta_data_block->next_block){
                if( (fragmented_size+original_size-size) < (ALIGN(sizeof(block_end_meta_data_t))+ALIGN(sizeof(end_meta_data_block))) )
                    return meta_data_block;
            }
            else{
                uint32_t inter_frag = get_internal_fragmented_size(meta_data_block,meta_data_block->next_block);
                if( (inter_frag+original_size-size) < (ALIGN(sizeof(block_end_meta_data_t))+ALIGN(sizeof(end_meta_data_block))) )
                    return meta_data_block;
                fragmented_size = 0;
            }

            meta_data_block->block_size  = size;
            block_end_meta_data_t *end_meta_data_block = (block_end_meta_data_t *)end_meta_data_addr(meta_data_block);
            end_meta_data_block->block_size = meta_data_block->block_size;

            if((original_size- size + inter_frag + fragmented_size) > META_DATA_OVERHEAD)
            {
                block_meta_data_t *new_block = (block_meta_data_t *)NEXT_META_BLOCK_BY_SIZE(meta_data_block);
                new_block->tree_node = init_free_node();
                new_block->is_free = MM_TRUE;
                new_block->block_size = original_size- size + inter_frag + fragmented_size - META_DATA_OVERHEAD;
                mm_bind_blocks_for_allocation(meta_data_block, new_block);
                block_end_meta_data_t *new_end_meta_data_block = (block_end_meta_data_t *)end_meta_data_addr(new_block);
                new_end_meta_data_block->block_size = new_block->block_size;
                insert_node_in_freelist(root,new_block);
            }
            return (void *)((char *)meta_data_block+ALIGN(sizeof(block_meta_data_t)));
        }
    }
    else
    {
        uint32_t req_rem_size = size-meta_data_block->block_size;
        uint32_t inter_frag = 0;
        if(meta_data_block->next_block)
            inter_frag = get_internal_fragmented_size(meta_data_block,meta_data_block->next_block);
        else
            inter_frag = (uint32_t)((char *)mem_heap_hi()+1-((char *)end_meta_data_addr(meta_data_block)+ALIGN(sizeof(block_end_meta_data_t))));

        if(req_rem_size <= inter_frag)
        {
            // TODO check sizeof function once
            meta_data_block->block_size = size;
            block_end_meta_data_t *end_meta_data_block = (block_end_meta_data_t *)end_meta_data_addr(meta_data_block);
            end_meta_data_block->block_size = meta_data_block->block_size;

            return (void *)((char *)meta_data_block+ALIGN(sizeof(block_meta_data_t)));  // Not handling adding remaining free part to free list because it is small in size to handle even headers, so skkipping.
        }

        if(meta_data_block->next_block && meta_data_block->next_block->is_free==MM_TRUE && meta_data_block->prev_block && meta_data_block->prev_block->is_free==MM_TRUE && \
                                                        req_rem_size <= TOTAL_COMBINED_SIZE_OF_BLOCKS(meta_data_block)+inter_frag)
        {
            remove_block_from_tree(root,&meta_data_block->prev_block->tree_node);
            remove_block_from_tree(root,&meta_data_block->next_block->tree_node);
            req_rem_size -= inter_frag;
            inter_frag = get_internal_fragmented_size(meta_data_block->prev_block,meta_data_block);
            req_rem_size -= inter_frag;
            uint32_t final_remain = abs(meta_data_block->next_block->block_size+meta_data_block->prev_block->block_size+2*ALIGN(sizeof(block_end_meta_data_t)) \
                                                                                                                            +2*ALIGN(sizeof(block_meta_data_t)) - req_rem_size);
            meta_data_block->prev_block->block_size = size;
            meta_data_block = meta_data_block->prev_block;
            block_meta_data_t *store_head = meta_data_block->next_block;
            meta_data_block->next_block = meta_data_block->next_block->next_block->next_block;
            meta_data_block->is_free = MM_FALSE;
            memcpy((char *)(meta_data_block)+ALIGN(sizeof(block_meta_data_t)), (char *)(store_head)+ALIGN(sizeof(block_meta_data_t)),store_head->block_size);
            create_new_block_and_insert_into_freelist(meta_data_block,final_remain);
            return (void *)((char *)meta_data_block+ALIGN(sizeof(block_meta_data_t)));
        }


        if(meta_data_block->next_block && meta_data_block->next_block->is_free == MM_TRUE &&  \
                                                        req_rem_size <= (TOTAL_COMBINE_SIZE_OF_BLOCKS(meta_data_block->next_block)+inter_frag))
        {
            remove_block_from_tree(root,&meta_data_block->next_block->tree_node);
            req_rem_size -= inter_frag;
            uint32_t final_remain = TOTAL_COMBINE_SIZE_OF_BLOCKS(meta_data_block->next_block) - req_rem_size;
            meta_data_block->block_size = size;
            block_meta_data_t *store_head = meta_data_block->next_block;
            meta_data_block->next_block = meta_data_block->next_block->next_block;
            create_new_block_and_insert_into_freelist(meta_data_block,final_remain);
            return (void *)((char *)meta_data_block+ALIGN(sizeof(block_meta_data_t)));
        }


        if(meta_data_block->prev_block && meta_data_block->prev_block->is_free == MM_TRUE && \
                                                        req_rem_size <= (TOTAL_COMBINE_SIZE_OF_BLOCKS(meta_data_block->prev_block)+inter_frag)){
                inter_frag = get_internal_fragmented_size(meta_data_block->prev_block,meta_data_block);
                remove_block_from_tree(root,&meta_data_block->prev_block->tree_node);
                req_rem_size -= inter_frag;
                uint32_t final_remain = abs(TOTAL_COMBINE_SIZE_OF_BLOCKS(meta_data_block->prev_block) - req_rem_size);
                meta_data_block->prev_block->block_size = size;
                meta_data_block = meta_data_block->prev_block;
                meta_data_block->is_free = MM_FALSE;
                block_meta_data_t *store_head = meta_data_block->next_block;
                meta_data_block->next_block = meta_data_block->next_block->next_block;
                memcpy((char *)(meta_data_block)+ALIGN(sizeof(block_meta_data_t)), (char *)(store_head)+ALIGN(sizeof(block_meta_data_t)),store_head->block_size);
                create_new_block_and_insert_into_freelist(meta_data_block,final_remain);
                return (void *)((char *)meta_data_block+ALIGN(sizeof(block_meta_data_t)));
        }

        void *ptr = mm_malloc(size);
        block_meta_data_t *new_meta_data_block = (block_meta_data_t *)((char *)ptr-ALIGN(sizeof(block_meta_data_t)));
        uint32_t amount_to_be_copied = meta_data_block->block_size;
        memcpy((char *)(new_meta_data_block)+ALIGN(sizeof(block_meta_data_t)), (char *)(meta_data_block)+ALIGN(sizeof(block_meta_data_t)),amount_to_be_copied);
        mm_free((void *)((char *)meta_data_block+ALIGN(sizeof(block_meta_data_t))));
        return (void *)((char *)new_meta_data_block+ALIGN(sizeof(block_meta_data_t)));
    }

}

// int main()
// {
//    mm_init();
//    void *p1=mm_malloc(40);

//    void *p3=mm_malloc(60);
//    void *p4=mm_malloc(100);
//    void *p5=mm_malloc(20);
//    void *p6=mm_malloc(90);
//    void *p7=mm_malloc(3500);
//    printf("Above Call Executed\n");
// //    mm_free(p2);


// 	mm_free(p4);
//    	mm_free(p6);
//    	mm_free(p1);
// //    mm_free(p3);
// //    mm_free(p5);
// //    mm_free(p7);
//    printf("[FINAL INORDER TRAVERSAL]\n");
//    inorderTraversal(*root);
//    //mm_free(p2);
//    //mm_free(p2);
//    //void *p4=mm_malloc(40);

//    return 0;
// }
