#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netinet/in.h>
#include <pthread.h>
#include "http_server.hh"
#include <queue>
#include <signal.h>
using namespace std;
//
queue <int> Clients;
pthread_mutex_t mutexClients = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t cvThread = PTHREAD_COND_INITIALIZER;
pthread_cond_t cv_master_Thread = PTHREAD_COND_INITIALIZER;
int master_sleep=0;
int flag=0;

#define NumThreads 8
#define MAX_Clients 512
pthread_t thread_id[NumThreads];

void error(const char *msg)
{
    perror(msg);
    exit(1);
}
void intHandler(int num)
{
    flag=1;
    pthread_cond_broadcast(&cvThread);
    pthread_cond_signal(&cv_master_Thread);
    //cout<<"In Handler"<<endl;
    fflush(stdout);

    for (int i = 0; i < NumThreads; ++i) 
    {
    //cout<<"Wala Thread Joined"<<endl;
    pthread_join(thread_id[i],NULL);
    //cout<<"Wala Thread Joined"<<endl;
    }
    exit(0);

}

void *clientHandler(void *arg)
{
    char buffer[1024];
    int n = 0;
    int newsockfd;
    
    string response_string;
    
    while(true)
    {   HTTP_Response *response;
        pthread_mutex_lock(&mutexClients);
        while(Clients.empty()){
             if(flag) {//cout<<"YeLoopBhiKhatam"; fflush(stdout); 
             break;} 
             pthread_cond_wait(&cvThread,&mutexClients); 
        }
        if(!flag){

                newsockfd = Clients.front();
                Clients.pop();
                if(master_sleep)
                {   master_sleep=0;
                //cout<<"Signal to wake server up will be sent"<<endl;
                pthread_cond_signal(&cv_master_Thread);
                }
                pthread_mutex_unlock(&mutexClients);

                // reading client's message
                bzero(buffer, 1024);
                n = read(newsockfd, buffer, 1023);
                //printf("%s",buffer);
                if (n < 0) { 
                    //error("ERROR Reading From Socket");
                   close(newsockfd);
                   continue;
                }
                
                response = handle_request(buffer);
                response_string = response->get_string();
                // cout << response_string;
                // fflush(stdout);
                n = write(newsockfd, response_string.c_str(), response_string.size());
                if (n < 0) 
                {
                   close(newsockfd);
                   continue;
                // error("ERROR writing to socket");
                }
                

                delete response;
                close(newsockfd);
                //sleep(50);

        }
        else if(flag)
         {
            pthread_mutex_unlock(&mutexClients);
             break;}
        
        }
    // cout<<"Thread Loop Ke Bahar";
    // fflush(stdout);    
    
    pthread_exit(NULL);
}
void init_server(struct sockaddr_in *server_addr, int portno)
{
    server_addr->sin_family = AF_INET;
    server_addr->sin_addr.s_addr = INADDR_ANY;
    server_addr->sin_port = htons(portno);
}

int main(int argc, char *argv[])
{
    int sockfd, newsockfd, portno, n;
    socklen_t client_len;
    struct sockaddr_in server_addr, client_addr;
    pthread_t thread_No[NumThreads] ;
    struct sigaction sa={0};
    sa.sa_handler= intHandler;
    sa.sa_flags = SA_RESTART ;
    sigaction(SIGINT,&sa,NULL);
    // signal(SIGINT, intHandler);
    
    
    if (argc < 2)
    {
        fprintf(stderr, "ERROR,No Port Provided\n");
        exit(1);
    }

    // socketCreation and server initialization
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0)
        error("ERROR Opening Socket\n");

    bzero((char *)&server_addr, sizeof(server_addr));
    portno = atoi(argv[1]);
    init_server(&server_addr, portno);

    // socket binding to the portno
    if (bind(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0)
        error("ERROR On Binding\n");

    for(int i=0;i<NumThreads;i++) 
    {   thread_No[i]=i;
        pthread_create(&thread_id[i],NULL,clientHandler,&thread_No[i]); }

    while (!flag)
    {   
        
        // listen for incoming connection requests
        listen(sockfd, 256);
        client_len = sizeof(client_addr);

        // accepting a new request by creating a newsockfd
        newsockfd = accept(sockfd, (struct sockaddr *)&client_addr, &client_len);

        if (newsockfd < 0)
            error("ERROR on accept\n");
        
        pthread_mutex_lock(&mutexClients);
        Clients.push(newsockfd);
        while(Clients.size()==MAX_Clients){
            master_sleep=1;
            //cout<<"Server Will Sleep Now"<<endl; 
            pthread_cond_wait(&cv_master_Thread,&mutexClients);
        }
        pthread_mutex_unlock(&mutexClients);
        pthread_cond_signal(&cvThread);
        //cout<<Clients.front(); fflush(stdout);

       

    }

    return 0;
}
