#include "http_server.hh"

#include <vector>

#include <sys/stat.h>

#include <fstream>
#include <sstream>

vector<string> split(const string &s, char delim)
{
  vector<string> elems;

  stringstream ss(s);
  string item;

  while (getline(ss, item, delim))
  {
    if (!item.empty())
      elems.push_back(item);
  }

  return elems;
}

HTTP_Request::HTTP_Request(string request)
{
  vector<string> lines = split(request, '\n');
  vector<string> first_line = split(lines[0], ' ');

  this->HTTP_version = "1.0"; // We'll be using 1.0 irrespective of the request

  /*
   TODO : extract the request method and URL from first_line here
  */
  this->method = first_line[0];
  this->url = first_line[1];
  //cout<<this->method;
  fflush(stdout);

  if (this->method != "GET")
  {
    cerr << "Method '" << this->method << "' not supported" << endl;
    exit(1);
  }
}

HTTP_Response *handle_request(string req)
{
  HTTP_Request *request = new HTTP_Request(req);

  HTTP_Response *response = new HTTP_Response();

  string url = string("html_files") + request->url;

  response->HTTP_version = "1.0";

  struct stat sb;
  if (stat(url.c_str(), &sb) == 0) // requested path exists
  {
    int flag = 0;

    string body;

    if (S_ISDIR(sb.st_mode))
    {
      /*
      In this case, requested path is a directory.
      TODO : find the index.html file in that directory (modify the url
      accordingly)
      */

      // file = fopen(url + "/index.html","r")

      ifstream f(url + "/index.html");
      if (f)
      {
        url = url + "/index.html";
      }

      else
      {
        ifstream f("html_files/notfound.html");
        response->status_code = "404";
        if (f)
        {
          ostringstream ss;
          ss << f.rdbuf();
          response->body = ss.str();
        }
        response->status_text = "Page Not Found";
        flag = 1;
      }
    }

    /*
    TODO : open the file and read its contents
    */
    if (!flag)
    {
      ifstream f(url);
      if (f)
      {
        ostringstream ss;
        ss << f.rdbuf();
        response->body = ss.str();
        response->status_code = "200";
        response->status_text = "OK";
      }

      /*
      TODO : set the remaining fields of response appropriately
      */
      // DummyValue
      response->Date = "Date: Mon, 27 Jul 2009 12:28:53 GMT";
      response->content_type = "text/html";
      response->content_length = to_string(response->body.length()); 
    }
  }

  else
  {
    ifstream f("html_files/notfound.html");
    response->status_code = "404";
    if (f)
    {
      ostringstream ss;
      ss << f.rdbuf();
      response->body = ss.str();
    }
    /*
    TODO : set the remaining fields of response appropriately
    */
    response->status_text = "Page Not Found";
    response->content_type = "text/html";
    response->content_length = to_string(response->body.length()); 
    // DummyValue
    response->Date = "Date: Mon, 27 Jul 2009 12:28:53 GMT";
  }

  delete request;

  return response;
}

string HTTP_Response::get_string()
{
  /*
  TODO : implement this function
  */

  return "HTTP/" + HTTP_version + " " + status_code + " " + status_text + "\n" + Date + "\n" + "Content-Length: " + content_length + "\n" + "Content-Type: " + content_type + "\r\n\n" + body;
}
