pragma solidity ^0.4.4;
import "DAuction.sol";

contract DEnglishAuction is DAuction {

	uint256 minBidIncrement;
	uint numUnchallengedBlocks;
	uint lastBidBlock;

	mapping (address => uint) PendingWithdrawals;
	bool refundCalled;
	bool finalizeCalle

    // constructor
    function DEnglishAuction(uint256 reservePrice, address judgeAddress, uint256 biddingTimePeriod, uint256 minBidIncrement) DAuction(reservePrice, biddingTimePeriod, judgeAddress) {
        this.minBidIncrement = minBidIncrement;
        numUnchallengedBlocks = 3;
    }

    function bid() biddingOpen payable returns(address highestBidderAddr) {
    	require(msg.value >= minimumPrice);
    	require(msg.value >= highestBid + minBidIncrement);
    	if(highestBidder!=0){
    		if(!highestBidder.send(highestBid)){
    			PendingWithdrawals[highestBidder]+=highestBid;
    		}
    	}
    	highestBidder = msg.sender;
    	highestBid = msg.value;
    	lastBidBlock = block.number;
    	return highestBidder;
    }

    

    function finalize() auctionOver {
    	require(msg.sender==highestBidder || msg.sender = judgeAddress);
    	require(!refundCalled && !finalizeCalled);
    	finalizeCalled=true;
    	creator.transfer(highestBid);
    }

    function refund(uint256 refundAmount) auctionOver judgeOnly {
    	require(highestBidder!=0);
		require(refundAmount<= this.balance);
		require(!finalizeCalled && !refundCalled);
		refundCalled = true;
		highestBidder.transfer(refundAmount);
		creator.transfer(highestBid-refundAmount);
    }

    function withdraw(){
    	int amount = PendingWithdrawals[msg.sender];
    	PendingWithdrawals[msg.sender]=0;
    	if(amount>0){
    		msg.sender.transfer(amount);
    	}
    }

    modifier auctionOver {
    	require(block.number > startBlockNum+biddingBlocksNum);
    	_;
    }


    modifier biddingOpen {
    	require(lastBidBlock+numUnchallengedBlocks>=block.number);
		require(block.number<=startBlockNum+biddingBlocksNum);
		_;
    }

}
