pragma solidity ^0.4.4;
import "DAuction.sol";
contract DDutchAuction is DAuction {

	uint256 decrementPerBlock;
	bool bidover;
	uint256 startPrice;
	bool refundCalled;
	bool finalizeCalled;



	// constructor
	function DDutchAuction(uint256 reservePrice, address judgeAddress, uint256 biddingPeriod, uint256 offerPriceDecrement) DAuction(reservePrice, biddingPeriod, judgeAddress) {
	    decrementPerBlock = offerPriceDecrement;
	    startPrice = reservePrice+biddingPeriod*offerPriceDecrement;
	}

	function bid() biddingOpen payable returns(address highestBidderAddr){
		uint256 currentPrice = startPrice-(block.number-startBlockNum)*decrementPerBlock;
		require(msg.value >= currentPrice);
		highestBidder = msg.sender;
		highestBid = msg.value;
		bidover = true;
		return highestBidder;
	}


	function finalize(){
		require(msg.sender==highestBidder || msg.sender = judgeAddress);
		require(!refundCalled && !finalizeCalled);
		finalizeCalled=truel
		creator.transfer(highestBid);
	}


	function refund(uint256 refundAmount) auctionOver judgeOnly {
		require(highestBidder!=0);
		require(refundAmount<= this.balance);
		require(!finalizeCalled && !refundCalled);
		refundCalled=true;
		highestBidder.transfer(refundAmount);
		creator.transfer(this.balance);
	}

	modifier biddingOpen {
		require(block.number<=startBlockNum+biddingBlocksNum);
		require(!bidover);
		_;
	}

	modifier auctionOver {
		require(block.number>startBlockNum+biddingBlocksNum || bidover);
		_;
	}
}
