#include"parsexml.h"
#include <stdbool.h>
#include <stddef.h>
#include<stdlib.h>
#include<stdio.h>
#include<unistd.h>
#include<pthread.h>
#include<string.h>
#include"KVCache.h"
#include "threadPool.h"
#include "chord.h"

struct request {
    tFunction func;
    char *arg;
    int clientFD;
    struct request *next;
};
typedef struct request request_t;

struct tpool {
    request_t    *first;
    request_t    *work_last;
    pthread_mutex_t  queueLock;
    pthread_cond_t   threadWait;
    pthread_cond_t   producerWait;
    size_t           workingCount;
    size_t           activeThreads;
    bool             stop;
};

static request_t *createJob(tFunction func, void *arg)
{
    request_t *work;

    if (func == NULL)
        return NULL;

    work       = malloc(sizeof(*work));
    work->func = func;
    work->arg  = arg;
    // work->clientFD = clientFD;
    work->next = NULL;
    return work;
}

static void deleteJob(request_t *work)
{
    if (work == NULL)
        return;
    free(work);
}

static request_t *tpoolGetRequest(tpool_t *tm)
{
    request_t *work;

    if (tm == NULL)
        return NULL;

    work = tm->first;
    if (work == NULL)
        return NULL;

    if (work->next == NULL) {
        tm->first = NULL;
        tm->work_last  = NULL;
    } else {
        tm->first = work->next;
    }
    return work;
}

static void *threadMainFunction(void *arg)
{
    tpool_t      *tm = arg;
    request_t *work;

    while (1) {
        pthread_mutex_lock(&(tm->queueLock));
        if (tm->stop)
            break;

        if (tm->first == NULL) {
            pthread_cond_wait(&(tm->threadWait), &(tm->queueLock));
        }
        work = tpoolGetRequest(tm);
        tm->workingCount++;
        pthread_mutex_unlock(&(tm->queueLock));

        if (work != NULL) {
            work->func(work->arg);
            // if(work->arg !=NULL);
                // write(work->clientFD,work->arg,sizeof(char)*strlen(work->arg));
            deleteJob(work);
        }

        pthread_mutex_lock(&(tm->queueLock));
        tm->workingCount--;
        if (!tm->stop && tm->workingCount == 0 && tm->first == NULL)
            pthread_cond_signal(&(tm->producerWait));
        pthread_mutex_unlock(&(tm->queueLock));
    }

    tm->activeThreads--;
    pthread_cond_signal(&(tm->producerWait));
    pthread_mutex_unlock(&(tm->queueLock));
    return NULL;
}

tpool_t *createThreadPool(size_t num)
{
    tpool_t   *tm;
    pthread_t  thread;
    size_t     i;

    if (num == 0)
        num = 2;

    tm             = calloc(1, sizeof(*tm));
    tm->activeThreads = num;

    pthread_mutex_init(&(tm->queueLock), NULL);
    pthread_cond_init(&(tm->threadWait), NULL);
    pthread_cond_init(&(tm->producerWait), NULL);

    tm->first = NULL;
    tm->work_last  = NULL;

    for (i=0; i<num; i++) {
        pthread_create(&thread, NULL, threadMainFunction, tm);
        pthread_detach(thread);
    }

    return tm;
}
void destroyThreadPool(tpool_t *tm)
{
    request_t *work;
    request_t *work2;

    if (tm == NULL)
        return;

    pthread_mutex_lock(&(tm->queueLock));
    work = tm->first;
    while (work != NULL) {
        work2 = work->next;
        deleteJob(work);
        work = work2;
    }
    tm->stop = true;
    pthread_cond_broadcast(&(tm->threadWait));
    pthread_mutex_unlock(&(tm->queueLock));

    tpoolWait(tm);

    pthread_mutex_destroy(&(tm->queueLock));
    pthread_cond_destroy(&(tm->threadWait));
    pthread_cond_destroy(&(tm->producerWait));

    free(tm);
}

bool addRequestToQueue(tpool_t *tm, tFunction func, void *arg)
{
    request_t *work;
    int msglen = 1024*257+170;
    char* copyBuffer = (char*)malloc(sizeof(char)*msglen);
    strcpy(copyBuffer,arg);
    if (tm == NULL)
        return false;
    work = createJob(func, copyBuffer);
    if (work == NULL)
        return false;
    pthread_mutex_lock(&(tm->queueLock));
    if (tm->first == NULL) {
        tm->first = work;
        tm->work_last  = tm->first;
    } else {
        tm->work_last->next = work;
        tm->work_last       = work;
    }
    pthread_cond_signal(&(tm->threadWait));
    pthread_mutex_unlock(&(tm->queueLock));
    return true;
}

void tpoolWait(tpool_t *tm)
{
    if (tm == NULL)
        return;

    pthread_mutex_lock(&(tm->queueLock));
    while (1) {
        if ((!tm->stop && tm->workingCount != 0) || (tm->stop && tm->activeThreads != 0)) {
            pthread_cond_wait(&(tm->producerWait), &(tm->queueLock));
        } else {
            break;
        }
    }
    pthread_mutex_unlock(&(tm->queueLock));
}

void worker(char *arg)
{
    int *val = (int*)arg;
    int  old = *val;

    *val += 1000;
    printf("tid=%ld, old=%d, val=%d\n", pthread_self(), old, *val);

    if (*val%2)
        usleep(100000);
}
static const size_t num_threads = 4;
static const size_t num_items   = 5;

int init(int argc, char **argv)
{
    tpool_t *tm;
    int     *vals;
    size_t   i;

    tm   = createThreadPool(num_threads);
    vals = calloc(num_items, sizeof(*vals));
    char* buffer[10];
    buffer[0] = malloc(sizeof(char)*1025);
    buffer[1] = malloc(sizeof(char)*1025);
    buffer[2] = malloc(sizeof(char)*1025);
    buffer[3] = malloc(sizeof(char)*1025);
    char* key = malloc(sizeof(char)*256+1);
    char* value = malloc(sizeof(char)*256*1024 +1);
    char* operation = malloc(sizeof(char)*7);
    char* cacheptr =  buildCache(2, 2);
    strcpy(buffer[0],"<?xml version=\"1.0\" encoding=\"UTF-8\"?><KVMessage type=\"putreq\"><Key>5</Key><Value>25</Value></KVMessage>");
    strcpy(buffer[1],"<?xml version=\"1.0\" encoding=\"UTF-8\"?><KVMessage type=\"getreq\"><Key>5</Key><Value></Value></KVMessage>");
    strcpy(buffer[2],"<?xml version=\"1.0\" encoding=\"UTF-8\"?><KVMessage type=\"delreq\"><Key>5</Key><Value></Value></KVMessage>");
    strcpy(buffer[3],"<?xml version=\"1.0\" encoding=\"UTF-8\"?><KVMessage type=\"getreq\"><Key>5</Key><Value></Value></KVMessage>");
    for (i=0; i<4; i++) {
        vals[i] = i;
        addRequestToQueue(tm, decodeRequestAndProcess, buffer[i]);
    }
    tpoolWait(tm);
    free(vals);
    destroyThreadPool(tm);
    return 0;
}

void decodeRequestAndProcess(char* buffer) {
    extReq_t *request;
    // char* key;
    // char* value = (char *)malloc(sizeof(char)*1024*256+1);
    // char* operation = (char *)malloc(sizeof(char)*7);
    // char* err = (char *)malloc(sizeof(char)*170);
    request = extractXML(buffer);
    if(request->error){
        strcpy(buffer,toRespXML(request->err));
        return;
    }
    puts("key");
    puts(request->key);
    int id = keyToId(request->key);
    printf("key id : %d\n",id);
    Node successorNode = findSuccessor(id,false); //find server where the key belongs
    if(successorNode.nodeId == chord.node.nodeId) { //key belongs to the server
        puts("Node Id self");
        printf("%d\n Key Id: %d,\n",chord.node.nodeId,id);
        if(!strcmp(request->operation,"putreq")){
            puts("putreq");
            addKey(request->key,request->val);
            strcpy(buffer,toRespXML("Success"));
            // puts("buffer");
            // puts(buffer);
        }
        else if(!strcmp(request->operation,"getreq")){
            puts("getreq");
            if(searchKey(request->key,request->val))
                strcpy(buffer,toXML("resp",request->key,request->val,request->ipAddr,request->port));
            else
                strcpy(buffer,toRespXML("Does not exist"));
            // puts("buffer");
            // puts(buffer);
        }
        else if (!strcmp(request->operation,"delreq")){
            puts("delreq");
            if(deleteKey(request->key))
                strcpy(buffer,toRespXML("Success"));
            else
                strcpy(buffer,toRespXML("Does not exist"));
            // puts("buffer");
            // puts(buffer);
        }
        puts("buffer");
        puts(buffer);
        puts(request->ipAddr);
        sendUDP(buffer,request->ipAddr,request->port,false,NULL);
    }else
    {   
        puts("Forward request");
        printf("key id: %d, successor node id: %d\n",id,successorNode.nodeId);
        puts("buffer");
        puts(buffer);
        sendUDPToNode(buffer,successorNode,false,NULL);
        buffer = NULL;
    }
    
    // free(key);
    // free(value);
    // free(operation);
    free(request);
 //   toXMLCache();
}