#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<pthread.h> 
#include<unistd.h> 
#include<stdbool.h>

/////////////////add/////////////////
#define NUMFILES 10
typedef struct Store
{
    pthread_mutex_t* locks; 
}Store;

Store store;

int getFileId(char * key){
    int s=0;
    for (int i = 0; (i < 10)&&(key[i]!='\0'); ++i)
    {
        s+=(int)key[i];
    }
    return s%(NUMFILES);
}
void initStore() {
    //creating locks
    store.locks = (pthread_mutex_t *) malloc(NUMFILES * sizeof(pthread_mutex_t));
    if (store.locks == NULL)
    {
        printf("Cannot create locks\n");
        exit(0);
    }
    for (int i = 0; i < NUMFILES; ++i)
    {
        if (pthread_mutex_init(&store.locks[i], NULL) != 0) 
        { 
            printf("\n mutex init has failed\n"); 
            exit(0);
        } 
    }    

    return;
}
/////////////////add end/////////////////

bool dumpToFile(char* key, char* val){

    /////////////////add/////////////////
    int setNo = getFileId(key);
    printf("ch1 %d",setNo);
    /////////////////add end/////////////////

    char fileName[10];
    char tempfileName[10];
    bool keyExists = false;
    strcpy(tempfileName,"temp");
    sprintf(fileName,"%d",setNo);
    strcat(fileName,".csv");
    strcat(tempfileName,fileName);
    /////////////////add/////////////////
    pthread_mutex_lock(&(store.locks[setNo]));
    /////////////////add end/////////////////

    FILE *fp = fopen(fileName,"r");
    FILE *newFp = fopen(tempfileName,"w");
    char* storedKey = malloc(sizeof(char)*257);
    char* storedVal = malloc(sizeof(char)*256*1024+1);
    // char* storedVal;
    int count=0;
    // while((getc(fp))!=EOF)
	// {
    //     // char buff[1024];
    //     fgets(stored, 256*1024+1, (FILE*)fp);
    //     puts(stored);
    //     storedKey = strtok(storedVal,",");
    //     if(!strcmp(key,storedKey)) {
    //         keyExists = true;
    //         fprintf(newFp,"%s,%s\n",key,val);
    //     }
    //     storedVal = strtok(NULL,",");
    //     // count++;
    //     // if(count != 1)
    //     // {
    //     // // getData(buff);
    //     // }
    //     getch();
	// }
    if (fp!=NULL)
    {
        /* code */
        while(!feof(fp)){
            printf("ch2");

            if(fscanf(fp,"%[^,],%[^\n]\n",storedKey,storedVal) == EOF)
                break;
            if(!strcmp(key,storedKey)) {
                keyExists = true;
                fprintf(newFp,"%s,%s\n",key,val);
            }
            else
                fprintf(newFp,"%s,%s\n",storedKey,storedVal);
        }
    }
    
    if(!keyExists)
        fprintf(newFp,"%s,%s\n",key,val);

    printf("ch3");

    remove(fileName);
    // free(fp);
    rename(tempfileName,fileName);

    /////////////////add/////////////////
    pthread_mutex_unlock(&(store.locks[setNo]));
    /////////////////add end/////////////////

    fclose(newFp);
    free(storedKey);
    free(storedVal);
    return true;
}

//returns false if key doesn't exist in the store//
//TODO:: re-use code of add-key instead of copy-paste
bool deleteStore(char* key) {

    /////////////////add/////////////////
    int setNo = getFileId(key);
    /////////////////add end/////////////////

    char fileName[10];
    char tempfileName[10];
    bool keyExists = false;
    strcpy(tempfileName,"temp");
    sprintf(fileName,"%d",setNo);
    strcat(fileName,".csv");
    strcat(tempfileName,fileName);

    /////////////////add/////////////////
    pthread_mutex_lock(&(store.locks[setNo]));
    /////////////////add end/////////////////

    FILE *fp = fopen(fileName,"r");
    FILE *newFp = fopen(tempfileName,"w");
    char* storedKey = malloc(sizeof(char)*256);
    char* storedVal = malloc(sizeof(char)*256*1024+1);
    if (fp!=NULL)
    {
        while(1){
            if(fscanf(fp,"%[^,],%[^\n]\n",storedKey,storedVal) == EOF)
                break;
            if(!strcmp(key,storedKey)) {
                keyExists = true;
            }else
                fprintf(newFp,"%s,%s\n",storedKey,storedVal);
        }
    }
    

    remove(fileName);
    // free(fp);
    rename(tempfileName,fileName);

    /////////////////add/////////////////
    pthread_mutex_unlock(&(store.locks[setNo]));
    /////////////////add end/////////////////

    fclose(newFp);
    free(storedKey);
    free(storedVal);
    return keyExists;
}

char* restoreFromFile(char* key) {

    /////////////////add/////////////////
    int setNo = getFileId(key);
    /////////////////add end/////////////////
    
    char fileName[10];
    sprintf(fileName,"%d",setNo);
    strcat(fileName,".csv");

    /////////////////add/////////////////
    pthread_mutex_lock(&(store.locks[setNo]));
    /////////////////add end/////////////////

    FILE *fp = fopen(fileName,"r+");
    if(fp==NULL)
        return NULL;
    char* storedKey = malloc(sizeof(char)*256);
    char* storedVal = malloc(sizeof(char)*256*1024+1);
    while(1){
        if(fscanf(fp,"%[^,],%[^\n]\n",storedKey,storedVal) == EOF)
            break;
        if(!strcmp(key,storedKey)) {
            free(storedKey);
            fclose(fp);
            pthread_mutex_unlock(&(store.locks[setNo]));
            return storedVal;
        }
    }

    fclose(fp);
    /////////////////add/////////////////
    pthread_mutex_unlock(&(store.locks[setNo]));
    /////////////////add end/////////////////

    free(storedKey);
    return NULL;
}


void dumpToFileXML(char* filename) {

	FILE *dumpPtr = fopen(filename, "w");
	char *storedKey = malloc(sizeof(char)*257);
	char *storedVal = malloc(sizeof(char)*256*1024+1);
	if(dumpPtr == NULL)
	{
		printf("Cannot open xml file!");
		exit(1);
	}
	fprintf(dumpPtr,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<KVStore>\n");

	for (int i = 0; i < 10; ++i) {
		char fileSet[10];
		sprintf(fileSet,"%d",i);
		strcat(fileSet,".csv");
		FILE *fp = fopen(fileSet,"r+");
		while(1){
			if(fscanf(fp,"%[^,],%[^\n]\n",storedKey,storedVal) == EOF)
				break;
			fprintf(dumpPtr,"<KVPair>\n<Key>%s</Key>\n<Value>%s</Value>\n</KVPair>\n",storedKey,storedVal);
		}
		fclose(fp);
	}
	free(storedKey);
	free(storedVal);
	fprintf(dumpPtr,"</KVStore>");
	fclose(dumpPtr);
}


int iniit() {
    char* key = malloc(sizeof(char)*245);
    char* val = malloc(sizeof(char)*245);
    // dumpToFile(1,"sundaram","shivam4");
    // dumpToFile(1,"key1","val");
    // deleteStore(1,"radium");
    // deleteStore(1,"mr");
    // printf("%s\n",restoreFromFile(1,"sundaram"));
    // printf("%s\n",restoreFromFile(1,"sundaram"));
    if(!restoreFromFile("key12"))
        printf("Not found");
    return 0;
}

// int main(){
//     initStore();
//     dumpToFile("sundaram111","shivam4");
//     dumpToFile("sundaram112","shivam4");
//     dumpToFile("key1","val");
//     printf("%s\n",restoreFromFile("sundaram111"));
//     deleteStore("key1");

// }