#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>   
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <stdbool.h>
#include "threadPool.h"
#include "KVCache.h"
#include "parsexml.h"
#include "kvstore.h"
#include "chord.h"
#include "utils.h"

#define MAX_CLIENTS 20
#define BACKLOG 5
int PORT;

bool startsWith(const char *str, const char *pre)
{
    size_t lenpre = strlen(pre),
           lenstr = strlen(str);
    return lenstr < lenpre ? false : memcmp(pre, str, lenpre) == 0;
}

int main(int argc, char* argv[])
{
    int numSets=16, setSize=4; 
    int num_threads = 5;
    char joinIp[16];
    int joinPort = -1;
    PORT = 8080;
    for (int i = 1; i < argc; ++i)
    {
        if (startsWith(argv[i],"-port="))
        {
            PORT = atoi(argv[i]+6);
        }
        else if (startsWith(argv[i],"-threadPoolSize="))
        {
            num_threads = atoi(argv[i]+16);
        }
        else if (startsWith(argv[i],"-numSetsInCache="))
        {
            numSets = atoi(argv[i]+16);
        }
        else if (startsWith(argv[i],"-sizeOfSet="))
        {
            setSize = atoi(argv[i]+11);
        }
        else if (startsWith(argv[i],"-joinIp="))
        {
            strcpy(joinIp,(argv[i]+8));
        }
        else if (startsWith(argv[i],"-joinPort="))
        {
            joinPort = atoi(argv[i]+10);
        }
    }

    tpool_t* tp   = createThreadPool(num_threads);
    printf("NumSets = %d",numSets);
    char* cacheptr =  buildCache(numSets, setSize);
    initStore();
    int sock_fd, addrlen, msglen, newConnection, client_socket[MAX_CLIENTS], max_sd;
    struct sockaddr_in socketAddr,joinServer,clientAddr;
    puts("getting socket");
    if(joinPort!=-1)
        getSocketFromIpAndPort(joinIp,joinPort,&joinServer);
    getSocketFromIpAndPort("127.0.0.1",PORT,&socketAddr);
    char buffer[257*1024*10];
    fd_set rset;
    memset(client_socket,0,sizeof(int)*MAX_CLIENTS);

    if( (sock_fd = socket(AF_INET , SOCK_DGRAM , 0)) == 0) {
		printf("%s",toRespXML("Network Error: Could not create socket"));
        exit(1);
    }

    // socketAddr.sin_family = AF_INET;
    // socketAddr.sin_addr.s_addr = INADDR_ANY;
    //n socketAddr.sin_port = htons( PORT );
    // memset(&(socketAddr.sin_zero), '\0', 8);
    addrlen = sizeof(struct sockaddr_in);

    if (bind(sock_fd, (struct sockaddr *)&socketAddr, addrlen)<0){
        perror("bind failed");
        exit(1);
    }
    initChordServer(socketAddr);
    // initChordStructure(&joinServer,socketAddr);
    printf("Listening on port %d \n", PORT);

    // if (listen(sock_fd, BACKLOG) < 0) {
    //     perror("listen");
    //     exit(1);
    // }
    // puts("Waiting for connections ...");
    int len, n; 
    while(1) {
        puts("in udp listen");
        n = recvfrom(sock_fd, (char *)buffer, 257*1024,  
                    MSG_WAITALL, ( struct sockaddr *) &clientAddr, 
                    &len); 
        buffer[n] = '\0'; 
        printf("Client : %s\n", buffer); 
        puts(buffer);
        addRequestToQueue(tp,decodeRequestAndProcess,buffer);
    }
    // while(1)
    // {
    //     FD_ZERO(&rset);
    //     FD_SET(sock_fd, &rset);
    //     max_sd = sock_fd;

    //     for (int i = 0 ; i < MAX_CLIENTS ; i++) {
    //         int sd = client_socket[i];

    //         if(sd > 0)
    //             FD_SET( sd , &rset);

    //         if(sd > max_sd)
    //             max_sd = sd;
    //     }

    //     if ( (select(max_sd+1,&rset,NULL,NULL,NULL) < 0) && (errno!=EINTR))
    //         printf("select error");

    //     if (FD_ISSET(sock_fd, &rset)){
    //         newConnection = accept(sock_fd, (struct sockaddr *)&socketAddr, (socklen_t*)&addrlen);
    //         if (newConnection < 0) {
    //             perror("Error during Accept");
    //             exit(1);
    //         }
    //         printf("New connection,socket_fd is %d,ip is:%s,port:%d\n", newConnection,inet_ntoa(socketAddr.sin_addr),ntohs(socketAddr.sin_port));

    //         for (int i=0;i<MAX_CLIENTS;i++) {
    //             if( client_socket[i] == 0 ) {
    //                 client_socket[i] = newConnection;
    //                 printf("Adding to list of sockets as %d\n" , i);
    //                 break;
    //             }
    //         }
    //     }

    //     for (int i = 0; i < MAX_CLIENTS; i++) {
    //         int sd = client_socket[i];
    //         if (FD_ISSET(sd,&rset)) {
    //             if ((msglen = read(sd,buffer,1024*257)) == 0) {
    //                 getpeername(sd , (struct sockaddr*)&socketAddr,(socklen_t*)&addrlen);
    //                 printf("Host disconnected,ip %s,port %d\n",inet_ntoa(socketAddr.sin_addr),ntohs(socketAddr.sin_port));
    //                 close(sd);
    //                 client_socket[i] = 0;
    //             }
    //             else {
    //                 buffer[msglen] = '\0';
    //                 // printf("message recieved\n");
    //                 // printf("%s",buffer);
    //                 puts(buffer);
    //                 addRequestToQueue(tp,decodeRequestAndProcess,buffer,sd);
    //                 /*
    //                 char operation[7],key[257],value[256*1024+1];
    //                 extractXML(buffer,key,value,operation);
    //                 printf("%s\n%s\n%s\n",key,value,operation);
                    

    //                 ThreadPool Here !!
    //                 Call extract from XML procedure to get Operation Type, Key, Value

    //                 */
    //                 // write(sd , buffer , strlen(buffer));
    //             }
    //         }
    //     }
    // }

    return 0;
}