#include <sys/types.h> 
#include <sys/socket.h> 
#include <arpa/inet.h> 
#include <netinet/in.h> 
#include<stdbool.h>

typedef struct Node
{
    int nodeId;
    char ip[16];
    int port;
    struct sockaddr_in socketAddr;
}Node;


typedef struct Chord
{
    Node node;
    Node successor;
    Node predecessor;
    Node *fingerTable[16];
}Chord;

Chord chord;

void sendPredecessor();
void fixFingers();
void printFingerTable();
int keyToId(char * key);
void initChordStructure(struct sockaddr_in *joinNode, struct sockaddr_in sockAddrServer);
Node findSuccessor(int id, bool fixFinger);
void sendUDPToNode(char* msg,Node node, bool recvResponse, char* buffer);
void initChordServer();
void createNodeStruct(Node *givenNode,char ip[16],int port,int id);
void stabilize();
Node getSuccessor();
void sendUDP(char * msg, char ip[], int port, bool recvResponse, char * buffer);