#include<stdlib.h>
#include<stdio.h>
#include<stdbool.h>
#include<string.h>
#include <unistd.h> 
#include <string.h> 
#include <sys/types.h> 
#include <sys/socket.h> 
#include <arpa/inet.h> 
#include <netinet/in.h> 
#include <openssl/md5.h>
#include "parsexml.h"
#include "utils.h"
#include <math.h>
#include "chord.h"
#include <pthread.h>

#define MAXLOCATIONS 16
#define MAXIDVALUE 65536

int keyToId(char * key){
    unsigned char digest[16];
    MD5_CTX context;
    MD5_Init(&context);
    MD5_Update(&context, key, strlen(key));
    MD5_Final(digest, &context);
    int intHashValue;
    int first8bits = digest[0];
    first8bits = first8bits<<8;
    intHashValue = first8bits + digest[1];
    return intHashValue;
}

int nodeToId(struct sockaddr_in *socketAddr){
    char *ip;
    char port[6];
    int portNumber = socketAddr->sin_port;
    ip = inet_ntoa(socketAddr->sin_addr);
    int id = (keyToId(ip)+portNumber)%(MAXIDVALUE);
    return id;
}



void sendUDP(char * msg, char ip[], int port, bool recvResponse, char * buffer)
{
    int sockfd;
    struct sockaddr_in     servaddr; 
  
    // Creating socket file descriptor 
    if ( (sockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0 ) { 
        perror("socket creation failed"); 
        exit(EXIT_FAILURE); 
    } 
    memset(&servaddr, 0, sizeof(servaddr)); 
      
    // Filling server information 
    servaddr.sin_family = AF_INET; 
    servaddr.sin_port = htons(port); 
    servaddr.sin_addr.s_addr = inet_addr(ip); 
      
    int n, len; 
      
    sendto(sockfd, (const char *)msg, strlen(msg), 
        MSG_CONFIRM, (const struct sockaddr *) &servaddr,  
            sizeof(servaddr)); 
    
    if (recvResponse)
    {
        n = recvfrom(sockfd, (char *)buffer, 1000,  
                MSG_WAITALL, (struct sockaddr *) &servaddr, 
                &len); 
        buffer[n] = '\0'; 
    }
    
    close(sockfd);
}

void sendUDPToNode(char* msg,Node node, bool recvResponse, char* buffer) {
    int sockfd;
    // Creating socket file descriptor 
    if ( (sockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0 ) { 
        perror("socket creation failed"); 
        exit(EXIT_FAILURE); 
    }
    int n, len; 
      
    sendto(sockfd, (const char *)msg, strlen(msg), 
        MSG_CONFIRM, (const struct sockaddr *) &node.socketAddr,  
            sizeof(node.socketAddr)); 
    
    if (recvResponse)
    {
        n = recvfrom(sockfd, (char *)buffer, 1000,  
                MSG_WAITALL, (struct sockaddr *) &node.socketAddr, 
                &len); 
        buffer[n] = '\0'; 
    }
    close(sockfd);
}

int compareTwoNodes(const void *a, const void *b) 
{   
    int first = ((Node *)a)->nodeId;
    int second = ((Node *)b)->nodeId;
    return first > second; 
} 
  
void sortNodes(Node a[], int n) 
{   
    qsort(a,n,sizeof(Node), compareTwoNodes); 
}
Node getSuccessor(int id, Node allNodes[],int size) {
    int i;
    for(i = size-1; i >=0; i--) {
        if(allNodes[i].nodeId<id)
            break;
    }
    if(i==size-1)
        return allNodes[0];
    return allNodes[i+1];
}
void setSuccessorAndPredecessor(Node allNodes[],int size) {
    int i = 0;
    for(i = 0; i<size; i++) {
        if(chord.node.nodeId==allNodes[i].nodeId)
            break;
    }
    if(i==0){
        chord.predecessor = allNodes[size-1];
    }else{
        chord.predecessor = allNodes[i-1];
    }
    if(i == size -1) {
        chord.successor = allNodes[0];
    }else {
        chord.successor = allNodes[i+1];
    }
}

void *periodicStabilize(void *arg) {
    while(1) {
        stabilize();
        sleep(5);
    }
}

void stabilize() {
    FILE *configFile = fopen(".chordConfig","r");
    Node currNodes[100];
    char ip[16];
    int port,id;
    int i = 0;
    while(fscanf(configFile,"%s %d %d\n",ip,&port,&id)!=EOF){
        createNodeStruct(&currNodes[i],ip,port,id);
        i++;
    }
    fclose(configFile);
    sortNodes(currNodes,i);
    setSuccessorAndPredecessor(currNodes,i);
    // system("clear");
    // printf("node-id: %d,successor: %d, pred: %d\n",chord.node.nodeId,chord.successor.nodeId,chord.predecessor.nodeId);
    fixFingers(currNodes,i);
    // printFingerTable();
}

void initChordServer(sockaddr_t serverAddr) {
    pthread_t stabilizer;
    pthread_create(&stabilizer,NULL,periodicStabilize,NULL);
    pthread_detach(stabilizer);
    FILE *configFile = fopen(".chordConfig","a");
    chord.node.socketAddr = serverAddr;
    chord.node.nodeId = nodeToId(&chord.node.socketAddr);
    int id = nodeToId(&serverAddr);
    fprintf(configFile,"%s %d %d\n",inet_ntoa(serverAddr.sin_addr),ntohs(serverAddr.sin_port),id);
    fclose(configFile);
    stabilize();
    // char ip[16];
    // int port;
    // configFile = fopen(".chordConfig","r");
    // Node currNodes[100];
    // int i = 0;
    // while(fscanf(configFile,"%s %d %d\n",ip,&port,&id)!=EOF){
    //     createNodeStruct(&currNodes[i],ip,port,id);
    //     i++;
    // }
    // fclose(configFile);
    // sortNodes(currNodes,i);
    // setSuccessorAndPredecessor(currNodes,i);
    // printf("successor: %d, pred: %d\n",chord.successor.nodeId,chord.predecessor.nodeId);
    // fixFingers(currNodes,i);
    // printFingerTable();
}

void createNodeStruct(Node *givenNode,char ip[16],int port,int id) {
    sockaddr_t sockAddr;
    getSocketFromIpAndPort(ip,port,&sockAddr);
    givenNode->socketAddr = sockAddr;
    givenNode->nodeId = id;
    strcpy(givenNode->ip,ip);
    givenNode->port = port;
}

void initChordStructure(struct sockaddr_in *joinNode,sockaddr_t socketAddrServer){
    chord.node.socketAddr = socketAddrServer;
    chord.node.nodeId = nodeToId(&chord.node.socketAddr);
    printf("node Id: %d",chord.node.nodeId);
    chord.predecessor.nodeId = 0;
    if (joinNode == NULL)
    {
        chord.successor = chord.node;
    }
    else
    {
        /* send find successor packet to the ip */
        // Listen for reply 
        // update successor
    }
    // fixFingers();
    printFingerTable();
}



Node closestPreceedingNode(int id){
    int m= MAXLOCATIONS;
    Node* f=chord.fingerTable[0];
    for (int i = m-1; i >=0; i--)
    {        
        int nextId = chord.fingerTable[i]->nodeId;
        printf("nextid: %d\n",nextId);
        if (nextId>chord.node.nodeId && nextId<=id)
        {
            return *chord.fingerTable[i];
        }
        /// To handle edge case
        if(chord.node.nodeId<chord.predecessor.nodeId)   
            return chord.node;
        else if(chord.node.nodeId>chord.successor.nodeId)
                return chord.successor;
    }
    // strcpy(ip,f[0].ip); //????
}

Node findSuccessor(int id, bool fixFinger){
    printf("successor: %d, pred: %d",chord.successor.nodeId,chord.predecessor.nodeId);
    printFingerTable();
    if(chord.predecessor.nodeId == chord.node.nodeId) {
        return chord.node;
    }else if(id<=chord.node.nodeId && id > chord.predecessor.nodeId)
            return chord.node;
    if (id>chord.node.nodeId && id<=chord.successor.nodeId)
    {
        return chord.successor;                    
    }
    else
    {
        Node preceedingNode = closestPreceedingNode(id);
        if(fixFinger){
            char *msg ,buffer[1000];
            char idString[4];
            sprintf(idString,"%d",id);
            // msg = toXML("find_successor",idString,NULL);
            puts(msg);
            //make_packet and send
            sendUDPToNode(msg,preceedingNode,true,buffer);
            //
        }
        printf("Returning preceeding node : %d",preceedingNode.nodeId);
        return preceedingNode;
    }
        
}

// void sendPredecessor(char ip[], int port){
//     int sockfd; 
//     char msg[1000];
//     ToXML(msg,ip,port);//TO be changed
//     sendUDP(msg,ip,port,false,NULL);
// }

// void stabilize(){
//     char msg[1000],buffer[1000];
//     sendUDP(msg,chord.successorIp,chord.successorPort,true,buffer);
// }

void fixFingers(Node allNodes[],int size){
    for(int i = 0; i<16; i++) {
        if(chord.fingerTable[i]==NULL)
            chord.fingerTable[i] = malloc(sizeof(Node));
        Node newNode =  getSuccessor((chord.node.nodeId + (int)pow(2,i)) % MAXIDVALUE,allNodes,size);
        chord.fingerTable[i]->socketAddr = newNode.socketAddr;
        chord.fingerTable[i]->nodeId = newNode.nodeId;
        strcpy(chord.fingerTable[i]->ip,newNode.ip);
        chord.fingerTable[i]->port = newNode.port;
    }
}

void printFingerTable() {
    printf("Entry\tID\n");
    for(int i = 0; i<16; i++) {
        int j = pow(2,i);
        if(chord.fingerTable[i] == NULL)
            continue;
        Node curNode = *(chord.fingerTable[i]);
        printf("N+%d\t%d\n",j,curNode.nodeId);
    }
}
// int main() {
//     initChordStructure(NULL);
//     findSuccessor(123,true);
// }
