#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<pthread.h> 
#include<unistd.h> 
#include"KVCache.h"
#include"kvstore.h"

// 256+1 for key
// 256*1024+1 for value
// 1 for valid
// 1 for replacement

// cache line structure
// [round-robin last][valid bit*setSize][referenced bit*setSize][blocks..]

typedef struct Cache
{
	int numSets;
	int setSize;
	char * cacheptr;
	pthread_mutex_t* locks;	
}Cache;

Cache cache;

int getSetId(char * key){
	int s=0;
	for (int i = 0; (i < 10)&&(key[i]!='\0'); ++i)
	{
		s+=(int)key[i];
	}
	return s%(cache.numSets);
}

char* buildCache(int numSets, int setSize) {
	char* cacheptr;
	cacheptr = (char *)calloc((BLOCKINFO + BLOCKSIZE)*numSets*setSize + numSets, sizeof(char));
	if (cacheptr==NULL)
	{
		printf("Not enought memory for cache\n");
		exit(0);
	}
	cache.numSets = numSets;
	cache.setSize = setSize;
	cache.cacheptr = cacheptr;

	//creating locks
	cache.locks = (pthread_mutex_t *) malloc(numSets * sizeof(pthread_mutex_t));
	if (cache.locks == NULL)
	{
		printf("Cannot create locks\n");
		exit(0);
	}
	for (int i = 0; i < setSize; ++i)
	{
		if (pthread_mutex_init(&cache.locks[i], NULL) != 0) 
	    { 
	        printf("\n mutex init has failed\n"); 
	        exit(0);
	    } 
	}
	

	return cacheptr;
}

char * searchCache(int setNo, char* key, int* idx) {
	int success = 0;	
	char * cacheptr = cache.cacheptr;
	int startIdx = ((BLOCKINFO + BLOCKSIZE)*cache.setSize + 1 )*setNo;
	char * startptr = cache.cacheptr + startIdx + 1;
	char * blockptr = startptr + 2*cache.setSize;

	for (int i = 0; i < cache.setSize; ++i)
	{
		if (startptr[i]==1)
		{
			if(strcmp(key,blockptr+(i)*BLOCKSIZE)==0) {
				startptr[cache.setSize+i] = (char)1;
				*idx = i;
				return blockptr+(i)*BLOCKSIZE + 257;
			}
		}
	}
	return NULL;
}

char* secondChance(int setNo) {
	char * cacheptr = cache.cacheptr;
	int startIdx = ((BLOCKINFO + BLOCKSIZE)*cache.setSize + 1 )*setNo;
	char * startptr = cache.cacheptr + startIdx;
	int nextReplace = (int)startptr[0];
	char* refBits = startptr+cache.setSize+1;
	while(((int)refBits[nextReplace])!=0) {
		refBits[nextReplace] = (char) 0;
		nextReplace++;
		if (nextReplace>=cache.setSize)
		{
			nextReplace = 0;
		}
	}
	char* retBlock = startptr + 1 + BLOCKINFO*cache.setSize + BLOCKSIZE*nextReplace; 
	refBits[nextReplace] = (char)1;
	startptr[1+nextReplace] = (char)1;
	nextReplace++;
	if (nextReplace>=cache.setSize)
	{
		nextReplace = 0;
	}
	startptr[0] = (char)nextReplace;
	return retBlock;
}

void addCache(int setNo, char* key, char* value, char* blockValue) {
	if (blockValue!=NULL)
	{
		strcpy(blockValue, value);
	}
	else
	{
		char* block = secondChance(setNo);
		strcpy(block, key);
		strcpy(block+257, value);
	}
}

void deleteCache(int setNo, char* key) {
	int idx;
	char * blockValue = searchCache(setNo, key, &idx);
	if (blockValue!=NULL)
	{
		char * cacheptr = cache.cacheptr;
		int startIdx = ((BLOCKINFO + BLOCKSIZE)*cache.setSize + 1 )*setNo;
		char * startptr = cache.cacheptr + startIdx;
		startptr[1+idx] = (int)0;
		startptr[idx+cache.setSize] = (int)0;
	}
}

bool searchKey(char* key, char* value) {
	int idx;
	bool success = false;
	int setNo = getSetId(key);
	pthread_mutex_lock(&(cache.locks[setNo]));
	char* ret = searchCache(setNo, key, &idx);
	
	if (ret!=NULL) {
		// Maybe should copy the string 'value' to another location
		strcpy(value,ret);
		pthread_mutex_unlock(&(cache.locks[setNo]));
		success = true;
		// return value;
	}
	else {
		ret = restoreFromFile(key);
		if (ret!=NULL) {   
			strcpy(value,ret);
			addCache(setNo, key, value, NULL);
			success = true;
		}
		
		pthread_mutex_unlock(&(cache.locks[setNo]));
	}
	return success;
}

void addKey(char* key, char* value) {
	int idx;
	int setNo = getSetId(key);
	pthread_mutex_lock(&(cache.locks[setNo]));
	char * blockValue = searchCache(setNo,key, &idx);
	addCache(setNo, key, value, blockValue);
	dumpToFile(key, value);
	pthread_mutex_unlock(&(cache.locks[setNo]));
}

bool deleteKey(char* key) {
	int setNo = getSetId(key);
	bool success;
	pthread_mutex_lock(&(cache.locks[setNo]));
	deleteCache(setNo, key);
	success = deleteStore(key);
	pthread_mutex_unlock(&(cache.locks[setNo]));
	return success;
}

void toXMLCache() {
	char* cacheptr = cache.cacheptr;
	char* info = cacheptr+1;
	char* blockptr = info+2*cache.setSize;
	FILE *fptr;
	fptr = fopen("cache.xml", "w+");
	if(fptr == NULL)
	{
		printf("Cannot open xml file!");
		exit(1);
	}
	fprintf(fptr,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<KVCache>\n");

	for (int i = 0; i <cache.numSets; ++i)
	{
		char* refInfo = info+cache.setSize;
		fprintf(fptr,"\t<Set Id=\"%d\">\n", i);
		for (int j = 0; j < cache.setSize; ++j)
		{
			fprintf(fptr,"\t\t<CacheEntry isReferenced=\"");
			if (((int)refInfo[j])==0)
			{
				fprintf(fptr,"false\" isValid=\"​");
			}
			else
			{
				fprintf(fptr,"true\" isValid=\"​");
			}
			if (((int)info[j])==0)
			{
				fprintf(fptr,"false\">\n");
				fprintf(fptr, "\t\t\t<Key></Key>\n");
				fprintf(fptr, "\t\t\t<Value></Value>\n");
			}
			else
			{
				fprintf(fptr,"true\">\n");
				fprintf(fptr, "\t\t\t<Key>%s</Key>\n",blockptr);
				fprintf(fptr, "\t\t\t<Value>%s</Value>\n",blockptr+257);
			}
			
			fprintf(fptr,"\t\t</CacheEntry>\n");
			blockptr = blockptr + BLOCKSIZE;
		}
		fprintf(fptr,"\t</Set>\n");
		info = info+cache.setSize*(BLOCKSIZE+BLOCKINFO)+1;
		blockptr = info+2*cache.setSize;
	}
	fprintf(fptr,"</KVCache>\n");
	fclose(fptr);
}


// int main()
// {
	// char k1[]="key1";
	// char v1[]="value1";
	// char k2[]="jkey2";
	// char v2[]="value2";
	// char k3[]="key3";
	// char v3[]="value3";
	// char* cacheptr =  buildCache(6, 2);
	// addKey(k1,v1);
	// addKey(k2,v2);
	// // printf("addk\n");
	// printf("s1:%s\n",searchKey(k1));
	// printf("s12:%s\n",searchKey(k2));
	// addKey(k3,v3);
	// printf("s12:%s\n",searchKey(k1));
	// printf("s12:%s\n",searchKey(k2));
	// printf("s12:%s\n",searchKey(k3));
	// // printf("searchCache\n");
	
	// printf("s2:%s\n",searchKey(v1));
	// // printf("sea2\n");
	// deleteKey(k1);
	// deleteKey(k2);
	// deleteKey(k3);
	// deleteKey(v1);
	// toXML();
	// printf("s3:%s\n",searchKey(k1));
// 	printf("%d",getSetId("abcd"));
// 	printf("%d",getSetId("abcdesaf"));
// 	printf("%d",getSetId("bcesaf"));
// 	return 0;
// }