
// Server side implementation of UDP client-server model 
#include <stdio.h> 
#include <stdlib.h> 
#include <unistd.h> 
#include <string.h> 
#include <sys/types.h> 
#include <sys/socket.h> 
#include <arpa/inet.h> 
#include <netinet/in.h> 
#include "parsexml.h"

// #define PORT     8080 
#define MAXLINE 1024 
  
// Driver code 
int main(int argc, char * argv[]) { 
    int sockfd; 
    char buffer[MAXLINE]; 
    char *hello = "Message<?xml version=\"1.0\" encoding=\"UTF-8\"?>\
<KVMessage type=\"abc\">\
<Key>cdefg</Key>\
<Address>111.111.111.111 12345</Address>\
</KVMessage>"; 
    struct sockaddr_in servaddr, cliaddr, nextserv; 
      
    // Creating socket file descriptor 
    if ( (sockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0 ) { 
        perror("socket creation failed"); 
        exit(EXIT_FAILURE); 
    } 
      
    memset(&servaddr, 0, sizeof(servaddr)); 
    memset(&nextserv,0,sizeof(nextserv));
    memset(&cliaddr, 0, sizeof(cliaddr)); 
      
    // Filling server information 
    servaddr.sin_family    = AF_INET; // IPv4 
    servaddr.sin_addr.s_addr = INADDR_ANY; 
    servaddr.sin_port = htons(atoi(argv[1])); 
      
    // Bind the socket with the server address 
    if ( bind(sockfd, (const struct sockaddr *)&servaddr,  
            sizeof(servaddr)) < 0 ) 
    { 
        perror("bind failed"); 
        exit(EXIT_FAILURE); 
    } 
      
    int len, n; 
    n = recvfrom(sockfd, (char *)buffer, MAXLINE,  
                MSG_WAITALL, ( struct sockaddr *) &cliaddr, 
                &len); 
    buffer[n] = '\0'; 
    printf("Client : %s\n", buffer); 

    if (argc>=3)
    {
        cliaddr.sin_family    = AF_INET; // IPv4 
        cliaddr.sin_addr.s_addr = INADDR_ANY; 
        cliaddr.sin_port = htons(atoi(argv[2])); 

        sendto(sockfd, (const char *)buffer, strlen(buffer),  
            MSG_CONFIRM, (const struct sockaddr *) &cliaddr, 
                len); 
        /* code */
    }
    else
    {

        extReq_t *req = extractXML(buffer);
        cliaddr.sin_family    = AF_INET; // IPv4 
        cliaddr.sin_addr.s_addr = inet_addr(req->ipAddr); 
        cliaddr.sin_port = htons(req->port); 

        puts(req->ipAddr);
        printf("%d",req->port);extReq_t *extractXML(char *buffer);
        sendto(sockfd, (const char *)hello, strlen(hello),  
            MSG_CONFIRM, (const struct sockaddr *) &cliaddr, 
                len);
    }
    
    printf("Hello message sent.\n");  
      
    return 0; 
} 
