#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <stdbool.h>
#include<unistd.h>
#include "parsexml.h"

char *toRespXML(char* msg){

	char *line1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<KVMessage type=\"resp\">\n<Message>";
	char *line2 = "</Message>\n</KVMessage>\n";
	int msglen = strlen(line1)+strlen(line2)+strlen(msg)+1;
	char *message = (char *)malloc(sizeof(char)*msglen);
	strcpy(message,line1);
	strcat(message,msg);
	strcat(message,line2);
	// puts("message");
	// puts(msg);
	return message;

}

char * toXML(char *reqType, char *key, char * value, char * ip, int port){
	
	char *line1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
	char *line21 = "<KVMessage type=\"";
	char *line22 = "\">\n";
	char *line31 = "<Key>";
	char *line32 = "</Key>\n";
	char *line41 = "<Value>";
	char *line42 = "</Value>\n";
	char *line61 = "<Address>";
	char *line62 = "</Address>\n";
	char *line5 = "</KVMessage>\n";
	char *line6;
	int len2 = strlen(line21)+strlen(line22)+strlen(reqType)+1;
	int len3 = strlen(line31)+strlen(line32)+strlen(key)+1;
	int len4 = strlen(line41)+strlen(line42)+strlen(value)+1;
	int len6 = strlen(line61)+strlen(line62)+21;

	char *line2 = (char *)malloc(sizeof(char) * len2);
	char *line3 = (char *)malloc(sizeof(char) * len3);
	char *line4 = (char *)malloc(sizeof(char) * len4);

	strcpy(line2,line21);
	strcat(line2,reqType);
	strcat(line2,line22);	

	strcpy(line3,line31);
	strcat(line3,key);
	strcat(line3,line32);

	strcpy(line4,line41);
	strcat(line4,value);
	strcat(line4,line42);

	int msglen = strlen(line1)+strlen(line2)+strlen(line3)+strlen(line4)+strlen(line5)+1;
	if (ip!=NULL)
	{	
		char str[7];
		sprintf(str, " %d", port);
		line6 = (char *)malloc(sizeof(char) * len6);
		strcpy(line6,line61);
		strcat(line6,ip);
		strcat(line6, str);
		strcat(line6,line62);
		msglen +=strlen(line6); 
	}
	

	char *message = (char *)malloc(sizeof(char) * msglen);

	strcpy(message,line1);
	strcat(message,line2);
	strcat(message,line3);
	

	if(!strcmp(reqType,"putreq") || !strcmp(reqType,"resp"))
		strcat(message,line4);
	if (ip!=NULL)
	{
		strcat(message,line6);
		free(line6);
	}

	strcat(message,line5);
	free(line2);free(line3);free(line4);

	printf("Message%s",message);
	return message;

}

char *extractRespXml(FILE *fp,char *buffer){
	char *p,*q,*err;
	char *key;
	char *value;
	p = strstr(buffer, "<Key>")+5;
	q = strstr(buffer, "</Key>");
	if(p!=NULL && q!=NULL){
		key = malloc(sizeof(char)*(q-p+1));
		memcpy(key,p,q-p);
		key[q-p] = '\0';
		p = strstr(buffer, "<Value>")+ 7;
		q = strstr(buffer, "</Value>");
		if(p!=NULL && q!=NULL){
			value = malloc(sizeof(char)*(q-p+1));
			memcpy(value,p,q-p);
			value[q-p] = '\0';
		}
		fprintf(fp,"%s,%s\n",key,value);
		free(key);
		free(value);
	}
	else {
		p = strstr(buffer, "<Message>")+ 9;
		q = strstr(buffer, "</Message>");
		char *message = (char *)malloc(sizeof(char)*170);
		if(p!=NULL && q!=NULL){
			memcpy(message,p,q-p);
			if(!strcmp(message,"Success")){
				fprintf(fp,"Success\n");
			} else {
				fprintf(fp,"Error,%s\n",message);
			}
		}
		free(message);
	}
}


extReq_t *extractXML(char *buffer){
	extReq_t *req;
	req = malloc(sizeof(extReq_t));
	char *p,*q;
	req->operation = malloc(sizeof(char)*12);
	req->err = malloc(sizeof(char)*170);
	req->val = malloc(sizeof(char)*256*1024+1); 
	req->error=true;
	p = strstr(buffer, "type=")+ 6;
	q = strstr(buffer, "\">");
	if(p==NULL || q==NULL) {
		strcpy(req->err,"XML Error: Received unparseable message");
		return req;
	}
	else
		memcpy(req->operation,p,q-p);

	p = strstr(buffer, "<Key>")+5;
	q = strstr(buffer, "</Key>");
	if(p==NULL || q==NULL){
		strcpy(req->err,"XML Error: Received unparseable message");
		return req;
	}
	else if (q-p > 257) {
		strcpy(req->err ,"Oversized key");
		return req;
	}
	else {
		req->key = malloc(sizeof(char)*(q-p+1));
		memcpy(req->key,p,q-p);
		req->key[q-p] = '\0';
	}
	if(!strcmp(req->operation,"putreq")) {
		p = strstr(buffer, "<Value>")+ 7;
		q = strstr(buffer, "</Value>");
		if(p==NULL || q==NULL) {
			strcpy(req->err,"XML Error: Received unparseable message");
			return req;
		}
		else if (q-p>1024*257+2) {
			strcpy(req->err,"Oversized value");
			return req;
		}
		else{
			req->val = realloc(req->val,sizeof(char)*(q-p+1));
			memcpy(req->val,p,q-p);
			req->val[q-p] = '\0';
		}
	}

	p = strstr(buffer, "<Address>")+9;
	q = strstr(buffer, "</Address>");
	if(p!=NULL && q!=NULL){
		strcpy(req->ipAddr,strtok(p, " "));
		int l = strlen(req->ipAddr); 
		printf("ip:%s",req->ipAddr);
		char port_s[6];
		memcpy(port_s,p+l+1,q-p-l-1);
		port_s[q-p-l-1] = '\0';
		req->port = atoi(port_s);

	}
	req->error = false;
	return req;

}



// void main(){
// 	extReq_t *request = extractXML(toXML("abc","cdefg","123","111.111.111.111",12345));
// 	printf("Parsed msg:%s %d",request->ipAddr,request->port);
// }