#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <unistd.h>
#include "parsexml.h"
#include <arpa/inet.h> 
#include <netinet/in.h> 

#define PORT 6089

void sendUDP(char * msg, char ip[], int port, bool recvResponse, char * buffer, int src_port)
{
    int sockfd;
    struct sockaddr_in servaddr,srcaddr; 
  
    // Creating socket file descriptor 
    if ( (sockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0 ) { 
        perror("socket creation failed"); 
        exit(EXIT_FAILURE); 
    } 
  
    memset(&servaddr, 0, sizeof(servaddr)); 
      
    // Filling server information 
    servaddr.sin_family = AF_INET; 
    servaddr.sin_port = htons(port); 
    servaddr.sin_addr.s_addr = inet_addr(ip); 
      
    int n, len; 

	memset(&srcaddr, 0, sizeof(srcaddr));
    srcaddr.sin_family = AF_INET;
    srcaddr.sin_port = htons(src_port);
    srcaddr.sin_addr.s_addr = INADDR_ANY;

    if (bind(sockfd, (struct sockaddr *) &srcaddr, sizeof(srcaddr)) < 0) {
        perror("bind");
        exit(1);
    }
      
    sendto(sockfd, (const char *)msg, strlen(msg), 
        MSG_CONFIRM, (const struct sockaddr *) &servaddr,  
            sizeof(servaddr)); 
    
    if (recvResponse)
    {
        n = recvfrom(sockfd, (char *)buffer, 257*1024,  
                MSG_WAITALL, (struct sockaddr *) &servaddr, 
                &len); 
        buffer[n] = '\0'; 
    }
    
    close(sockfd);
}


int main(int argc, char** argv)
{
	int sock_fd, addrlen, msglen; 

	struct sockaddr_in clientAddr, *result;
	char key[258],value[256*1024+2],buffer[257*1024],*message,*err;
	char *operation = (char *)malloc(sizeof(char)*7);


	// if( (sock_fd = socket(AF_INET , SOCK_STREAM , 0)) == 0) {   //Connection oriented Socket, choose protocol automatically (0)
		
	// 	printf("%s",toRespXML("Network Error: Could not create socket"));
	// 	exit(1);
	// } 

	// clientAddr.sin_family = AF_INET;
	// clientAddr.sin_port = htons(PORT);
	// clientAddr.sin_addr.s_addr = INADDR_ANY; //inet_addr("localhost");// inet_aton("localhost",&(clientAddr.sin_addr));
	// memset(&(clientAddr.sin_zero), '\0', 8); 
    // addrlen = sizeof(struct sockaddr_in);   

	// if(	connect(sock_fd, (struct sockaddr *)&clientAddr, addrlen)<0) {  
	// 	printf("%s",toRespXML("Network Error: Could not connect"));
	// 	exit(1);
	// } 

	FILE *fp;
	int src_port = 30000;
	// puts(argc);
	if (argc >= 2){
        src_port=atoi(argv[1]);
		// write(1,src_port,5);
    }
    if (argc >= 3){
        fp = fopen(argv[2], "r");
        if (fp==NULL){
            printf("ERROR:File doesn't exist\n");
            return -1;
        }
    }
	FILE *outFp;
	if(argc>=4)
		outFp = fopen(argv[3],"w+");
	while(1){
		// batch mode
		if(argc >= 3) { 
			if(fscanf(fp,"%[^,],",operation)==EOF)
				break;
			if(!strcmp(operation,"put") || !strcmp(operation,"PUT"))
				fscanf(fp,"%[^,],%[^\n]\n",key,value);
			else
				fscanf(fp,"%[^\n]\n",key);
			// printf("%s,%s,%s\n",operation,key,value);

			if(!strcmp(operation,"get") || !strcmp(operation,"GET"))
				strcpy(operation,"getreq");
			else if(!strcmp(operation,"put") || !strcmp(operation,"PUT"))
				strcpy(operation,"putreq");
			else if(!strcmp(operation,"del") || !strcmp(operation,"DEL"))
				strcpy(operation,"delreq");
			else {
				printf("Invalid Choice, Please try again\n");
				continue;
			}

			message = toXML(operation,key,value,"127.0.0.1",src_port);
			// write(sock_fd, message, strlen(message));
			// msglen = read(sock_fd, buffer, 257*1024);
			// buffer[msglen] = '\0';
			sendUDP(message, "localhost", PORT, true,buffer,src_port);
			extractRespXml(outFp,buffer);
			if(argc>=5)
				if(!strcmp(argv[3],"-p"))
					puts(buffer);
		} 
		// Interactive mode
		else {
			printf("Enter operation\n GET\tPUT\tDEL\n");
			scanf("%s",operation);
			if(!strcmp(operation,"get") || !strcmp(operation,"GET")){
				printf("Enter Key\n");
				strcpy(operation,"getreq");
				scanf("%s",key);
			} else if(!strcmp(operation,"put") || !strcmp(operation,"PUT")){
				printf("Enter Key and Value\n");
				strcpy(operation,"putreq");
				scanf("%s",key);
				getchar();
				scanf("%[^\n]s",value);
			} else if(!strcmp(operation,"del") || !strcmp(operation,"DEL")){
				printf("Enter Key\n");
				strcpy(operation,"delreq");
				scanf("%s",key);			
			} else {
				printf("Invalid Choice, Please try again\n");
				continue;
			}

			// message = toXML(operation,key,value);
			// write(sock_fd, message, strlen(message));

			// msglen = read(sock_fd, buffer, 257*1024);
			// buffer[msglen] = '\0';
			message = toXML(operation,key,value,"127.0.0.1",src_port);
			sendUDP(message, "127.0.0.1", PORT, true,buffer,src_port);
			puts(buffer);
		}
	}
	fclose(outFp);
	return 0;
}
