import { Component, OnInit } from '@angular/core';
import { User } from '../user';
declare var Chart: any;

@Component({
  selector: 'app-user',
  templateUrl: './user.component.html',
  styleUrls: ['./user.component.scss']
})
export class UserComponent implements OnInit {

  user: User;
  loggedIn: boolean;
  hist: number[] = [];
  timeline: number[];

  constructor() { }

  ngOnInit(): void {

    (() => {
      this.timeline = JSON.parse(this.user.correct_timeline);
      let sum = 0;
      this.timeline.forEach(element => {
        sum += element;
        this.hist.push(sum);
      });
    })();

    Chart.defaults.global.defaultFontFamily = 'Lato';
    Chart.defaults.global.defaultFontColor = '#888';

    var ctx = (document.getElementById('myChart') as HTMLCanvasElement).getContext('2d');

    let myChart = new Chart(ctx, {
      type: 'line',
      data: {
        labels: Array.from(this.timeline.keys()),
        datasets: [{
          label: 'Total Accepted',
          data: this.hist,
          fill: true,
          backgroundColor: '#0f08'
        },
        {
          label: 'Total Incorrect',
          data: Array.from(this.timeline.keys()),
          fill: true,
          backgroundColor: '#f008'
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        elements: {
          point: {
            radius: 0
          }
        },
        layout: {
          padding: {
            bottom: -10,
            left: -10
          }
        },
        legend: {
          labels: {
            fontSize: 15
          }
        },
        scales: {
          xAxes: [{
            ticks: {
              display: false
            },
            gridLines: {
              color: 'transparent'
            }
          }],
          yAxes: [{
            ticks: {
              display: false
            },
            gridLines: {
              color: 'transparent'
            }
          }]
        }
      }
    });
  }

}
