import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { Router } from '@angular/router';

@Component({
  selector: 'app-register',
  templateUrl: './register.component.html',
  styleUrls: ['./register.component.scss']
})
export class RegisterComponent implements OnInit {
  form: FormGroup;
  timeout: any;

  constructor(private fb: FormBuilder, private router: Router) {
    this.form = this.fb.group({
      name: new FormControl('', [Validators.required, Validators.minLength(1), Validators.maxLength(50)]),
      username: new FormControl('', [Validators.required, Validators.minLength(5), Validators.maxLength(50), Validators.pattern(/^[a-zA-Z0-9_]+$/)]),
      email: new FormControl('', [Validators.required, Validators.pattern(/^\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/)]),
      password: new FormControl('', [Validators.required, Validators.minLength(8)]),
      confirm_password: new FormControl('', [Validators.required, Validators.minLength(8)])
    });
  }

  set: NodeListOf<HTMLInputElement>;
  submit_element: HTMLInputElement;

  ngOnInit(): void {
    this.submit_element = document.getElementById('submit') as HTMLInputElement;
    this.set = document.querySelectorAll('input:not([type=submit])');
    this.set.forEach(function (item) {
      item.addEventListener('focus', function () {
        item.parentElement.querySelector('label').classList.add('active');
      });
      item.addEventListener('blur', function () {
        if (item.value == "")
          item.parentElement.querySelector('label').classList.remove('active');
      });
    })
  }

  updateLabels() {
    this.set.forEach(function (item) {
      if (item.value !== "" && item.value !== null)
        item.parentElement.querySelector('label').classList.add('active');
      else
        item.parentElement.querySelector('label').classList.remove('active');
    });
  }

  postData(frm: any) {

    if (this.submit_element.classList.contains('disabled')) return;
    this.submit_element.classList.add('disabled');

    if (this.form.get('name').invalid) {
      this.error("Invalid name. Please keep it 1 to 50 characters long.");
      return;
    } else if (this.form.get('username').invalid) {
      this.error("Invalid username. Please keep it 5 to 50 characters long with only alphanumeric characters and underscores.");
      return;
    } else if (this.form.get('email').invalid) {
      this.error("Invalid email address. Please recheck.");
      return;
    } else if (this.form.get('password').invalid || this.form.get('confirm_password').invalid) {
      this.error("Invalid password or the passwords don't match. Please keep the password at least 8 characters long.");
      this.form.get('password').setValue('');
      this.form.get('confirm_password').setValue('');
      return;
    } else if (this.form.get('password').value != this.form.get('confirm_password').value) {
      this.error("Passwords don't match. Please recheck.");
      this.form.get('password').setValue('');
      this.form.get('confirm_password').setValue('');
      return;
    }

    //submit...

  }

  error(str: string) {
    let co = (document.getElementById('cover') as HTMLDivElement);
    let pu = (document.getElementById('error') as HTMLDivElement);
    pu.querySelector('.desc').innerHTML = str;

    co.querySelectorAll('.popup').forEach(function (item) {
      item.classList.remove('active');
    });

    co.style.display = "block";
    setTimeout(function () {
      co.classList.add('active');
      pu.classList.add('active');
    }, 100);

    clearTimeout(this.timeout);
    this.timeout = setTimeout(() => {
      pu.classList.remove('active');
      co.classList.remove('active');

      setTimeout(() => {
        co.style.display = 'none';
        this.submit_element.classList.remove('disabled');
      }, 500)
    }, 3000);
  }

  success() {
    let co = (document.getElementById('cover') as HTMLDivElement);
    let pu = (document.getElementById('success') as HTMLDivElement);

    co.querySelectorAll('.popup').forEach(function (item) {
      item.classList.remove('active');
    });

    co.style.display = "block";
    setTimeout(function () {
      co.classList.add('active');
      pu.classList.add('active');
    }, 100);

    clearTimeout(this.timeout);
    this.timeout = setTimeout(() => {
      pu.classList.remove('active');
      co.classList.remove('active');

      setTimeout(function () {
        co.style.display = 'none';
      }, 500);

      this.form.reset();
      this.updateLabels();
    }, 3000);

  }

}
