<?php

/*!
This script compiles a given code file (except python code files) for a user using the compiler correponding to the language
of the code file, using system() function.
*/

header("Access-Control-Allow-Origin: *");
header('Access-Control-Allow-Credentials: true');
header("Access-Control-Allow-Methods: PUT, GET, POST, DELETE");
header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
header("Content-Type: application/json; charset=UTF-8");

$postData = file_get_contents("php://input");
$postData = json_decode($postData, true);

$uname = $postData['username'];
$filename = $postData['filename'];
$language = $postData['language'];

$ret_stat = 0;

if(strcmp($language, ".cpp") == 0)
{
    system("g++ ../users/" . $uname . "/" . $filename . ".cpp -o ../users/" . $uname . "/" . $filename , $ret_stat);
    if($ret_stat != 0)
    {
        unlink("../users/" . $uname . "/" . $filename);
        throw new Exception("Compilation Error!");
    }
}

else if(strcmp($language, ".java") == 0)
{
    system("javac ../users/" . $uname . "/" . $filename . '.java', $ret_stat);

    if($ret_stat != 0)
    {
        unlink("../users/" . $uname . "/" . $filename . ".class");
        throw new Exception("Compilation Error!");
    }
}

echo $ret_stat;
?>
