import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
declare const CodeMirror: any;

@Component({
  selector: 'app-ide',
  templateUrl: './ide.component.html',
  styleUrls: ['./ide.component.scss']
})
export class IdeComponent implements OnInit {

  constructor(public router: Router) { }

  ngOnInit(): void {
    var editor_area = document.getElementById('editor');
    var editor = CodeMirror.fromTextArea(editor_area, {
      lineNumbers: true,
      theme: "material-ocean",
      mode: "text/x-c++src",
      autoCloseBrackets: true,
      matchBrackets: true
    });
    editor.setSize("auto", "70vh");
    Object.assign((document.getElementsByClassName('CodeMirror')[0] as HTMLTextAreaElement).style, {
      border: "2px solid #ddf",
      padding: "20px",
      fontFamily: "\"Anonymous Pro\", monospace",
    });

    var active_lang = 0;
    var langs = ["C++", "Python", "Java"];
    var langs_mime = ["text/x-c++src", "text/x-python", "text/x-java"];
    var default_code = [`#include <iostream>
using namespace std;

int main() {
  cout << "Hello World!\\n";
  return 0;
}`, `print("Hello World!")`, `class HelloWorld {
    public static void main(String[] args) {
        System.out.println("Hello, World!"); 
    }
}`]

    editor.setValue(default_code[active_lang]);
    document.getElementById('toggle-lang').onclick = function () {
      let th = this as HTMLDivElement;
      active_lang = (active_lang + 1) % 3;
      th.innerHTML = langs[active_lang];
      editor.setValue(default_code[active_lang]);
      editor.setOption("mode", langs_mime[active_lang]);
    }

  }

}
