import {Component, Input, OnInit} from '@angular/core';
import {Problem} from '../problem';
import {RunCodeService} from '../run-code.service';

@Component({
  selector: 'app-submit-try-code',
  templateUrl: './submit-try-code.component.html',
  styleUrls: ['./submit-try-code.component.scss']
})
export class SubmitTryCodeComponent implements OnInit {

  isActive = false;
  nts: number[];
  status: number[];
  @Input() problem: Problem;
  submitting = 0;

  constructor(public runCodeService: RunCodeService) { }

  ngOnInit(): void { }

  reset(): void {
    this.nts = Array(this.problem.n_testcases[this.submitting]).fill(1).map((x, i) => i);
    this.status = Array(this.problem.n_testcases[this.submitting]).fill(0);

    for (const i of this.nts) {
      this.runCodeService.tryTestcase(this.problem, i)
        .subscribe(ret => {
          this.status[i] = ret ? 1 : -1;
        });
    }
  }

}
