import {Component, OnInit, ViewChild} from '@angular/core';
import {Router} from '@angular/router';
import {Problem} from '../problem';
import {ProblemService} from '../problem.service';
import {ApiService} from '../api.service';
import {InputComponent} from '../input/input.component';
import {SubmitTryCodeComponent} from '../submit-try-code/submit-try-code.component';
import {RunCodeService} from '../run-code.service';

declare const CodeMirror: any;

@Component({
  selector: 'app-arena',
  templateUrl: './arena.component.html',
  styleUrls: ['./arena.component.scss']
})
export class ArenaComponent implements OnInit {

  id: number;
  problem: Problem;
  customInput = '';
  compilationError = false;
  isCompiling = false;

  @ViewChild(InputComponent) inputField: InputComponent;
  @ViewChild(SubmitTryCodeComponent) submitField: SubmitTryCodeComponent;

  constructor(public router: Router, private problemService: ProblemService, private apiService: ApiService,
              private runCodeService: RunCodeService) {
  }

  ngOnInit(): void {
    this.id = parseInt(this.router.url.split('/')[3], 10);
    this.getProblem();
    const editorArea = document.getElementById('editor');
    const editor = CodeMirror.fromTextArea(editorArea as HTMLTextAreaElement, {
      lineNumbers: true,
      theme: 'material-ocean',
      mode: 'text/x-c++src',
      autoCloseBrackets: true,
      matchBrackets: true
    });
    editor.setSize('auto', '70vh');
    editor.setValue(this.problem.code[0]);
    Object.assign((document.getElementsByClassName('CodeMirror')[0] as HTMLTextAreaElement).style, {
      borderBottom: '1px solid #ddf',
      padding: '20px',
      fontFamily: '"Anonymous Pro", monospace',
    });

    let activeLang = 0;
    const langs = ['C++', 'Python', 'Java'];
    const extensions = ['.cpp', '.py', '.java'];
    const langsMime = ['text/x-c++src', 'text/x-python', 'text/x-java'];

    const problem = this.problem;

    document.getElementById('toggle-lang').onclick = function(): void {
      const th = this as HTMLDivElement;
      activeLang = (activeLang + 1) % 3;
      th.innerHTML = langs[activeLang];
      editor.setValue(problem.code[activeLang]);
      editor.setOption('mode', langsMime[activeLang]);
    };

    editor.on('update', () => {
      this.problem.code[activeLang] = editor.getValue();
    });

  }

  getProblem(): void {
    this.problemService.getProblems()
      .subscribe(problems => {
        this.problem = problems.find(i => i.id === this.id);
      });
  }

  tryCode(c): void {
    if (document.getElementById('try').classList.contains('disabled')) {return; }
    this.isCompiling = true;
    this.runCodeService.compileProblemFile(this.problem)
      .subscribe(data => {
        this.submitField.submitting = c;
        this.submitField.reset();
        this.submitField.isActive = true;
        this.isCompiling = false;
      }, error => {
        this.isCompiling = false;
        this.compilationError = true;
        setTimeout(() => {
          this.compilationError = false;
        }, 3000);
      });
  }

}
