import {Component, OnInit, ViewChild} from '@angular/core';
import {Router} from '@angular/router';
import {InputComponent} from '../input/input.component';
import {IdeCompileComponent} from '../ide-compile/ide-compile.component';
import {RunCodeService} from '../run-code.service';
import {SaveFileComponent} from '../save-file/save-file.component';
import {File} from '../file';
import {FileService} from '../file.service';
import {ApiService} from '../api.service';

declare const CodeMirror: any;

@Component({
  selector: 'app-ide',
  templateUrl: './ide.component.html',
  styleUrls: ['./ide.component.scss']
})
export class IdeComponent implements OnInit {

  inp = '';
  extensions = ['.cpp', '.py', '.java'];
  isSaved = false;
  isUploading = false;
  isUpToDate = false;
  file: File = {
    id: null,
    filename: 'Untitled',
    language: '.cpp',
    text: '',
    username: JSON.parse(this.apiService.getToken()).username,
  };
  @ViewChild(InputComponent) inputField;
  @ViewChild(IdeCompileComponent) runField;
  @ViewChild(SaveFileComponent) saveField;

  constructor(public router: Router, public runCodeService: RunCodeService, private fileService: FileService,
              private apiService: ApiService) {
  }

  ngOnInit(): void {
    const editorArea = document.getElementById('editor');
    const editor = CodeMirror.fromTextArea(editorArea as HTMLTextAreaElement, {
      lineNumbers: true,
      theme: 'material-ocean',
      mode: 'text/x-c++src',
      autoCloseBrackets: true,
      matchBrackets: true
    });
    editor.setSize('auto', '70vh');
    Object.assign((document.getElementsByClassName('CodeMirror')[0] as HTMLTextAreaElement).style, {
      borderBottom: '1px solid #ddf',
      padding: '20px',
      fontFamily: '"Anonymous Pro", monospace',
    });

    let activeLang = 0;
    const langs = ['C++', 'Python', 'Java'];
    const langsMime = ['text/x-c++src', 'text/x-python', 'text/x-java'];
    const code = [`#include <iostream>
using namespace std;

int main() {
  cout << "Hello World!\\n";
  return 0;
}`, `print("Hello World!")`, `class HelloWorld {
    public static void main(String[] args) {
        System.out.println("Hello, World!");
    }
}`];

    editor.setValue(code[activeLang]);
    this.file.text = code[activeLang];
    const tl = document.getElementById('toggle-lang') as HTMLDivElement;
    tl.onclick = () => {
      activeLang = (activeLang + 1) % 3;
      this.file.language = this.extensions[activeLang];
      tl.innerHTML = langs[activeLang];
      editor.setValue(code[activeLang]);
      editor.setOption('mode', langsMime[activeLang]);
    };

    editor.on('update', () => {
      if (!this.isUploading) {
        this.isUpToDate = false;
        document.getElementById('saveBtn').innerHTML = 'Save File';
      }
      code[activeLang] = editor.getValue();
      this.file.text = editor.getValue();
    });

  }

  updateInput(val: string): void {
    this.inp = val;
  }

  updateFile(): void {
    const btn = document.getElementById('saveBtn') as HTMLButtonElement;
    if (btn.classList.contains('disabled')) {
      return;
    }
    this.isUploading = true;
    btn.innerHTML = 'Saving...';
    this.fileService.upload(this.file)
      .subscribe(data => {
        btn.innerHTML = 'Saved';
        this.isUploading = false;
        this.isUpToDate = true;
      }, error => {
        console.log(error);
        this.isUploading = false;
        btn.innerHTML = 'Save File';
      });
  }
}
